/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.keystore.ckx;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.MacData;
import java.math.BigInteger;

public class Ckx
extends ASN1Object {
    private ContentInfo contentInfo;
    private MacData macData = null;

    private Ckx(ASN1Sequence seq) {
        BigInteger version = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        if (version.intValue() != 1) {
            throw new IllegalArgumentException("wrong version for PFX PDU");
        }
        this.contentInfo = ContentInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() == 3) {
            this.macData = MacData.getInstance(seq.getObjectAt(2));
        }
    }

    public static Ckx getInstance(Object obj) {
        if (obj instanceof Ckx) {
            return (Ckx)obj;
        }
        if (obj != null) {
            return new Ckx(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Ckx(ContentInfo contentInfo, MacData macData) {
        this.contentInfo = contentInfo;
        this.macData = macData;
    }

    public ContentInfo getAuthSafe() {
        return this.contentInfo;
    }

    public MacData getMacData() {
        return this.macData;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1L));
        v.add(this.contentInfo);
        if (this.macData != null) {
            v.add(this.macData);
        }
        return new BERSequence(v);
    }
}

