/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.keystore.ckx;

import cn.com.infosec.jcajce.provider.keystore.ckx.CkxUtil;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class DuoPair {
    private String signAlias;
    private PrivateKey signKey;
    private Certificate signCert;
    private String encAlias;
    private PrivateKey encKey;
    private Certificate encCert;

    public DuoPair(String signAlias, PrivateKey signKey, Certificate signCert, String encAlias, PrivateKey encKey, Certificate encCert) {
        this.signAlias = signAlias;
        this.signKey = signKey;
        this.signCert = signCert;
        this.encAlias = encAlias;
        this.encKey = encKey;
        this.encCert = encCert;
    }

    public DuoPair(PrivateKey signKey, Certificate signCert, PrivateKey encKey, Certificate encCert) {
        this(null, signKey, signCert, null, encKey, encCert);
    }

    public DuoPair() {
    }

    public String getSignAlias() {
        return this.signAlias;
    }

    public String getEncAlias() {
        return this.encAlias;
    }

    public PrivateKey getSignKey() {
        return this.signKey;
    }

    public Certificate getSignCert() {
        return this.signCert;
    }

    public PrivateKey getEncKey() {
        return this.encKey;
    }

    public Certificate getEncCert() {
        return this.encCert;
    }

    public void setSignKey(PrivateKey signKey) {
        this.signKey = signKey;
    }

    public void setSignCert(Certificate signCert) {
        this.signCert = signCert;
    }

    public void setEncKey(PrivateKey encKey) {
        this.encKey = encKey;
    }

    public void setEncCert(Certificate encCert) {
        this.encCert = encCert;
    }

    public void checkMatch() {
        if (!CkxUtil.keyMatch(this.signKey, this.signCert.getPublicKey())) {
            try {
                throw new KeyException("[sign] certificate not matches private key\n" + this.signCert.toString());
            }
            catch (KeyException e) {
                e.printStackTrace();
            }
        }
        if (!CkxUtil.keyMatch(this.encKey, this.encCert.getPublicKey())) {
            try {
                throw new KeyException("[enc] certificate not matches private key\n" + this.encCert.toString());
            }
            catch (KeyException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "DuoPair{signAlias='" + this.signAlias + '\'' + ", signKey=" + this.signKey.getAlgorithm() + ", signCert=" + this.signCert.getType() + ", encAlias='" + this.encAlias + '\'' + ", encKey=" + this.encKey.getAlgorithm() + ", encCert=" + this.encCert.getType() + '}';
    }
}

