/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.engines.Grainv1Engine;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseStreamCipher;
import cn.com.infosec.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;

public final class Grainv1 {
    private Grainv1() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Grainv1.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Grainv1", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.Grainv1", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Grainv1", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Grainv1 IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Grainv1", 80, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Grainv1Engine(), 8);
        }
    }
}

