/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.engines.NoekeonEngine;
import cn.com.infosec.crypto.generators.Poly1305KeyGenerator;
import cn.com.infosec.crypto.macs.GMac;
import cn.com.infosec.crypto.modes.GCMBlockCipher;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;
import cn.com.infosec.jcajce.provider.symmetric.util.BlockCipherProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class Noekeon {
    private Noekeon() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Noekeon.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.NOEKEON", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.NOEKEON", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.NOEKEON", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.NOEKEON", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "NOEKEON", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "NOEKEON", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Noekeon IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Noekeon parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("Noekeon");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Noekeon", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cn.com.infosec.crypto.macs.Poly1305(new NoekeonEngine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new NoekeonEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Noekeon", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new NoekeonEngine();
                }
            });
        }
    }
}

