/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.asn1.misc.MiscObjectIdentifiers;
import cn.com.infosec.crypto.PasswordConverter;
import cn.com.infosec.crypto.generators.SCrypt;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import cn.com.infosec.jcajce.provider.symmetric.util.INFOSECPBEKey;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;
import cn.com.infosec.jcajce.spec.ScryptKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SCRYPT {
    private SCRYPT() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = SCRYPT.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecretKeyFactory.SCRYPT", PREFIX + "$ScryptWithUTF8");
            provider.addAlgorithm("SecretKeyFactory", MiscObjectIdentifiers.id_scrypt, PREFIX + "$ScryptWithUTF8");
        }
    }

    public static class ScryptWithUTF8
    extends BasePBKDF2 {
        public ScryptWithUTF8() {
            super("SCRYPT", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF2(String name, int scheme) {
            super(name, MiscObjectIdentifiers.id_scrypt);
            this.scheme = scheme;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ScryptKeySpec) {
                ScryptKeySpec pbeSpec = (ScryptKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new IllegalArgumentException("Salt S must be provided.");
                }
                if (pbeSpec.getCostParameter() <= 1) {
                    throw new IllegalArgumentException("Cost parameter N must be > 1.");
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                PasswordConverter func = PasswordConverter.UTF8;
                KeyParameter param = new KeyParameter(SCrypt.generate(func.convert(pbeSpec.getPassword()), pbeSpec.getSalt(), pbeSpec.getCostParameter(), pbeSpec.getBlockSize(), pbeSpec.getParallelizationParameter(), pbeSpec.getKeyLength() / 8));
                return new INFOSECPBEKey(this.algName, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

