/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.CryptoServicesRegistrar;
import cn.com.infosec.crypto.PasswordConverter;
import cn.com.infosec.crypto.engines.SM4Engine;
import cn.com.infosec.crypto.generators.Poly1305KeyGenerator;
import cn.com.infosec.crypto.macs.CMac;
import cn.com.infosec.crypto.macs.GMac;
import cn.com.infosec.crypto.modes.CBCBlockCipher;
import cn.com.infosec.crypto.modes.GCMBlockCipher;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.jcajce.PBKDF1Key;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import cn.com.infosec.jcajce.provider.symmetric.util.BlockCipherProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.INFOSECPBEKey;
import cn.com.infosec.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.com.infosec.jcajce.provider.symmetric.util.PBE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;

public final class SM4 {
    private SM4() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SM4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SM4", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.SM4", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + GMObjectIdentifiers.sms4_cbc, "SM4");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + GMObjectIdentifiers.sms4_ecb, "SM4");
            provider.addAlgorithm("Cipher.SM4", PREFIX + "$ECB");
            provider.addAlgorithm("Cipher", GMObjectIdentifiers.sms4_cbc, PREFIX + "$CBC");
            provider.addAlgorithm("KeyGenerator.SM4", PREFIX + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", GMObjectIdentifiers.sms4_cbc, PREFIX + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", GMObjectIdentifiers.sms4_ecb, PREFIX + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", GMObjectIdentifiers.sms4_ctr, PREFIX + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", GMObjectIdentifiers.sms4_ccm, PREFIX + "$KeyGen");
            provider.addAlgorithm("SecretKeyFactory.SM4", PREFIX + "$KeyFactory");
            this.addCMacAlgorithm(provider, "SM4", PREFIX + "$CMAC", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "SM4", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "SM4", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
            provider.addAlgorithm("Cipher.PBEWITHSM3ANDSM4", PREFIX + "$PBEWithSM3");
            provider.addAlgorithm("Alg.Alias.Cipher.PBEWITHSM3ANDSM4-CBC", "PBEWITHSM3ANDSM4");
            provider.addAlgorithm("SecretKeyFactory.PBEWITHSM3ANDSM4", PREFIX + "$PBEWITHSM3KeyFactory");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHSM3ANDSM4-CBC", "PBEWITHSM3ANDSM4");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory." + GMObjectIdentifiers.id_PBES, "PBEWITHSM3ANDSM4");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("SM4");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class SM4PBEKeyFactory
    extends BaseSecretKeyFactory {
        private boolean forCipher;
        private int scheme;
        private int digest;
        private int keySize;
        private int ivSize;

        public SM4PBEKeyFactory(String algorithm, ASN1ObjectIdentifier oid, boolean forCipher, int scheme, int digest, int keySize, int ivSize) {
            super(algorithm, oid);
            this.forCipher = forCipher;
            this.scheme = scheme;
            this.digest = digest;
            this.keySize = keySize;
            this.ivSize = ivSize;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    if (this.scheme == 0 || this.scheme == 4) {
                        return new PBKDF1Key(pbeSpec.getPassword(), this.scheme == 0 ? PasswordConverter.ASCII : PasswordConverter.UTF8);
                    }
                    return new INFOSECPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pbeSpec, null);
                }
                CipherParameters param = this.forCipher ? PBE.Util.makePBEParameters(pbeSpec, this.scheme, this.digest, this.keySize, this.ivSize) : PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, this.digest, this.keySize);
                if (param instanceof ParametersWithIV) {
                    KeyParameter kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                } else {
                    KeyParameter kParam = (KeyParameter)param;
                }
                return new INFOSECPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }

    public static class PBEWithSM3
    extends BaseBlockCipher {
        public PBEWithSM3() {
            super(new CBCBlockCipher(new SM4Engine()), 1, 14, 128, 128);
        }
    }

    public static class PBEWITHSM3KeyFactory
    extends SM4PBEKeyFactory {
        public PBEWITHSM3KeyFactory() {
            super("PBEwithSM3andSM4", GMObjectIdentifiers.id_PBES, true, 1, 14, 128, 128);
        }
    }

    public static class KeyFactory
    extends BaseSecretKeyFactory {
        public KeyFactory() {
            super("SM4", null);
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SM4", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cn.com.infosec.crypto.macs.Poly1305(new SM4Engine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SM4Engine())));
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SM4Engine()));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SM4", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SM4Engine();
                }
            });
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SM4Engine()), 128);
        }
    }
}

