/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.provider.symmetric;

import cn.com.infosec.crypto.CipherKeyGenerator;
import cn.com.infosec.crypto.engines.VMPCEngine;
import cn.com.infosec.crypto.macs.VMPCMac;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseMac;
import cn.com.infosec.jcajce.provider.symmetric.util.BaseStreamCipher;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;

public final class VMPC {
    private VMPC() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = VMPC.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.VMPC", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.VMPC", PREFIX + "$KeyGen");
            provider.addAlgorithm("Mac.VMPCMAC", PREFIX + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC", "VMPCMAC");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new VMPCMac());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("VMPC", 128, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new VMPCEngine(), 16);
        }
    }
}

