/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jcajce.util;

import cn.com.infosec.common.logging.Logger;
import cn.com.infosec.common.logging.LoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);

    static String getSecurityProperty(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(propertyName);
            }
        });
    }

    public static String getSystemProperty(final String propertyName) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }
            });
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to get system property" + e.getMessage());
            return null;
        }
    }

    public static boolean getBooleanSystemProperty(String propertyName, boolean defaultValue) {
        String propertyValue = PropertyUtils.getSystemProperty(propertyName);
        if (null != propertyValue) {
            if ("true".equals(propertyValue)) {
                LOG.info("Found boolean system property [" + propertyName + "]: " + true);
                return true;
            }
            if ("false".equals(propertyValue)) {
                LOG.info("Found boolean system property [" + propertyName + "]: " + false);
                return false;
            }
            LOG.warn("Unrecognized value for boolean system property [" + propertyName + "]: " + propertyValue);
        }
        LOG.warn("Boolean system property [" + propertyName + "] defaulted to: " + defaultValue);
        return defaultValue;
    }

    public static int getIntegerSystemProperty(String propertyName, int defaultValue, int minimumValue, int maximumValue) {
        String propertyValue = PropertyUtils.getSystemProperty(propertyName);
        if (null != propertyValue) {
            try {
                int parsedValue = Integer.parseInt(propertyValue);
                if (parsedValue >= minimumValue && parsedValue <= maximumValue) {
                    LOG.info("Found integer system property [" + propertyName + "]: " + parsedValue);
                    return parsedValue;
                }
                if (LOG.isWarnEnabled()) {
                    String range = PropertyUtils.getRangeString(minimumValue, maximumValue);
                    LOG.warn("Out-of-range (" + range + ") integer system property [" + propertyName + "]: " + propertyValue);
                }
            }
            catch (Exception e) {
                LOG.warn("Unrecognized value for integer system property [" + propertyName + "]: " + propertyValue);
            }
        }
        LOG.info("Integer system property [" + propertyName + "] defaulted to: " + defaultValue);
        return defaultValue;
    }

    public static String getStringSystemProperty(String propertyName) {
        String propertyValue = PropertyUtils.getSystemProperty(propertyName);
        if (null != propertyValue) {
            LOG.info("Found string system property [" + propertyName + "]: " + propertyValue);
            return propertyValue;
        }
        return null;
    }

    private static String getRangeString(int minimumValue, int maximumValue) {
        StringBuilder sb = new StringBuilder(32);
        if (Integer.MIN_VALUE != minimumValue) {
            sb.append(minimumValue);
            sb.append(" <= ");
        }
        sb.append('x');
        if (Integer.MAX_VALUE != maximumValue) {
            sb.append(" <= ");
            sb.append(maximumValue);
        }
        return sb.toString();
    }
}

