/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.jcajce.provider.config.ConfigurableProvider;
import cn.com.infosec.jcajce.provider.config.ProviderConfiguration;
import cn.com.infosec.jcajce.provider.symmetric.util.ClassUtil;
import cn.com.infosec.jcajce.provider.util.AlgorithmProvider;
import cn.com.infosec.jcajce.provider.util.AsymmetricKeyInfoConverter;
import cn.com.infosec.jce.provider.INFOSECProviderConfiguration;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public final class INFOSECProvider
extends Provider
implements ConfigurableProvider {
    private static String ippInfo = "IPP INFOSEC Security Provider v2.0.0.1 IPP";
    private static String info = "INFOSEC Security Provider v1.0.0.0";
    public static final String PROVIDER_NAME = "INFOSEC";
    public static final ProviderConfiguration CONFIGURATION = new INFOSECProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final String SYMMETRIC_PACKAGE = "cn.com.infosec.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT", "Q5PBKDF"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "Poly1305"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "ARIA", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF", "DSTU7624", "GOST3412_2015"};
    private static final String ASYMMETRIC_PACKAGE = "cn.com.infosec.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "EdEC", "SM2", "SM9"};
    private static final String DIGEST_PACKAGE = "cn.com.infosec.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "IPPSM3"};
    private static final String KEYSTORE_PACKAGE = "cn.com.infosec.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12", "CKX"};
    private static final String SECURE_RANDOM_PACKAGE = "cn.com.infosec.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};

    public INFOSECProvider() {
        super(PROVIDER_NAME, 1.0, ippInfo);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                INFOSECProvider.this.setup();
                return null;
            }
        });
    }

    public INFOSECProvider(String provider) {
        super(provider, 1.0, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                INFOSECProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        this.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        this.loadAlgorithms(SECURE_RANDOM_PACKAGE, SECURE_RANDOMS);
        this.put("X509Store.CERTIFICATE/COLLECTION", "cn.com.infosec.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "cn.com.infosec.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "cn.com.infosec.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "cn.com.infosec.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "cn.com.infosec.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "cn.com.infosec.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "cn.com.infosec.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "cn.com.infosec.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "cn.com.infosec.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "cn.com.infosec.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "cn.com.infosec.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "cn.com.infosec.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "cn.com.infosec.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "cn.com.infosec.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "cn.com.infosec.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        this.put("CertPathValidator.RFC3281", "cn.com.infosec.jce.provider.PKIXAttrCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3281", "cn.com.infosec.jce.provider.PKIXAttrCertPathBuilderSpi");
        this.put("CertPathValidator.RFC3280", "cn.com.infosec.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3280", "cn.com.infosec.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathValidator.PKIX", "cn.com.infosec.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "cn.com.infosec.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertStore.Collection", "cn.com.infosec.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "cn.com.infosec.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "cn.com.infosec.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i = 0; i != names.length; ++i) {
            Class clazz = ClassUtil.loadClass(INFOSECProvider.class, packageName + names[i] + "$Mappings");
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception e) {
                throw new InternalError("cannot create instance of " + packageName + names[i] + "$Mappings : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String parameterName, Object parameter) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((INFOSECProviderConfiguration)CONFIGURATION).setParameter(parameterName, parameter);
        }
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + "." + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(oid, keyInfoConverter);
        }
    }

    @Override
    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (String attributeName : attributeMap.keySet()) {
            String attributeKey = key + " " + attributeName;
            if (this.containsKey(attributeKey)) {
                throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
            }
            this.put(attributeKey, attributeMap.get(attributeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier algorithm) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(algorithm);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = INFOSECProvider.getAsymmetricKeyInfoConverter(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = INFOSECProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }
}

