/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.math.ec;

import cn.com.infosec.math.ec.AbstractECMultiplier;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.math.ec.WNafUtil;
import java.math.BigInteger;

public class NafL2RMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        int[] naf = WNafUtil.generateCompactNaf(k);
        ECPoint addP = p.normalize();
        ECPoint subP = addP.negate();
        ECPoint R = p.getCurve().getInfinity();
        int i = naf.length;
        while (--i >= 0) {
            int ni = naf[i];
            int digit = ni >> 16;
            int zeroes = ni & 0xFFFF;
            R = R.twicePlus(digit < 0 ? subP : addP);
            R = R.timesPow2(zeroes);
        }
        return R;
    }
}

