/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.operator.AsymmetricKeyUnwrapper;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OperatorException;

public abstract class InfosecAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private AsymmetricKeyParameter privateKey;

    public InfosecAsymmetricKeyUnwrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter privateKey) {
        super(encAlgId);
        this.privateKey = privateKey;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        AsymmetricBlockCipher keyCipher = this.createAsymmetricUnwrapper(this.getAlgorithmIdentifier().getAlgorithm());
        keyCipher.init(false, this.privateKey);
        try {
            byte[] key = keyCipher.processBlock(encryptedKey, 0, encryptedKey.length);
            if (encryptedKeyAlgorithm.getAlgorithm().equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
                return new GenericKey(encryptedKeyAlgorithm, key);
            }
            return new GenericKey(encryptedKeyAlgorithm, key);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to recover secret key: " + e.getMessage(), e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricUnwrapper(ASN1ObjectIdentifier var1);
}

