/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.operator.infosec;

import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.Wrapper;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OperatorException;
import cn.com.infosec.operator.SymmetricKeyUnwrapper;
import java.security.SecureRandom;

public class InfosecSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public InfosecSymmetricKeyUnwrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public InfosecSymmetricKeyUnwrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(encryptedKeyAlgorithm, this.wrapper.unwrap(encryptedKey, 0, encryptedKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to unwrap key: " + e.getMessage(), e);
        }
    }
}

