/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.asn1.pkcs.MacData;
import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.operator.MacCalculator;
import cn.com.infosec.pkcs.PKCS12MacCalculatorBuilder;
import cn.com.infosec.pkcs.PKCSException;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder builder) {
        this.builder = builder;
    }

    public MacData build(char[] password, byte[] data) throws PKCSException {
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(password);
            OutputStream out = macCalculator.getOutputStream();
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            throw new PKCSException("unable to process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier algId = macCalculator.getAlgorithmIdentifier();
        DigestInfo dInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
        return new MacData(dInfo, params.getIV(), params.getIterations().intValue());
    }
}

