/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs.infosec;

import cn.com.infosec.asn1.ASN1ObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PKCS12PBEParams;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.BufferedBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.ExtendedDigest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.generators.PKCS12ParametersGenerator;
import cn.com.infosec.crypto.io.CipherOutputStream;
import cn.com.infosec.crypto.paddings.PKCS7Padding;
import cn.com.infosec.crypto.paddings.PaddedBufferedBlockCipher;
import cn.com.infosec.operator.GenericKey;
import cn.com.infosec.operator.OutputEncryptor;
import cn.com.infosec.pkcs.infosec.PKCS12PBEUtils;
import java.io.OutputStream;
import java.security.SecureRandom;

public class InfosecPKCS12PBEOutputEncryptorBuilder {
    private ExtendedDigest digest;
    private BufferedBlockCipher engine;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int iterationCount = 1024;

    public InfosecPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine) {
        this(algorithm, engine, new SHA1Digest());
    }

    public InfosecPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine, ExtendedDigest pbeDigest) {
        this.algorithm = algorithm;
        this.engine = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
        this.digest = pbeDigest;
    }

    public InfosecPKCS12PBEOutputEncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public OutputEncryptor build(final char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        this.random.nextBytes(salt);
        final PKCS12PBEParams pbeParams = new PKCS12PBEParams(salt, this.iterationCount);
        CipherParameters params = PKCS12PBEUtils.createCipherParameters(this.algorithm, this.digest, this.engine.getBlockSize(), pbeParams, password);
        this.engine.init(true, params);
        return new OutputEncryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(InfosecPKCS12PBEOutputEncryptorBuilder.this.algorithm, pbeParams);
            }

            @Override
            public OutputStream getOutputStream(OutputStream out) {
                return new CipherOutputStream(out, InfosecPKCS12PBEOutputEncryptorBuilder.this.engine);
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(new AlgorithmIdentifier(InfosecPKCS12PBEOutputEncryptorBuilder.this.algorithm, pbeParams), PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
            }
        };
    }
}

