/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.util;

public class ByteArrayUtil {
    public static boolean equal(byte[] r1, byte[] r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null && r2 != null) {
            return false;
        }
        if (r1 != null && r2 == null) {
            return false;
        }
        if (r1.length != r2.length) {
            return false;
        }
        for (int i = 0; i < r2.length; ++i) {
            if (r1[i] == r2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(byte[] arr) {
        if (arr == null) {
            return true;
        }
        return arr.length == 0;
    }

    public static byte[] intToByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] intArrayToByteArray(int[] in, int offset, int len) {
        int bytelen = len * 4;
        int off = offset + len;
        byte[] result = new byte[bytelen];
        int i = offset;
        int j = 0;
        while (i < off) {
            result[j + 3] = (byte)(in[i] >> 24 & 0xFF);
            result[j + 2] = (byte)(in[i] >> 16 & 0xFF);
            result[j + 1] = (byte)(in[i] >> 8 & 0xFF);
            result[j] = (byte)(in[i] & 0xFF);
            ++i;
            j += 4;
        }
        return result;
    }

    public static int[] byteArrayTointArray(byte[] buf) {
        int[] intArr = new int[buf.length / 4];
        int offset = 0;
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = (buf[3 + offset] & 0xFF) << 24 | (buf[2 + offset] & 0xFF) << 16 | (buf[1 + offset] & 0xFF) << 8 | buf[0 + offset] & 0xFF;
            offset += 4;
        }
        return intArr;
    }

    public static byte[] int2byte(int[] src) {
        int srcLength = src.length;
        byte[] dst = new byte[srcLength << 2];
        for (int i = 0; i < srcLength; ++i) {
            int x = src[i];
            int j = i << 2;
            dst[j++] = (byte)(x >>> 0 & 0xFF);
            dst[j++] = (byte)(x >>> 8 & 0xFF);
            dst[j++] = (byte)(x >>> 16 & 0xFF);
            dst[j++] = (byte)(x >>> 24 & 0xFF);
        }
        return dst;
    }
}

