/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.util;

public class FormatBytesUtil {
    public static short getShortFromBytes(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static int getIntFromBytes(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static byte[] getByteOfShort(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytesOfInt(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getTimestamp() {
        int i = (int)(System.currentTimeMillis() / 1000L);
        byte[] time = FormatBytesUtil.getBytesOfInt(i);
        return time;
    }

    public static byte[] copyByteToAnother(byte[] to, byte[] from) {
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    public static byte[] copyByteToAnother(byte[] to, int outoffset, byte[] from, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            to[i + outoffset] = from[i + offset];
        }
        return to;
    }

    public static byte[] copyByteToAnother(byte[] from, int offset, int len) {
        byte[] to = new byte[len];
        for (int i = 0; i < len; ++i) {
            to[i] = from[i + offset];
        }
        return to;
    }

    public static byte[] getBytesFromString(byte[] bytes, String string) {
        for (int i = 0; i < string.length(); ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        return bytes;
    }

    public static byte[] byteMerger(byte[] byte1, byte[] byte2) {
        byte[] byte3 = new byte[byte1.length + byte2.length];
        System.arraycopy(byte1, 0, byte3, 0, byte1.length);
        System.arraycopy(byte2, 0, byte3, byte1.length, byte2.length);
        return byte3;
    }

    public static byte[] concatAll(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (int i = 0; i < rest.length; ++i) {
            if (rest[i] == null) continue;
            totalLength += rest[i].length;
        }
        byte[] result = new byte[totalLength];
        System.arraycopy(first, 0, result, 0, first.length);
        int offset = first.length;
        for (int i = 0; i < rest.length; ++i) {
            if (rest[i] == null) continue;
            System.arraycopy(rest[i], 0, result, offset, rest[i].length);
            offset += rest[i].length;
        }
        return result;
    }

    public static String bytesToHexString(byte[] ba) {
        String s = "";
        for (int i = 0; i < ba.length; ++i) {
            s = s + String.format("%02X", ba[i]);
        }
        return s;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(FormatBytesUtil.charToByte(hexChars[pos]) << 4 | FormatBytesUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

