/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.ProvSSLSocketWrap;

class ProvSSLSocketFactory
extends SSLSocketFactory {
    protected final ProvSSLContextSpi context;

    ProvSSLSocketFactory(ProvSSLContextSpi context) {
        this.context = context;
    }

    @Override
    public Socket createSocket() throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData());
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap(this.context, this.context.createContextData(), s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.context.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }
}

