/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class BCJSSEClientTest {
    public static void main(String[] args) throws Exception {
        String line;
        Security.removeProvider("BC");
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        Security.removeProvider("BCJSSE");
        Security.insertProviderAt(new BouncyCastleJsseProvider(), 2);
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String subject = chain[0].getSubjectX500Principal().getName();
                System.out.println("Auto-trusted server certificate chain for: " + subject);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2", "BCJSSE");
        sslContext.init(null, new TrustManager[]{tm}, new SecureRandom());
        String host = "localhost";
        int port = 8443;
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(host, port);
        OutputStream output = sslSocket.getOutputStream();
        BCJSSEClientTest.writeUTF8Line(output, "GET / HTTP/1.1");
        BCJSSEClientTest.writeUTF8Line(output, "Host: " + host + ":" + port);
        BCJSSEClientTest.writeUTF8Line(output, "");
        output.flush();
        System.out.println("---");
        InputStream input = sslSocket.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            System.out.println("<<< " + line);
            if (!line.toUpperCase().contains("</HTML>")) continue;
        }
        System.out.flush();
        sslSocket.close();
    }

    private static void writeUTF8Line(OutputStream output, String line) throws IOException {
        output.write((line + "\r\n").getBytes("UTF-8"));
        System.out.println(">>> " + line);
    }
}

