/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.jsse.provider.test.SSLUtils;
import org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import org.bouncycastle.jsse.provider.test.TestUtils;

public class BasicTlsTest
extends TestCase {
    private static final String HOST = "localhost";
    private static final int PORT_NO = 9021;

    protected void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.addProvider(new BouncyCastleJsseProvider());
        }
    }

    public void testBasicTlsConnection() throws Exception {
        this.runTestBasicTlsConnection(false);
    }

    public void testBasicTlsConnectionLayered() throws Exception {
        this.runTestBasicTlsConnection(true);
    }

    public void testNullRandomJsseInit() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("ca", caCert);
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(ts);
        SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
        clientContext.init(null, trustMgrFact.getTrustManagers(), null);
    }

    protected void runTestBasicTlsConnection(boolean layered) throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("ca", caCert);
        TestProtocolUtil.runClientAndServer(new SimpleServer(ks, keyPass), new SimpleClient(layered, ts));
    }

    public static class SimpleServer
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore serverStore;
        private final char[] keyPass;
        private final CountDownLatch latch;

        SimpleServer(KeyStore serverStore, char[] keyPass) {
            this.serverStore = serverStore;
            this.keyPass = keyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.serverStore, this.keyPass);
                SSLContext serverContext = SSLContext.getInstance("TLS", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), null, SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(9021);
                SSLUtils.enableAll(sSock);
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                sslSock.setUseClientMode(false);
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class SimpleClient
    implements TestProtocolUtil.BlockingCallable {
        private final boolean layered;
        private final KeyStore trustStore;
        private final CountDownLatch latch;

        public SimpleClient(boolean layered, KeyStore trustStore) {
            this.layered = layered;
            this.trustStore = trustStore;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                SSLSocket cSock;
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                if (this.layered) {
                    Socket s = SocketFactory.getDefault().createSocket(BasicTlsTest.HOST, 9021);
                    cSock = (SSLSocket)fact.createSocket(s, BasicTlsTest.HOST, 9021, true);
                } else {
                    cSock = (SSLSocket)fact.createSocket(BasicTlsTest.HOST, 9021);
                }
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

