/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.security.Provider;
import java.security.Security;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class ConfigTest
extends TestCase {
    protected void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void testWithString() {
        String BC = "BC";
        BouncyCastleJsseProvider jsseProv = new BouncyCastleJsseProvider("fips:" + BC);
        ConfigTest.assertTrue((boolean)jsseProv.isFipsMode());
        jsseProv = new BouncyCastleJsseProvider(BC);
        ConfigTest.assertFalse((boolean)jsseProv.isFipsMode());
        jsseProv = new BouncyCastleJsseProvider("unknown:" + BC);
        ConfigTest.assertFalse((boolean)jsseProv.isFipsMode());
    }

    public void testWithProvider() {
        BouncyCastleJsseProvider jsseProv = new BouncyCastleJsseProvider(true, (Provider)new BouncyCastleProvider());
        ConfigTest.assertTrue((boolean)jsseProv.isFipsMode());
        jsseProv = new BouncyCastleJsseProvider((Provider)new BouncyCastleProvider());
        ConfigTest.assertFalse((boolean)jsseProv.isFipsMode());
    }
}

