/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Shorts;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable<Short, TlsHash> hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext context) {
        this.context = context;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    private DeferredHash(TlsContext context, Hashtable hashes) {
        this.context = context;
        this.buf = null;
        this.hashes = hashes;
        this.forceBuffering = false;
        this.sealed = true;
    }

    @Override
    public void copyBufferTo(OutputStream output) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyTo(output);
    }

    @Override
    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    @Override
    public TlsHandshakeHash notifyPRFDetermined() {
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            this.checkTrackingHash((short)1);
            this.checkTrackingHash((short)2);
        } else {
            this.checkTrackingHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        }
        return this;
    }

    @Override
    public void trackHashAlgorithm(short hashAlgorithm) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf((short)hashAlgorithm));
    }

    @Override
    public void sealHashAlgorithms() {
        if (!this.sealed) {
            this.sealed = true;
            this.checkStopBuffering();
        }
    }

    @Override
    public TlsHandshakeHash stopTracking() {
        Hashtable newHashes = new Hashtable();
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            this.cloneHash(newHashes, (short)1);
            this.cloneHash(newHashes, (short)2);
        } else {
            this.cloneHash(newHashes, TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        }
        return new DeferredHash(this.context, newHashes);
    }

    @Override
    public TlsHash forkPRFHash() {
        this.checkStopBuffering();
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        TlsHash prfHash = prfAlgorithm == 0 ? new CombinedHash(this.context, this.cloneHash((short)1), this.cloneHash((short)2)) : this.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        if (this.buf != null) {
            this.buf.updateDigest(prfHash);
        }
        return prfHash;
    }

    @Override
    public byte[] getFinalHash(short hashAlgorithm) {
        TlsHash d = this.hashes.get(Shorts.valueOf((short)hashAlgorithm));
        if (d == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(hashAlgorithm) + " is not being tracked");
        }
        d = (TlsHash)d.clone();
        if (this.buf != null) {
            this.buf.updateDigest(d);
        }
        return d.calculateHash();
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.buf != null) {
            this.buf.write(input, inOff, len);
            return;
        }
        Enumeration<TlsHash> e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = e.nextElement();
            hash.update(input, inOff, len);
        }
    }

    @Override
    public byte[] calculateHash() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    @Override
    public Object clone() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    @Override
    public void reset() {
        this.forceBuffering = false;
        this.sealed = false;
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration<TlsHash> e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = e.nextElement();
            hash.reset();
        }
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration<TlsHash> e = this.hashes.elements();
            while (e.hasMoreElements()) {
                TlsHash hash = e.nextElement();
                this.buf.updateDigest(hash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short hashAlgorithm) {
        if (!this.hashes.containsKey(hashAlgorithm)) {
            TlsHash hash = this.context.getCrypto().createHash(hashAlgorithm);
            this.hashes.put(hashAlgorithm, hash);
        }
    }

    protected TlsHash cloneHash(Short hashAlgorithm) {
        return (TlsHash)this.hashes.get(hashAlgorithm).clone();
    }

    protected void cloneHash(Hashtable newHashes, Short hashAlgorithm) {
        TlsHash hash = this.cloneHash(hashAlgorithm);
        if (this.buf != null) {
            this.buf.updateDigest(hash);
        }
        newHashes.put(hashAlgorithm, hash);
    }
}

