/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public abstract class TlsSM2Utils {
    private TlsSM2Utils() {
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsCertificate certificate, OutputStream output) throws IOException {
        TlsSecret preMasterSecret = context.getCrypto().generateSM2PreMasterSecret(context.getClientVersion());
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(certificate);
        byte[] trimedBlock = 145 == encryptedPreMasterSecret.length && 4 == encryptedPreMasterSecret[0] ? Arrays.copyOfRange((byte[])encryptedPreMasterSecret, (int)1, (int)encryptedPreMasterSecret.length) : encryptedPreMasterSecret;
        byte[] kx = Arrays.copyOfRange((byte[])trimedBlock, (int)0, (int)32);
        byte[] ky = Arrays.copyOfRange((byte[])trimedBlock, (int)kx.length, (int)(kx.length * 2));
        byte[] hash = Arrays.copyOfRange((byte[])trimedBlock, (int)(kx.length + ky.length), (int)(kx.length + ky.length + 32));
        byte[] cipherBytes = Arrays.copyOfRange((byte[])trimedBlock, (int)(kx.length + ky.length + hash.length), (int)trimedBlock.length);
        ASN1Integer kxASN1 = new ASN1Integer(kx);
        ASN1Integer kyASN1 = new ASN1Integer(ky);
        DEROctetString hashASN1 = new DEROctetString(hash);
        DEROctetString cipherASN1 = new DEROctetString(cipherBytes);
        DERSequence preMasterSecretSequence = new DERSequence(new ASN1Encodable[]{kxASN1, kyASN1, hashASN1, cipherASN1});
        byte[] preMasterSecretEncodBytes = preMasterSecretSequence.getEncoded();
        TlsUtils.writeOpaque16(preMasterSecretEncodBytes, output);
        return preMasterSecret;
    }
}

