/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2Signer;
import org.bouncycastle.util.Arrays;

public class BcSM2TlsCredentialedSignerAndDecryptor
implements TlsCredentialedDecryptor,
TlsCredentialedSigner {
    protected BcTlsCrypto crypto;
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected AsymmetricKeyParameter signPrivateKey;
    protected AsymmetricKeyParameter encPrivateKey;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public BcSM2TlsCredentialedSignerAndDecryptor(BcTlsCrypto crypto, TlsCryptoParameters cryptoParams, Certificate certificate, AsymmetricKeyParameter signPrivateKey, AsymmetricKeyParameter encPrivateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (signPrivateKey == null) {
            throw new IllegalArgumentException("'signPrivateKey' cannot be null");
        }
        if (!signPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'signPrivateKey' must be private");
        }
        if (encPrivateKey == null) {
            throw new IllegalArgumentException("'encPrivateKey' cannot be null");
        }
        if (!encPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'encPrivateKey' must be private");
        }
        if (!(signPrivateKey instanceof ECKeyParameters) || !(encPrivateKey instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + signPrivateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.cryptoParams = cryptoParams;
        this.certificate = certificate;
        this.signPrivateKey = signPrivateKey;
        this.encPrivateKey = encPrivateKey;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signer = new BcTlsSM2Signer(crypto, (ECKeyParameters)((ECPrivateKeyParameters)signPrivateKey));
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, (ECKeyParameters)this.encPrivateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, ECKeyParameters ecServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion clientVersion = cryptoParams.getClientVersion();
        boolean versionNumberCheckDisabled = false;
        byte[] fallback = new byte[48];
        secureRandom.nextBytes(fallback);
        byte[] M = Arrays.clone((byte[])fallback);
        try {
            SM2Engine sm2Engine = new SM2Engine();
            sm2Engine.init(false, (CipherParameters)ecServerPrivateKey);
            M = sm2Engine.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!versionNumberCheckDisabled || !clientVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int correct = clientVersion.getMajorVersion() ^ M[0] & 0xFF | clientVersion.getMinorVersion() ^ M[1] & 0xFF;
            correct |= correct >> 1;
            correct |= correct >> 2;
            correct |= correct >> 4;
            int mask = ~((correct & 1) - 1);
            for (int i = 0; i < 48; ++i) {
                M[i] = (byte)(M[i] & ~mask | fallback[i] & mask);
            }
        }
        return this.crypto.createSecret(M);
    }

    @Override
    public byte[] generateRawSignature(byte[] hash) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), hash);
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    @Override
    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm algorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (algorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return algorithm;
    }
}

