/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.security.SecureRandom;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerOnlyTlsAuthentication;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.HTTPSServerThread;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class BasicTlsTest
extends TestCase {
    private static final int PORT_NO = 12001;

    protected boolean isSufficientVMVersion(String vmVersion) {
        if (vmVersion == null) {
            return false;
        }
        String[] parts = vmVersion.split("\\.");
        if (parts == null || parts.length != 2) {
            return false;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            if (major != 1) {
                return major > 1;
            }
            int minor = Integer.parseInt(parts[1]);
            return minor >= 7;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void testConnection() throws Exception {
        String vmVersion = System.getProperty("java.specification.version");
        if (!this.isSufficientVMVersion(vmVersion)) {
            return;
        }
        HTTPSServerThread server = new HTTPSServerThread();
        server.start();
        Thread.yield();
        Socket s = null;
        for (int i = 0; s == null && i != 3; ++i) {
            Thread.sleep(1000L);
            try {
                s = new Socket("localhost", 12001);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (s == null) {
            throw new IOException("unable to connect");
        }
        TlsClientProtocol protocol = new TlsClientProtocol(s.getInputStream(), s.getOutputStream());
        protocol.connect(new MyTlsClient(new ServerOnlyTlsAuthentication(){

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
            }
        }));
        InputStream is = protocol.getInputStream();
        OutputStream os = protocol.getOutputStream();
        os.write("GET / HTTP/1.1\r\n\r\n".getBytes());
        byte[] buf = new byte[4096];
        int read = 0;
        int total = 0;
        while ((read = is.read(buf, total, buf.length - total)) > 0) {
            total += read;
        }
        is.close();
        byte[] expected = Hex.decode((String)"485454502f312e3120323030204f4b0d0a436f6e74656e742d547970653a20746578742f68746d6c0d0a0d0a3c68746d6c3e0d0a3c626f64793e0d0a48656c6c6f20576f726c64210d0a3c2f626f64793e0d0a3c2f68746d6c3e0d0a");
        BasicTlsTest.assertEquals((int)total, (int)expected.length);
        byte[] tmp = new byte[expected.length];
        System.arraycopy(buf, 0, tmp, 0, total);
        BasicTlsTest.assertTrue((boolean)Arrays.areEqual((byte[])expected, (byte[])tmp));
    }

    public void testRSAConnectionClient() throws Exception {
        MyTlsClient client = new MyTlsClient(null);
        this.checkConnectionClient(client, 10, TlsTestUtils.rsaCertData);
        this.checkConnectionClient(client, 47, TlsTestUtils.rsaCertData);
        this.checkConnectionClient(client, 53, TlsTestUtils.rsaCertData);
        this.checkConnectionClient(client, 5, TlsTestUtils.rsaCertData);
        try {
            this.checkConnectionClient(client, 10, TlsTestUtils.dudRsaCertData);
            BasicTlsTest.fail((String)"dud certificate not caught");
        }
        catch (TlsFatalAlert e) {
            BasicTlsTest.assertEquals((short)46, (short)e.getAlertDescription());
        }
        try {
            this.checkConnectionClient(client, 25, TlsTestUtils.rsaCertData);
            BasicTlsTest.fail((String)"wrong certificate not caught");
        }
        catch (TlsFatalAlert e) {
            BasicTlsTest.assertEquals((short)80, (short)e.getAlertDescription());
        }
    }

    private void checkConnectionClient(TlsClient client, int cipherSuite, byte[] encCert) throws Exception {
        TlsCrypto crypto = client.getCrypto();
        client.notifySelectedCipherSuite(cipherSuite);
        TlsKeyExchange keyExchange = client.getKeyExchange();
        keyExchange.init(new MyTlsClientContext(crypto));
        keyExchange.processServerCertificate(new Certificate(new TlsCertificate[]{crypto.createCertificate(encCert)}));
    }

    public static TestSuite suite() {
        return new TestSuite(BasicTlsTest.class);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)BasicTlsTest.suite());
    }

    static class MyTlsClientContext
    implements TlsClientContext {
        TlsCrypto crypto;

        MyTlsClientContext(TlsCrypto crypto) {
            this.crypto = crypto;
        }

        @Override
        public TlsCrypto getCrypto() {
            return this.crypto;
        }

        @Override
        public TlsNonceGenerator getNonceGenerator() {
            throw new UnsupportedOperationException();
        }

        public SecureRandom getSecureRandom() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SecurityParameters getSecurityParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public ProtocolVersion getClientVersion() {
            return ProtocolVersion.TLSv12;
        }

        @Override
        public ProtocolVersion getServerVersion() {
            return ProtocolVersion.TLSv12;
        }

        @Override
        public TlsSession getResumableSession() {
            return null;
        }

        @Override
        public TlsSession getSession() {
            return null;
        }

        @Override
        public Object getUserObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUserObject(Object userObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] exportChannelBinding(int channelBinding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
            throw new UnsupportedOperationException();
        }
    }

    static class MyTlsClient
    extends DefaultTlsClient {
        private final TlsAuthentication authentication;

        @Override
        public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
            PrintStream out = alertLevel == 2 ? System.err : System.out;
            out.println("TLS client raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
            if (message != null) {
                out.println(message);
            }
            if (cause != null) {
                cause.printStackTrace(out);
            }
        }

        @Override
        public void notifyAlertReceived(short alertLevel, short alertDescription) {
            PrintStream out = alertLevel == 2 ? System.err : System.out;
            out.println("TLS client received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        }

        MyTlsClient(TlsAuthentication authentication) {
            super(new BcTlsCrypto(new SecureRandom()));
            this.authentication = authentication;
        }

        @Override
        public TlsAuthentication getAuthentication() throws IOException {
            return this.authentication;
        }
    }
}

