/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertChainUtil {
    public static String BC = "BC";
    private static final AtomicLong serialNumber = new AtomicLong(1L);

    public static X509Certificate createMasterCert(String masterDN, KeyPair keyPair) throws Exception {
        JcaX509v1CertificateBuilder v1CertBuilder = new JcaX509v1CertificateBuilder(new X500Name(masterDN), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Name(masterDN), keyPair.getPublic());
        X509CertificateHolder cert = v1CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(keyPair.getPrivate()));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createIntermediateCert(String interDN, PublicKey pubKey, PrivateKey rootPrivKey, X509Certificate rootCert) throws Exception {
        JcaX509v3CertificateBuilder v3CertBuilder = new JcaX509v3CertificateBuilder(JcaX500NameUtil.getIssuer((X509Certificate)rootCert), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Name(interDN), pubKey);
        JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
        v3CertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)utils.createSubjectKeyIdentifier(pubKey));
        v3CertBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)utils.createAuthorityKeyIdentifier(rootCert));
        v3CertBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(rootPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createEndEntityCert(String endEntityDN, PublicKey pubKey, PrivateKey caPrivKey, X509Certificate caCert) throws Exception {
        X509v3CertificateBuilder v3CertBuilder = CertChainUtil.createBaseEndEntityBuilder(endEntityDN, pubKey, caCert);
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(caPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createEndEntityCert(String endEntityDN, PublicKey pubKey, PrivateKey caPrivKey, X509Certificate caCert, KeyPurposeId keyPurposeId) throws Exception {
        X509v3CertificateBuilder v3CertBuilder = CertChainUtil.createBaseEndEntityBuilder(endEntityDN, pubKey, caCert);
        v3CertBuilder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(keyPurposeId));
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(caPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    private static X509v3CertificateBuilder createBaseEndEntityBuilder(String endEntityDN, PublicKey pubKey, X509Certificate caCert) throws IOException, NoSuchAlgorithmException {
        JcaX509v3CertificateBuilder v3CertBuilder = new JcaX509v3CertificateBuilder(caCert.getIssuerX500Principal(), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Principal(new X500Name(endEntityDN).getEncoded()), pubKey);
        JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
        v3CertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)utils.createSubjectKeyIdentifier(pubKey));
        v3CertBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)utils.createAuthorityKeyIdentifier(caCert.getPublicKey()));
        v3CertBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        return v3CertBuilder;
    }
}

