/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import org.bouncycastle.tls.DTLSServerProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.UDPTransport;
import org.bouncycastle.tls.test.MockDTLSServer;

public class DTLSServerTest {
    public static void main(String[] args) throws Exception {
        int port = 5556;
        int mtu = 1500;
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol();
        byte[] data = new byte[mtu];
        DatagramPacket packet = new DatagramPacket(data, mtu);
        DatagramSocket socket = new DatagramSocket(port);
        socket.receive(packet);
        System.out.println("Accepting connection from " + packet.getAddress().getHostAddress() + ":" + port);
        socket.connect(packet.getAddress(), packet.getPort());
        UDPTransport transport = new UDPTransport(socket, mtu);
        MockDTLSServer server = new MockDTLSServer();
        DTLSTransport dtlsServer = serverProtocol.accept(server, transport);
        byte[] buf = new byte[dtlsServer.getReceiveLimit()];
        while (!socket.isClosed()) {
            try {
                int length = dtlsServer.receive(buf, 0, buf.length, 60000);
                if (length < 0) continue;
                System.out.write(buf, 0, length);
                dtlsServer.send(buf, 0, length);
            }
            catch (SocketTimeoutException socketTimeoutException) {}
        }
        dtlsServer.close();
    }
}

