/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.PSKTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Strings;

class MockPSKTlsServer
extends PSKTlsServer {
    MockPSKTlsServer() {
        super((TlsCrypto)new BcTlsCrypto(new SecureRandom()), new MyIdentityManager());
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] pskIdentity = this.context.getSecurityParameters().getPSKIdentity();
        if (pskIdentity != null) {
            String name = Strings.fromUTF8ByteArray((byte[])pskIdentity);
            System.out.println("TLS-PSK server completed handshake for PSK identity: " + name);
        }
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS-PSK server negotiated " + serverVersion);
        return serverVersion;
    }

    @Override
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    static class MyIdentityManager
    implements TlsPSKIdentityManager {
        MyIdentityManager() {
        }

        @Override
        public byte[] getHint() {
            return Strings.toUTF8ByteArray((String)"hint");
        }

        @Override
        public byte[] getPSK(byte[] identity) {
            String name;
            if (identity != null && (name = Strings.fromUTF8ByteArray((byte[])identity)).equals("client")) {
                return new byte[16];
            }
            return null;
        }
    }
}

