/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.test.NetworkInputStream;
import org.bouncycastle.tls.test.NetworkOutputStream;
import org.bouncycastle.tls.test.TlsTestClientImpl;
import org.bouncycastle.tls.test.TlsTestClientProtocol;
import org.bouncycastle.tls.test.TlsTestConfig;
import org.bouncycastle.tls.test.TlsTestServerImpl;
import org.bouncycastle.tls.test.TlsTestServerProtocol;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class TlsTestCase
extends TestCase {
    protected final TlsTestConfig config;

    private static void checkTLSVersion(ProtocolVersion version) {
        if (version != null && !version.isTLS()) {
            throw new IllegalStateException("Non-TLS version");
        }
    }

    public TlsTestCase(String name) {
        super(name);
        this.config = null;
    }

    public TlsTestCase(TlsTestConfig config, String name) {
        super(name);
        TlsTestCase.checkTLSVersion(config.clientMinimumVersion);
        TlsTestCase.checkTLSVersion(config.clientOfferVersion);
        TlsTestCase.checkTLSVersion(config.serverMaximumVersion);
        TlsTestCase.checkTLSVersion(config.serverMinimumVersion);
        this.config = config;
    }

    public void testDummy() {
    }

    protected void runTest() throws Throwable {
        if (this.config == null) {
            return;
        }
        SecureRandom secureRandom = new SecureRandom();
        PipedInputStream clientRead = new PipedInputStream();
        PipedInputStream serverRead = new PipedInputStream();
        PipedOutputStream clientWrite = new PipedOutputStream(serverRead);
        PipedOutputStream serverWrite = new PipedOutputStream(clientRead);
        NetworkInputStream clientNetIn = new NetworkInputStream(clientRead);
        NetworkInputStream serverNetIn = new NetworkInputStream(serverRead);
        NetworkOutputStream clientNetOut = new NetworkOutputStream(clientWrite);
        NetworkOutputStream serverNetOut = new NetworkOutputStream(serverWrite);
        TlsTestClientProtocol clientProtocol = new TlsTestClientProtocol(clientNetIn, clientNetOut, this.config);
        TlsTestServerProtocol serverProtocol = new TlsTestServerProtocol(serverNetIn, serverNetOut, this.config);
        TlsTestClientImpl clientImpl = new TlsTestClientImpl(this.config);
        TlsTestServerImpl serverImpl = new TlsTestServerImpl(this.config);
        ServerThread serverThread = new ServerThread(serverProtocol, serverImpl);
        serverThread.start();
        Exception caught = null;
        try {
            clientProtocol.connect(clientImpl);
            int length = 1000;
            byte[] data = new byte[length];
            secureRandom.nextBytes(data);
            OutputStream output = clientProtocol.getOutputStream();
            output.write(data);
            byte[] echo = new byte[data.length];
            int count = Streams.readFully((InputStream)clientProtocol.getInputStream(), (byte[])echo);
            TlsTestCase.assertEquals((int)count, (int)data.length);
            TlsTestCase.assertTrue((boolean)Arrays.areEqual((byte[])data, (byte[])echo));
            TlsTestCase.assertNotNull((Object)clientImpl.tlsUnique);
            TlsTestCase.assertNotNull((Object)serverImpl.tlsUnique);
            TlsTestCase.assertTrue((boolean)Arrays.areEqual((byte[])clientImpl.tlsUnique, (byte[])serverImpl.tlsUnique));
            output.close();
        }
        catch (Exception e) {
            caught = e;
            this.logException(caught);
        }
        serverThread.allowExit();
        serverThread.join();
        TlsTestCase.assertTrue((String)"Client InputStream not closed", (boolean)clientNetIn.isClosed());
        TlsTestCase.assertTrue((String)"Client OutputStream not closed", (boolean)clientNetOut.isClosed());
        TlsTestCase.assertTrue((String)"Server InputStream not closed", (boolean)serverNetIn.isClosed());
        TlsTestCase.assertTrue((String)"Server OutputStream not closed", (boolean)serverNetOut.isClosed());
        TlsTestCase.assertEquals((String)"Client fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)clientImpl.firstFatalAlertConnectionEnd);
        TlsTestCase.assertEquals((String)"Server fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)serverImpl.firstFatalAlertConnectionEnd);
        TlsTestCase.assertEquals((String)"Client fatal alert description", (short)this.config.expectFatalAlertDescription, (short)clientImpl.firstFatalAlertDescription);
        TlsTestCase.assertEquals((String)"Server fatal alert description", (short)this.config.expectFatalAlertDescription, (short)serverImpl.firstFatalAlertDescription);
        if (this.config.expectFatalAlertConnectionEnd == -1) {
            TlsTestCase.assertNull((String)"Unexpected client exception", (Object)caught);
            TlsTestCase.assertNull((String)"Unexpected server exception", (Object)serverThread.caught);
        }
    }

    protected void logException(Exception e) {
    }

    class ServerThread
    extends Thread {
        protected final TlsTestServerProtocol serverProtocol;
        protected final TlsTestServerImpl serverImpl;
        boolean canExit = false;
        Exception caught = null;

        ServerThread(TlsTestServerProtocol serverProtocol, TlsTestServerImpl serverImpl) {
            this.serverProtocol = serverProtocol;
            this.serverImpl = serverImpl;
        }

        synchronized void allowExit() {
            this.canExit = true;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                this.serverProtocol.accept(this.serverImpl);
                Streams.pipeAll((InputStream)this.serverProtocol.getInputStream(), (OutputStream)this.serverProtocol.getOutputStream());
                this.serverProtocol.close();
            }
            catch (Exception e) {
                this.caught = e;
                TlsTestCase.this.logException(this.caught);
            }
            this.waitExit();
        }

        protected synchronized void waitExit() {
            while (!this.canExit) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

