/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.security.Provider;
import java.security.Security;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.test.TlsTestCase;
import org.bouncycastle.tls.test.TlsTestConfig;

public class TlsTestSuite
extends TestSuite {
    public TlsTestSuite() {
        super("TLS");
    }

    public static Test suite() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        TlsTestSuite testSuite = new TlsTestSuite();
        TlsTestSuite.addAllTests(testSuite, 0, 0);
        TlsTestSuite.addAllTests(testSuite, 1, 0);
        TlsTestSuite.addAllTests(testSuite, 0, 1);
        TlsTestSuite.addAllTests(testSuite, 1, 1);
        return testSuite;
    }

    private static void addAllTests(TestSuite testSuite, int clientCrypto, int serverCrypto) {
        TlsTestSuite.addFallbackTests(testSuite, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv10, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv11, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
    }

    private static void addFallbackTests(TestSuite testSuite, int clientCrypto, int serverCrypto) {
        String prefix = TlsTestSuite.getCryptoName(clientCrypto) + "_" + TlsTestSuite.getCryptoName(serverCrypto) + "_";
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientFallback = true;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackGood");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientOfferVersion = ProtocolVersion.TLSv11;
        c.clientFallback = true;
        c.expectServerFatalAlert((short)86);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackBad");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientOfferVersion = ProtocolVersion.TLSv11;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackNone");
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version, int clientCrypto, int serverCrypto) {
        String prefix = TlsTestSuite.getCryptoName(clientCrypto) + "_" + TlsTestSuite.getCryptoName(serverCrypto) + "_" + version.toString().replaceAll("[ \\.]", "") + "_";
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodDefault");
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultRSASignatureAlgorithms();
            c.expectClientFatalAlert((short)80);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifyHashAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.expectServerFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySigAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.clientAuthSigAlgClaimed = new SignatureAndHashAlgorithm(2, 3);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.expectServerFatalAlert((short)51);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySigAlgMismatch");
        }
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 3;
        c.expectServerFatalAlert((short)51);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySignature");
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 2;
        c.expectServerFatalAlert((short)42);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadClientCertificate");
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 0;
        c.serverCertReq = 2;
        c.expectServerFatalAlert((short)40);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadMandatoryCertReqDeclined");
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadServerKeyExchangeSigAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientSendSignatureAlgorithms = false;
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadServerKeyExchangeSigAlg2");
        }
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.serverCertReq = 0;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodNoCertReq");
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 0;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodOptionalCertReqDeclined");
    }

    private static void addTestCase(TestSuite testSuite, TlsTestConfig config, String name) {
        testSuite.addTest((Test)new TlsTestCase(config, name));
    }

    private static TlsTestConfig createTlsTestConfig(ProtocolVersion version, int clientCrypto, int serverCrypto) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientCrypto = clientCrypto;
        c.clientMinimumVersion = ProtocolVersion.TLSv10;
        c.clientOfferVersion = ProtocolVersion.TLSv12;
        c.serverCrypto = serverCrypto;
        c.serverMaximumVersion = version;
        c.serverMinimumVersion = ProtocolVersion.TLSv10;
        return c;
    }

    private static String getCryptoName(int crypto) {
        switch (crypto) {
            case 1: {
                return "JCA";
            }
        }
        return "BC";
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

