/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.util.Random;
import org.bouncycastle.tls.DatagramTransport;

public class UnreliableDatagramTransport
implements DatagramTransport {
    private final DatagramTransport transport;
    private final Random random;
    private final int percentPacketLossReceiving;
    private final int percentPacketLossSending;

    public UnreliableDatagramTransport(DatagramTransport transport, Random random, int percentPacketLossReceiving, int percentPacketLossSending) {
        if (percentPacketLossReceiving < 0 || percentPacketLossReceiving > 100) {
            throw new IllegalArgumentException("'percentPacketLossReceiving' out of range");
        }
        if (percentPacketLossSending < 0 || percentPacketLossSending > 100) {
            throw new IllegalArgumentException("'percentPacketLossSending' out of range");
        }
        this.transport = transport;
        this.random = random;
        this.percentPacketLossReceiving = percentPacketLossReceiving;
        this.percentPacketLossSending = percentPacketLossSending;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this.transport.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this.transport.getSendLimit();
    }

    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        long endMillis = System.currentTimeMillis() + (long)waitMillis;
        int length;
        while ((length = this.transport.receive(buf, off, len, waitMillis)) >= 0 && this.lostPacket(this.percentPacketLossReceiving)) {
            System.out.println("PACKET LOSS (" + length + " byte packet not received)");
            long now = System.currentTimeMillis();
            if (now >= endMillis) {
                return -1;
            }
            waitMillis = (int)(endMillis - now);
        }
        return length;
    }

    @Override
    public void send(byte[] buf, int off, int len) throws IOException {
        if (this.lostPacket(this.percentPacketLossSending)) {
            System.out.println("PACKET LOSS (" + len + " byte packet not sent)");
        } else {
            this.transport.send(buf, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    private boolean lostPacket(int percentPacketLoss) {
        return percentPacketLoss > 0 && this.random.nextInt(100) < percentPacketLoss;
    }
}

