/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.config.exception.ConvertException;
import com.kingdee.util.OfdErrorType;
import com.levigo.jbig2.JBIG2ImageReader;
import com.levigo.jbig2.JBIG2ImageReaderSpi;
import com.levigo.jbig2.io.DefaultInputStreamFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class ExportQrCode {
    private static final Logger LOGGER = Logger.getLogger(ExportQrCode.class);
    private static final String SUFFIX_JB2 = "jb2";
    private static final String IMAGE_TYPE = "png";

    public static String getImageBase64(byte[] imageByte, String fileSuffix) {
        if (SUFFIX_JB2.equals(fileSuffix)) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(imageByte);
                 ImageInputStream imageInputStream = new DefaultInputStreamFactory().getInputStream((InputStream)inputStream);
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
                imageReader.setInput(imageInputStream);
                BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                ImageIO.write((RenderedImage)bufferedImage, IMAGE_TYPE, out);
                imageByte = out.toByteArray();
            }
            catch (Exception e) {
                LOGGER.error((Object)OfdErrorType.CREATE_QR_CODE_ERROR, (Throwable)e);
                throw new ConvertException(OfdErrorType.CREATE_QR_CODE_ERROR);
            }
        }
        return new BASE64Encoder().encode(imageByte);
    }
}

