/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.config.exception.VerifyException;
import com.kingdee.util.Base64Util;
import com.kingdee.util.OfdErrorType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3Util {
    private static final Logger LOGGER = Logger.getLogger(SM3Util.class);
    private static final String ALGORITHM_NAME = "SM3";

    public static String doDigestToBase64Str(byte[] bytes) {
        return Base64Util.base64encoder(SM3Util.doDigest(bytes));
    }

    public static byte[] doDigest(byte[] bytes) {
        MessageDigest messageDigest = SM3Util.createMessageDigest();
        try {
            if (null != bytes) {
                messageDigest.update(bytes);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            LOGGER.error((Object)OfdErrorType.HASH_ERROR, (Throwable)e);
            throw new VerifyException(OfdErrorType.HASH_ERROR);
        }
    }

    private static MessageDigest createMessageDigest() {
        MessageDigest messageDigest;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(ALGORITHM_NAME) : MessageDigest.getInstance(ALGORITHM_NAME, (Provider)provider);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)OfdErrorType.HASH_IDENTIFIES_ERROR, (Throwable)e);
            throw new VerifyException(OfdErrorType.HASH_IDENTIFIES_ERROR);
        }
        return messageDigest;
    }
}

