/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import com.kingdee.config.exception.ConvertException;
import com.kingdee.util.CompressHelper;
import com.kingdee.util.OfdErrorType;
import com.kingdee.util.StrUtil;
import com.kingdee.util.ofd.OfdReadUtil;
import com.kingdee.util.ofd.SVGConversionUtil;
import com.kingdee.util.ofd.SvgUtil;
import com.kingdee.util.pdf.PdfUtils;
import com.kingdee.util.pdf.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEROctetString;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdConvertUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdConvertUtil.class);

    public static byte[] convertToImage(byte[] fileBytes, float zoomScale, int imageType) {
        if (zoomScale > 3.0f) {
            throw new ConvertException(OfdErrorType.CONVERT_PNG_TOO_LARGE);
        }
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, false, -1);
        String svgStr = (String)svgMap.get("svgStr");
        float svgWidth = ((Float)svgMap.get("svgWidth")).floatValue();
        float svgHeight = ((Float)svgMap.get("svgHeight")).floatValue();
        byte[] svgBytes = svgStr.getBytes(StandardCharsets.UTF_8);
        return SVGConversionUtil.convertSvgBytes2Image(svgBytes, SvgUtil.getPxByMM(svgWidth) * zoomScale, SvgUtil.getPxByMM(svgHeight) * zoomScale, imageType);
    }

    public static List<Object> convertToMultImage(byte[] fileBytes, float zoomScale, boolean strFlag, int imageType, int pageNo) {
        String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, pageNo);
        return SVGConversionUtil.convertSvgBytes2MulImage(svgStr, zoomScale, strFlag, imageType);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        try {
            String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, -1);
            return SVGConversionUtil.convertSvgStr2Pdf(svgStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)((Object)OfdErrorType.CONVERT_PDF_ERROR) + ":" + e.getMessage());
            throw new ConvertException(OfdErrorType.CONVERT_PDF_ERROR, e.getMessage());
        }
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        try {
            String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, -1);
            return PdfUtils.convertToPdf(svgStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)((Object)OfdErrorType.CONVERT_PDF_ERROR) + ":" + e.getMessage());
            e.printStackTrace();
            throw new ConvertException(OfdErrorType.CONVERT_PDF_ERROR, e.getMessage());
        }
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1).getBytes(StandardCharsets.UTF_8);
    }

    private static Map<String, Object> ofdToSvgMap(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, byte[]> ofdFileMap = CompressHelper.decompress(fileBytes);
        return OfdConvertUtil.readOfdDataToSvg(ofdFileMap, pdfFlag, pageNo);
    }

    private static String ofdToSvgStr(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, pdfFlag, pageNo);
        return (String)svgMap.get("svgStr");
    }

    private static Map<String, Object> readOfdDataToSvg(Map<String, byte[]> ofdFileMap, boolean pdfFlag, int pageNo) {
        String[] areaArr;
        float areaWidth;
        byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String signaturesPath = null;
        try {
            signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
        }
        catch (Exception e) {
            LOGGER.info("\u7b7e\u7ae0\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = ofdFileMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String documentResPath = commonDataEle.elementText("DocumentRes");
        Map<String, Object> multiMediaMap = OfdConvertUtil.getMultiMediaMap(ofdFileMap, docRootDirPath + documentResPath);
        String publicResPath = commonDataEle.elementText("PublicRes");
        if (StringUtil.isEmpty(publicResPath)) {
            publicResPath = documentResPath;
        }
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(ofdFileMap.get(docRootDirPath + publicResPath));
        String firstPageArea = commonDataEle.element("PageArea").elementText("PhysicalBox");
        float width = 210.0f;
        if (firstPageArea != null && (areaWidth = Float.parseFloat((areaArr = firstPageArea.split(" "))[2])) > 0.0f) {
            width = areaWidth;
        }
        List tempEleList = commonDataEle.elements("TemplatePage");
        Map<String, Element> templateMap = OfdConvertUtil.getTempEleMap(tempEleList);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        float offsetY = 0.0f;
        StringBuffer contentBuffer = new StringBuffer();
        for (int i = 0; i < pageEleList.size(); ++i) {
            if (pageNo != -1 && pageNo != i) continue;
            Element pageEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)pageEleList.get(i), docRootDirPath);
            String tempId = OfdConvertUtil.getTempEleIdByPage(pageEle);
            Element tempElePath = templateMap.get(tempId);
            if (!tempEleList.isEmpty() && tempElePath == null) {
                tempElePath = (Element)tempEleList.get(i);
            }
            Element tempEle = null;
            if (tempElePath != null) {
                tempEle = OfdReadUtil.getElementByPath(ofdFileMap, tempElePath, docRootDirPath);
            }
            Map<String, Object> svgMap = SvgUtil.getPageSvg(tempEle, firstPageArea, fontFamilyMap, null, multiMediaMap, offsetY, i);
            StringBuffer svgBuffer = (StringBuffer)svgMap.get("svgBuffer");
            String signSvgString = null;
            if (i == 0 && !StringUtil.isEmpty(signaturesPath) && (signSvgString = OfdConvertUtil.getSignSvgString(ofdFileMap, signaturesPath, offsetY)) != null) {
                svgBuffer.append(signSvgString);
            }
            Map<String, Object> pageSvgMap = SvgUtil.getPageSvg(pageEle, firstPageArea, fontFamilyMap, svgBuffer, multiMediaMap, offsetY, i);
            if (svgMap.isEmpty()) {
                svgMap = pageSvgMap;
                svgBuffer = (StringBuffer)svgMap.get("svgBuffer");
                float offsetX = ((Float)svgMap.get("offsetX")).floatValue();
                if (offsetX > width) {
                    width = offsetX;
                }
            }
            svgBuffer.append("</svg>");
            if (!pdfFlag) {
                offsetY = ((Float)svgMap.get("offsetY")).floatValue();
            }
            contentBuffer.append(svgBuffer);
        }
        StringBuffer pageBuffer = new StringBuffer("<svg ").append(" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append(" version=\"1.1\" ");
        pageBuffer.append("width=\"").append(width).append("mm\" height=\"").append(offsetY).append("mm\">");
        pageBuffer.append(contentBuffer);
        pageBuffer.append("</svg>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("svgStr", pageBuffer.toString());
        map.put("svgWidth", Float.valueOf(width));
        map.put("svgHeight", Float.valueOf(offsetY));
        return map;
    }

    private static Map<String, Element> getTempEleMap(List<Element> tempEleList) {
        HashMap<String, Element> templateMap = new HashMap<String, Element>(tempEleList.size());
        for (Element templateEle : tempEleList) {
            templateMap.put(templateEle.attributeValue("ID"), templateEle);
        }
        return templateMap;
    }

    private static String getTempEleIdByPage(Element pageEle) {
        String tempEleId = null;
        Element templateEle = pageEle.element("Template");
        if (templateEle != null) {
            tempEleId = templateEle.attributeValue("TemplateID");
        }
        return tempEleId;
    }

    private static Map<String, String> getFontFamilyByPublicRes(byte[] fileBytes) {
        Element fontsEle;
        List drawEleList;
        HashMap<String, String> map = new HashMap<String, String>();
        if (fileBytes == null || fileBytes.length == 0) {
            return map;
        }
        Element publicResEle = OfdReadUtil.getElementByByte(fileBytes);
        Element drawParamsEle = publicResEle.element("DrawParams");
        if (drawParamsEle != null && (drawEleList = drawParamsEle.elements("DrawParam")) != null && !drawEleList.isEmpty()) {
            for (Element drawEle : drawEleList) {
                Element fillColorEle;
                if (drawEle == null) continue;
                String drawId = drawEle.attributeValue("ID");
                String lineWidth = drawEle.attributeValue("LineWidth");
                if (!StringUtil.isEmpty(lineWidth)) {
                    map.put("LINE_WIDTH_" + drawId, lineWidth);
                }
                if ((fillColorEle = drawEle.element("FillColor")) != null) {
                    OfdConvertUtil.setDrawParamsColor(drawEle, fillColorEle, map);
                    continue;
                }
                Element strokeColorEle = drawEle.element("StrokeColor");
                OfdConvertUtil.setDrawParamsColor(drawEle, strokeColorEle, map);
            }
        }
        if ((fontsEle = publicResEle.element("Fonts")) != null) {
            List fontEleList = fontsEle.elements("Font");
            for (Element fontEle : fontEleList) {
                String fontFamilyName = fontEle.attributeValue("FamilyName");
                if (StrUtil.isEmpty(fontFamilyName)) {
                    fontFamilyName = fontEle.attributeValue("FontName");
                }
                if ("KaiTi".equals(fontFamilyName)) {
                    fontFamilyName = "\u6977\u4f53, KaiTi, Kai, simkai";
                }
                if (!StrUtil.isEmpty(fontFamilyName)) {
                    fontFamilyName = fontFamilyName.replace("\u6977\u4f53", "\u6977\u4f53, KaiTi, Kai, simkai");
                    fontFamilyName = fontFamilyName.replace("\u5b8b\u4f53", "\u5b8b\u4f53, SimSun, simsun");
                }
                map.put(fontEle.attributeValue("ID"), fontFamilyName);
            }
        }
        return map;
    }

    private static void setDrawParamsColor(Element drawEle, Element colorEle, Map<String, String> map) {
        String fillColor;
        if (colorEle != null && !StrUtil.isEmpty(fillColor = colorEle.attributeValue("Value"))) {
            String colorId = drawEle.attributeValue("ID");
            map.put("LINE_COLOR_" + colorId, fillColor);
        }
    }

    private static Map<String, Object> getMultiMediaMap(Map<String, byte[]> ofdFileMap, String documentResPath) {
        Map<String, Object> multiMediaMap = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(documentResPath) && !documentResPath.endsWith("null")) {
            byte[] docResByte = ofdFileMap.get(documentResPath);
            Element docResEle = OfdReadUtil.getElementByByte(docResByte);
            String baseLoc = docResEle.attributeValue("BaseLoc");
            baseLoc = !StringUtil.isEmpty(baseLoc) ? baseLoc + "/" : "";
            Element multiMediasEle = docResEle.element("MultiMedias");
            List multiMediaList = multiMediasEle.elements("MultiMedia");
            if (multiMediaList != null && !multiMediaList.isEmpty()) {
                String documentResDirPath = OfdReadUtil.getLastDirPath(documentResPath).append(baseLoc).toString();
                multiMediaMap = OfdConvertUtil.getMultiMediaMap(multiMediaList, documentResDirPath, ofdFileMap);
            }
        }
        return multiMediaMap;
    }

    private static Map<String, Object> getMultiMediaMap(List<Element> multiMediaList, String documentResPath, Map<String, byte[]> ofdFileMap) {
        HashMap<String, Object> multiMediaMap = new HashMap<String, Object>();
        for (Element multiMediaEle : multiMediaList) {
            String fileName = multiMediaEle.elementText("MediaFile");
            String idStr = multiMediaEle.attributeValue("ID");
            multiMediaMap.put(idStr, fileName);
            multiMediaMap.put(idStr + "_BYTE", ofdFileMap.get(documentResPath + fileName));
        }
        return multiMediaMap;
    }

    private static String getSignSvgString(Map<String, byte[]> ofdFileMap, String signaturesPath, float offsetY) {
        try {
            String signPic = null;
            Element signaturesEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturesPath);
            Element signaturePathEle = signaturesEle.element("Signature");
            String signaturePath = signaturePathEle.attributeValue("BaseLoc");
            signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath);
            Element signatureEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturePath);
            Element signedInfoEle = signatureEle.element("SignedInfo");
            Element stampAnnotEle = signedInfoEle.element("StampAnnot");
            if (stampAnnotEle != null) {
                String signBoundary = stampAnnotEle.attributeValue("Boundary");
                String signedValuePath = signatureEle.elementText("SignedValue");
                signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
                byte[] signedValueByte = OfdReadUtil.getByteByPath(ofdFileMap, signedValuePath);
                signPic = OfdConvertUtil.getSignPic(signedValueByte, signBoundary, offsetY);
            }
            return signPic;
        }
        catch (Exception e) {
            LOGGER.error((Object)((Object)OfdErrorType.READ_SIGN_PIC_ERROR) + ":" + e.getMessage());
            throw new ConvertException(OfdErrorType.READ_SIGN_PIC_ERROR, e.getMessage());
        }
    }

    private static String getSignPic(byte[] signFileByte, String signBoundary, float offsetY) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        ASN1Sequence asnSealSequence = (ASN1Sequence)asn1Sequence0.getObjectAt(1);
        ASN1Sequence sealPicSeq = (ASN1Sequence)((ASN1Sequence)asnSealSequence.getObjectAt(0)).getObjectAt(3);
        String picType = sealPicSeq.getObjectAt(0).toString();
        byte[] picBytes = ((DEROctetString)sealPicSeq.getObjectAt(1)).getOctets();
        String contentStr = "ofd".equals(picType) ? OfdConvertUtil.getSignOfdBuffer(picBytes, signBoundary) : OfdConvertUtil.getSignPicBuffer(picBytes, signBoundary, offsetY);
        return contentStr;
    }

    private static String getSignOfdBuffer(byte[] picBytes, String signBoundary) {
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetX = Float.parseFloat(signBoundaryArr[0]);
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        Map<String, byte[]> signOfdMap = CompressHelper.decompress(picBytes);
        byte[] ofdMainByte = signOfdMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = signOfdMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(signOfdMap.get(docRootDirPath + publicResPath));
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        StringBuffer contentBuffer = new StringBuffer();
        for (int i = 0; i < pageEleList.size(); ++i) {
            List pathObjectEleList;
            Element pageEle = OfdReadUtil.getElementByPath(signOfdMap, (Element)pageEleList.get(i), docRootDirPath);
            Element contentEle = pageEle.element("Content");
            Element layerEle = contentEle.element("Layer");
            String drawParamId = layerEle.attributeValue("DrawParam");
            List textEleList = layerEle.elements("TextObject");
            if (textEleList != null && !textEleList.isEmpty()) {
                SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY);
            }
            if ((pathObjectEleList = layerEle.elements("PathObject")) == null || pathObjectEleList.isEmpty()) continue;
            SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, contentBuffer, drawParamId, pageOffsetX, pageOffsetY);
        }
        return contentBuffer.toString();
    }

    private static String getSignPicBuffer(byte[] picBytes, String signBoundary, float offsetY) {
        if (picBytes == null) {
            return null;
        }
        String picBase64Str = Base64.getEncoder().encodeToString(picBytes);
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        StringBuffer contentBuffer = new StringBuffer();
        contentBuffer.append("<image x=\"").append(signBoundaryArr[0]).append("mm\" ");
        contentBuffer.append("y=\"").append(offsetY + pageOffsetY).append("mm\" ");
        contentBuffer.append("width=\"").append(signBoundaryArr[2]).append("mm\" ");
        contentBuffer.append("height=\"").append(signBoundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
        contentBuffer.append(picBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
        contentBuffer.append("\"/>");
        return contentBuffer.toString();
    }
}

