/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import com.kingdee.config.exception.ReadException;
import com.kingdee.util.CompressHelper;
import com.kingdee.util.OfdErrorType;
import com.kingdee.util.StrUtil;
import com.kingdee.util.XmlUtil;
import com.kingdee.util.pdf.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdReadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdReadUtil.class);

    public static Map<String, Object> extractData(byte[] fileBytes) {
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        StringBuffer dirPath = OfdReadUtil.getLastDirPath(docRootPath);
        byte[] documentByte = decompressFileMap.get(docRootPath);
        String attachmentsPath = OfdReadUtil.getTextByPath(documentByte, "Attachments");
        String path = dirPath.append(attachmentsPath).toString().trim();
        byte[] attachmentsByte = decompressFileMap.get(path);
        String attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment/FileLoc");
        dirPath = OfdReadUtil.getLastDirPath(path).append(attachmentPath);
        byte[] invoiceByte = decompressFileMap.get(dirPath.toString());
        Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
        String rootName = document.getRootElement().getQName().getName();
        if ("xbrl".equalsIgnoreCase(rootName) || !StringUtil.isEmpty(attachmentPath) && attachmentPath.toLowerCase(Locale.ROOT).endsWith("xbrl")) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("file_type", "xbrl");
            dataMap.put("file_data", document.asXML());
            return dataMap;
        }
        return OfdReadUtil.getInvoiceMap(invoiceByte);
    }

    private static Map<String, Object> getInvoiceMap(byte[] invoiceByte) {
        try {
            Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
            String xml = document.asXML();
            return XmlUtil.Dom2Map(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.toString(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    private static Document getDocumentByBytes(byte[] invoiceByte) {
        try {
            return XmlUtil.loadXML(invoiceByte);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.toString(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, Element element, String dirPath) {
        String pagePath = dirPath + element.attributeValue("BaseLoc");
        return OfdReadUtil.getElementByByte(ofdFileMap.get(pagePath));
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        return OfdReadUtil.getElementByByte(OfdReadUtil.getByteByPath(ofdFileMap, filePath));
    }

    public static byte[] getByteByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return ofdFileMap.get(filePath);
    }

    public static Element getElementByByte(byte[] fileByte) {
        try {
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.LOAD_ERROR.toString(), (Throwable)e);
            throw new ReadException(OfdErrorType.LOAD_ERROR);
        }
    }

    public static StringBuffer getLastDirPath(String path) {
        String[] pathArr;
        StringBuffer buffer = new StringBuffer();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append("/");
        }
        return buffer;
    }

    public static String getDirPath(String path, String lastPath) {
        if (!StrUtil.isEmpty(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!StrUtil.isEmpty(lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text;
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")) != null && arr.length == 2) {
                    List elementList = elementNow.elements(arr[0]);
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.attributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                elementNow = elementNow.element(dir);
            }
            text = elementNow.getText();
            text = OfdReadUtil.removeStartSymbol(text, "/");
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.toString(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
        return text;
    }

    private static String removeStartSymbol(String str, String symbol) {
        while (!StrUtil.isEmpty(str) && str.startsWith(symbol)) {
            str = str.substring(1);
        }
        return str;
    }
}

