/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.util.ofd.OfdConvertUtil;
import com.kingdee.util.ofd.OfdReadUtil;
import com.kingdee.util.ofd.OfdSignUtil;
import java.util.List;
import java.util.Map;

public class OfdUtil {
    public static Map<String, Object> getInvoiceMap(byte[] fileBytes) {
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            invoiceMap = null;
        }
        return invoiceMap;
    }

    public static String getXbrlStr(byte[] fileBytes) {
        String str = null;
        Map<String, Object> invoiceMap = OfdReadUtil.extractData(fileBytes);
        if ("xbrl".equals(invoiceMap.get("file_type"))) {
            str = String.valueOf(invoiceMap.get("file_data"));
        }
        return str;
    }

    public static JSONObject getInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getInvoiceMap(fileBytes)));
    }

    public static boolean verifySign(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, false);
    }

    public static boolean verifySignTax(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, true);
    }

    private static Map<String, Object> verifySignAndGetCerInfo(byte[] fileBytes) {
        return OfdSignUtil.verifySignAndGetCerInfo(fileBytes, true, false);
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.convertToSvg(fileBytes);
    }

    public static byte[] convertToPng(byte[] fileBytes) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, 1);
    }

    public static byte[] convertToImage(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, imageType);
    }

    public static List<Object> convertToMulPngStr(byte[] fileBytes) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, 1, -1);
    }

    public static List<Object> convertToHDMulImageStr(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, -1);
    }

    public static List<Object> convertToMulImageStr(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, imageType, -1);
    }

    public static String convertToImageByPageNo(byte[] fileBytes, float zoomScale, int imageType, int pageNo) {
        List<Object> list = OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, pageNo);
        String rsStr = null;
        if (list != null && !list.isEmpty()) {
            rsStr = (String)list.get(0);
        }
        return rsStr;
    }

    public static List<Object> convertToHDMulPngStr(byte[] fileBytes, float zoomScale) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, 1, -1);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes);
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes);
    }

    public static byte[] convertToHDPng(byte[] fileBytes, float multipleNum) {
        return OfdConvertUtil.convertToImage(fileBytes, multipleNum, 1);
    }

    public static byte[] convertToHDImage(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, zoomScale, imageType);
    }
}

