/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.ofd;

import com.kingdee.util.ExportQrCode;
import com.kingdee.util.StrUtil;
import com.kingdee.util.pdf.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Element;

public class SvgUtil {
    public static Map<String, Object> getPageSvg(Element pageEle, String areaText, Map<String, String> fontFamilyMap, StringBuffer svgBuffer, Map<String, Object> multiMediaMap, float offsetY, int pageNum) {
        HashMap<String, Object> svgMap = new HashMap<String, Object>();
        if (pageEle == null) {
            return svgMap;
        }
        Element areaEle = pageEle.element("Area");
        if (areaEle != null) {
            areaText = areaEle.elementText("PhysicalBox");
        }
        if (!StringUtil.isEmpty(areaText)) {
            String[] areaArr = areaText.split(" ");
            if (svgBuffer == null || svgBuffer.length() == 0) {
                float areaHeight;
                float areaWidth = Float.parseFloat(areaArr[2]);
                if (areaWidth == 0.0f) {
                    areaWidth = 210.0f;
                }
                if ((areaHeight = Float.parseFloat(areaArr[3])) == 0.0f) {
                    areaHeight = pageNum == 0 ? 140.0f : 297.0f;
                }
                float offsetHeight = offsetY + areaHeight;
                svgMap.put("offsetY", Float.valueOf(offsetHeight));
                svgMap.put("offsetX", Float.valueOf(areaWidth));
                svgBuffer = new StringBuffer("<svg width=\"" + areaWidth + "mm\" height=\" " + offsetHeight + "mm\">");
            }
        }
        if (pageEle != null) {
            List imageEleList;
            List textEleList;
            Element contentEle = pageEle.element("Content");
            Element layerEle = contentEle.element("Layer");
            String drawParamId = layerEle.attributeValue("DrawParam");
            List pathObjectEleList = layerEle.elements("PathObject");
            if (pathObjectEleList != null && !pathObjectEleList.isEmpty()) {
                SvgUtil.getSvgLineByList(pathObjectEleList, fontFamilyMap, svgBuffer, drawParamId, 0.0f, offsetY);
            }
            if ((textEleList = layerEle.elements("TextObject")) != null && !textEleList.isEmpty()) {
                SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, svgBuffer, drawParamId, 0.0f, offsetY);
            }
            if ((imageEleList = layerEle.elements("ImageObject")) != null && !imageEleList.isEmpty()) {
                svgBuffer.append(SvgUtil.getSvgImageByList(imageEleList, multiMediaMap, offsetY));
            }
        }
        svgMap.put("svgBuffer", svgBuffer);
        return svgMap;
    }

    public static StringBuffer getSvgTextByList(List<Element> textEleList, Map<String, String> fontFamilyMap, StringBuffer svgBuffer, String drawParamId, float pageOffsetX, float pageOffsetY) {
        String fillColorStr = fontFamilyMap.get("LINE_COLOR_" + drawParamId);
        for (Element textEleTag : textEleList) {
            String boundary = textEleTag.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String fontFamily = fontFamilyMap.get(textEleTag.attributeValue("Font"));
            String fontSizeStr = textEleTag.attributeValue("Size");
            float fontSize = Float.parseFloat(fontSizeStr);
            List textCodeEles = textEleTag.elements("TextCode");
            if (textCodeEles == null || textCodeEles.isEmpty()) continue;
            for (Element textCodeEle : textCodeEles) {
                String offsetYStr;
                if (textCodeEle == null) continue;
                String textStr = textCodeEle.getText();
                String offsetXStr = textCodeEle.attributeValue("X");
                if (StringUtil.isEmpty(offsetXStr)) {
                    offsetXStr = "0";
                }
                if (StringUtil.isEmpty(offsetYStr = textCodeEle.attributeValue("Y"))) {
                    offsetYStr = "0";
                }
                float offsetX = Float.parseFloat(offsetXStr);
                float offsetY = Float.parseFloat(offsetYStr);
                String deltaX = textCodeEle.attributeValue("DeltaX");
                String deltaY = textCodeEle.attributeValue("DeltaY");
                String fontColor = "#000000";
                Element fontColorEle = textEleTag.element("FillColor");
                if (fontColorEle != null) {
                    fontColor = SvgUtil.getHexColorByRgb(fontColorEle.attributeValue("Value"));
                } else if (!StrUtil.isEmpty(fillColorStr)) {
                    fontColor = SvgUtil.getHexColorByRgb(fillColorStr);
                }
                String ctmStr = textEleTag.attributeValue("CTM");
                float x = Float.parseFloat(boundaryArr[0]);
                float y = Float.parseFloat(boundaryArr[1]);
                String[] ctmArr = null;
                float ctmX = 0.0f;
                float ctmY = 0.0f;
                if (ctmStr != null && !"".equals(ctmStr)) {
                    ctmArr = ctmStr.split(" ");
                    ctmX = x + pageOffsetX + Float.parseFloat(ctmArr[4]);
                    ctmY = y + pageOffsetY + Float.parseFloat(ctmArr[5]);
                    ctmArr[4] = ctmX + "";
                    ctmArr[5] = ctmY + "";
                    x = offsetX;
                    y = offsetY;
                } else {
                    x = x + offsetX + pageOffsetX;
                    y = y + offsetY + pageOffsetY;
                }
                textStr = StrUtil.isEmpty(deltaX) && StrUtil.isEmpty(deltaY) ? SvgUtil.getCdataStr(textStr) : SvgUtil.getOffsetBuffer(textStr, x, y, deltaX, deltaY);
                svgBuffer.append("<text x=\"").append(x).append("mm\" y=\"").append(y).append("mm\" ");
                svgBuffer.append("fill=\"").append(fontColor).append("\" font-size=\"").append(fontSize).append("mm\" ");
                svgBuffer.append("font-family=\"").append(fontFamily).append("\" ");
                svgBuffer.append(SvgUtil.getTextCtmBuffer(ctmArr)).append(">").append(textStr).append("</text>");
            }
        }
        return svgBuffer;
    }

    public static StringBuffer getSvgLineByList(List<Element> lineEleList, Map<String, String> fontFamilyMap, StringBuffer svgBuffer, String drawParamId, float pageOffsetX, float pageOffsetY) {
        String fillColorStr = fontFamilyMap.get("LINE_COLOR_" + drawParamId);
        String lineWidthStr = fontFamilyMap.get("LINE_WIDTH_" + drawParamId);
        for (Element lineEle : lineEleList) {
            String[] parts;
            String boundary = lineEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            float x = Float.parseFloat(boundaryArr[0]) + pageOffsetX;
            float y = Float.parseFloat(boundaryArr[1]) + pageOffsetY;
            String ctmMatrix = "";
            String ctmStr = lineEle.attributeValue("CTM");
            if (!StrUtil.isEmpty(ctmStr)) {
                String[] ctmArr = ctmStr.split(" ");
                if (ctmArr.length == 6) {
                    ctmArr[4] = x + Float.parseFloat(ctmArr[4]) + "";
                    ctmArr[5] = y + Float.parseFloat(ctmArr[5]) + "";
                    ctmMatrix = SvgUtil.getTextCtmBuffer(ctmArr).toString();
                }
            } else {
                ctmMatrix = SvgUtil.getTranslateStr(x, y);
            }
            String lineWidth = lineEle.attributeValue("LineWidth");
            if (StrUtil.isEmpty(lineWidth) && !StrUtil.isEmpty(lineWidthStr)) {
                lineWidth = lineWidthStr;
            }
            String fillFlag = lineEle.attributeValue("Fill");
            String strokeColor = "#000000";
            String fillColor = null;
            Element strokeColorEle = lineEle.element("StrokeColor");
            Element fillColorEle = lineEle.element("FillColor");
            if ("true".equals(fillFlag) && fillColorEle != null) {
                fillColor = SvgUtil.getHexColorByRgb(fillColorEle.attributeValue("Value"));
            }
            if (strokeColorEle != null) {
                strokeColor = SvgUtil.getHexColorByRgb(strokeColorEle.attributeValue("Value"));
            } else if (!StrUtil.isEmpty(fillColorStr)) {
                strokeColor = SvgUtil.getHexColorByRgb(fillColorStr);
            }
            StringBuffer dBuffer = new StringBuffer();
            String abbreviatedData = lineEle.elementText("AbbreviatedData");
            block16: for (String part : parts = abbreviatedData.split(" (?=[SMLQBAC])")) {
                String[] temps = part.split(" ");
                switch (temps[0]) {
                    case "S": 
                    case "M": {
                        dBuffer.append("M ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        continue block16;
                    }
                    case "L": {
                        dBuffer.append("L ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        continue block16;
                    }
                    case "Q": {
                        dBuffer.append("Q ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        continue block16;
                    }
                    case "B": {
                        dBuffer.append("C ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[5]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[6]))).append(" ");
                        continue block16;
                    }
                    case "C": {
                        dBuffer.append("Z");
                        continue block16;
                    }
                }
            }
            svgBuffer.append(SvgUtil.getPathBuffer(strokeColor, fillColor, lineWidth, ctmMatrix, dBuffer.toString()));
        }
        return svgBuffer;
    }

    private static StringBuffer getTextCtmBuffer(String[] ctmArr) {
        StringBuffer matrixBuffer = new StringBuffer();
        if (ctmArr != null && ctmArr.length == 6) {
            matrixBuffer.append(" transform=\"matrix(");
            matrixBuffer.append(ctmArr[0]).append(" ");
            matrixBuffer.append(ctmArr[1]).append(" ");
            matrixBuffer.append(ctmArr[2]).append(" ");
            matrixBuffer.append(ctmArr[3]).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[4]))).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[5])));
            matrixBuffer.append(")\" ");
        }
        return matrixBuffer;
    }

    private static String getTranslateStr(float x, float y) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" transform=\"translate(");
        buffer.append(SvgUtil.getPxByMM(x)).append(",");
        buffer.append(SvgUtil.getPxByMM(y));
        buffer.append(")\" ");
        return buffer.toString();
    }

    public static float getPxByMM(float mmValue) {
        return mmValue * 96.0f / 25.4f;
    }

    private static StringBuffer getPathBuffer(String strokeColor, String fillColor, String lineWidth, String ctmMatrix, String d) {
        StringBuffer lineBuffer;
        if (!StrUtil.isEmpty(fillColor)) {
            lineBuffer = new StringBuffer("<path ");
            lineBuffer.append("fill=\"").append(fillColor).append("\" ");
        } else {
            lineBuffer = new StringBuffer("<path fill=\"none\" ");
            lineBuffer.append("stroke=\"").append(strokeColor).append("\" ");
            if (!StrUtil.isEmpty(lineWidth)) {
                lineBuffer.append("stroke-width=\"").append(lineWidth).append("mm\" ");
            }
        }
        lineBuffer.append("d=\"").append(d).append("\" ");
        lineBuffer.append(ctmMatrix).append("/> ");
        return lineBuffer;
    }

    private static StringBuffer getSvgImageByList(List<Element> imageEleList, Map<String, Object> multiMediaMap, float offsetY) {
        StringBuffer imageBuffer = new StringBuffer();
        for (Element imageEle : imageEleList) {
            String resourceID = imageEle.attributeValue("ResourceID");
            String boundary = imageEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String imageName = (String)multiMediaMap.get(resourceID);
            if (imageName == null || "".equals(imageName)) continue;
            byte[] imageFileByte = (byte[])multiMediaMap.get(resourceID + "_BYTE");
            String imageBase64Str = ExportQrCode.getImageBase64(imageFileByte, imageName.split("\\.")[1]);
            imageBuffer.append("<image x=\"").append(boundaryArr[0]).append("mm\" ");
            imageBuffer.append("y=\"").append(offsetY + Float.parseFloat(boundaryArr[1])).append("mm\" ");
            imageBuffer.append("width=\"").append(boundaryArr[2]).append("mm\" ");
            imageBuffer.append("height=\"").append(boundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
            imageBuffer.append(imageBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
            imageBuffer.append("\"/>");
        }
        return imageBuffer;
    }

    private static String getOffsetBuffer(String textStr, float xIndex, float yIndex, String deltaX, String deltaY) {
        StringBuffer offsetYBuffer = new StringBuffer();
        float lastX = xIndex;
        float lastY = yIndex;
        if (!StringUtil.isEmpty(deltaX)) {
            deltaX = SvgUtil.deltaFormatter(deltaX);
        }
        if (!StringUtil.isEmpty(deltaY)) {
            deltaY = SvgUtil.deltaFormatter(deltaY);
        }
        String[] deltaXArr = null;
        if (!StringUtil.isEmpty(deltaX)) {
            deltaXArr = deltaX.split(" ");
        }
        String[] deltaYArr = null;
        if (!StringUtil.isEmpty(deltaY)) {
            deltaYArr = deltaY.split(" ");
        }
        for (int i = 0; i < textStr.length(); ++i) {
            offsetYBuffer.append("<tspan x=\"").append(lastX);
            offsetYBuffer.append("mm\" y=\"").append(lastY).append("mm\">");
            offsetYBuffer.append(SvgUtil.getCdataStr(textStr.substring(i, i + 1))).append("</tspan>");
            if (i >= textStr.length() - 1) continue;
            float offsetX = 0.0f;
            if (deltaXArr != null) {
                offsetX = Float.parseFloat(deltaXArr[i]);
            }
            float offsetY = 0.0f;
            if (deltaYArr != null) {
                offsetY = Float.parseFloat(deltaYArr[i]);
            }
            lastX += offsetX;
            lastY += offsetY;
        }
        return offsetYBuffer.toString();
    }

    private static String deltaFormatter(String delta) {
        if (!delta.contains("g")) {
            return delta;
        }
        List tempList = Arrays.stream(delta.split(" ")).collect(Collectors.toList());
        boolean gFlag = false;
        boolean gProcessing = false;
        int gItemCount = 0;
        ArrayList<String> floatList = new ArrayList<String>();
        for (String s : tempList) {
            if ("g".equals(s)) {
                gFlag = true;
                continue;
            }
            if (s == null || s.trim().length() == 0) continue;
            if (gFlag) {
                gItemCount = Integer.parseInt(s);
                gProcessing = true;
                gFlag = false;
                continue;
            }
            if (gProcessing) {
                for (int j = 0; j < gItemCount; ++j) {
                    floatList.add(s);
                }
                gProcessing = false;
                continue;
            }
            floatList.add(s);
        }
        StringBuilder sb = new StringBuilder();
        for (String item : floatList) {
            sb.append(' ').append(item);
        }
        return sb.toString().trim();
    }

    private static String getCdataStr(String str) {
        if (str != null) {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("  ", "&#160;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
        }
        return str;
    }

    private static String getHexColorByRgb(String rgbStr) {
        if ("0 0 0".equals(rgbStr) || rgbStr == null || "".equals(rgbStr)) {
            return "#000000";
        }
        if ("156 82 35".equals(rgbStr)) {
            return "#9C5223";
        }
        String[] rgbArr = rgbStr.split(" ");
        return String.format("#%02x%02x%02x", Integer.parseInt(rgbArr[0]), Integer.parseInt(rgbArr[1]), Integer.parseInt(rgbArr[2])).toUpperCase();
    }
}

