/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.pdf;

import com.kingdee.util.pdf.PdfUtils;
import com.kingdee.util.pdf.RgbUtils;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class PdfWriteDataUtils {
    public static void setTextValue(Element detailElement, float height, PdfContentByte under, BaseFont[] fonts) {
        float x = PdfUtils.getFloatPxByStr(detailElement.attributeValue("x"));
        float y = height - PdfUtils.getFloatPxByStr(detailElement.attributeValue("y"));
        String dx = detailElement.attributeValue("dx");
        String transform = detailElement.attributeValue("transform");
        String[] ctmStrArr = null;
        if (transform != null && transform.contains("matrix")) {
            String ctmStr = transform.replace("matrix(", "").replace(")", "");
            ctmStrArr = ctmStr.split(" ");
        }
        String fontFamilyStr = detailElement.attributeValue("font-family");
        float fontSize = PdfUtils.getFloatPxByStr(detailElement.attributeValue("font-size"));
        String fillStr = detailElement.attributeValue("fill");
        Integer[] colorArr = RgbUtils.hexToRGB(fillStr);
        List spanElements = detailElement.elements();
        if (spanElements != null && !spanElements.isEmpty()) {
            for (int i = 0; i < spanElements.size(); ++i) {
                Element spanElement = (Element)spanElements.get(i);
                String textStr = spanElement.getTextTrim();
                if (i > 0) {
                    x = PdfUtils.getFloatPxByStr(spanElement.attributeValue("x"));
                    y = height - PdfUtils.getFloatPxByStr(spanElement.attributeValue("y"));
                }
                PdfWriteDataUtils.setTextValue(textStr, under, PdfWriteDataUtils.getFontName(fontFamilyStr, fonts), Float.valueOf(fontSize), colorArr, x, y, dx, ctmStrArr, height);
            }
        } else {
            String textStr = detailElement.getTextTrim();
            PdfWriteDataUtils.setTextValue(textStr, under, PdfWriteDataUtils.getFontName(fontFamilyStr, fonts), Float.valueOf(fontSize), colorArr, x, y, dx, ctmStrArr, height);
        }
    }

    private static void setTextValue(String textStr, PdfContentByte under, BaseFont font, Float fontSize, Integer[] colorArr, float x, float y, String dx, String[] ctmStrArr, float fileHeight) {
        if (!StringUtils.isEmpty((String)dx)) {
            String[] dxArr = dx.split(",");
            for (int i = 0; i < dxArr.length && i < textStr.length(); ++i) {
                String dxStr = dxArr[i];
                String textCurrentStr = textStr.substring(i, i + 1);
                float dxValue = PdfUtils.getFloatPxByStr(dxStr);
                if (i > 0) {
                    x = x + dxValue + fontSize.floatValue();
                }
                PdfWriteDataUtils.writePdfData(textCurrentStr, under, font, fontSize, x + "," + y, colorArr, ctmStrArr, fileHeight);
            }
        } else {
            PdfWriteDataUtils.writePdfData(textStr, under, font, fontSize, x + "," + y, colorArr, ctmStrArr, fileHeight);
        }
    }

    public static void writePdfData(String value, PdfContentByte under, BaseFont font, Float fontSize, String locStr, Integer[] colorArr, String[] ctmStrArr, float fileHeight) {
        if (value == null) {
            value = "";
        }
        under.saveState();
        int align = 0;
        String[] loc = StringUtils.split((String)locStr, (String)",");
        under.beginText();
        float x = Float.parseFloat(loc[0]);
        float y = Float.parseFloat(loc[1]);
        under.resetRGBColorFill();
        under.setRGBColorFill(colorArr[0].intValue(), colorArr[1].intValue(), colorArr[2].intValue());
        under.setFontAndSize(font, fontSize.floatValue());
        if (ctmStrArr != null && ctmStrArr.length > 0) {
            float[] matrixArr = PdfUtils.ctmCalPoint(x, y, fileHeight, ctmStrArr);
            under.setTextMatrix(matrixArr[0], matrixArr[2], matrixArr[1], matrixArr[3], matrixArr[4], matrixArr[5]);
            under.showText(value);
        } else {
            under.showTextAligned(align, value, x, y, 0.0f);
        }
        under.endText();
        under.restoreState();
    }

    private static BaseFont getFontName(String fontFamilyStr, BaseFont[] fonts) {
        String fontFamilyStrLow = fontFamilyStr.toLowerCase();
        if (fontFamilyStrLow.contains("courier")) {
            return fonts[1];
        }
        if (fontFamilyStrLow.contains("kai")) {
            return fonts[2];
        }
        return fonts[0];
    }
}

