/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.VoucherFileInfo;
import api.loader.OFDLoader;
import api.tools.PDFTool;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.convert.DomToJson;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import com.pansoft.xbrl.xbrljson.convert.XbrlToJson;
import com.pansoft.xbrl.xbrljson.util.PropUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VoucherFileUtil {
    private static Log log = LogFactory.getLog(VoucherFileUtil.class);
    private static String DEFAULT_ISSUER_XBRL_FILENAME = "voucher_issuer.xbrl";

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath) throws Exception {
        return VoucherFileUtil.extractXBRLFromOFD(ofdFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromOFD(String ofdFilePath, String outputFile) throws Exception {
        VoucherFileInfo voucherFileInfo = new OFDLoader().extractAttach(ofdFilePath, outputFile);
        return voucherFileInfo;
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath) {
        return VoucherFileUtil.extractXBRLFromPDF(pdfFilePath, "");
    }

    public static VoucherFileInfo extractXBRLFromPDF(String pdfFilePath, String outputFile) {
        return PDFTool.extractXBRLFileFromPDF(pdfFilePath, DEFAULT_ISSUER_XBRL_FILENAME, outputFile);
    }

    public static JSONObject extractJSONFromOFD(String ofdFilePath) throws Exception {
        String xmlValue = null;
        xmlValue = new OFDLoader().extractOriginalXML(ofdFilePath);
        return VoucherFileUtil.xml2Json(xmlValue);
    }

    public static JSONObject xbrl2Json(String xbrlXml, String configId) {
        return new XbrlToJson().convertXbrlJsonData(xbrlXml, configId);
    }

    public static String json2Xbrl(String jsonValue, String configId) throws Exception {
        return new JsonToXbrl().convertXbrlXml(jsonValue, configId);
    }

    public static JSONObject xml2Json(String xmlValue) {
        return new DomToJson().convertXmlJsonData(xmlValue);
    }

    static {
        PropUtil.initFileMap("VoucherType");
    }
}

