/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl.mvn;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.CompilationProblemAdapter;
import org.drools.compiler.kie.builder.impl.DiskResourceReader;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.mvn.CompilationCacheProvider;
import org.drools.compiler.kie.builder.impl.mvn.DrlProject;
import org.drools.compiler.kie.builder.impl.mvn.InternalKieModule;
import org.drools.compiler.kie.builder.impl.mvn.KieBuilderSetImpl;
import org.drools.compiler.kie.builder.impl.mvn.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.mvn.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.mvn.MemoryKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.Drools;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.mvn.KieBuilder;
import org.kie.api.builder.mvn.KieFileSystem;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.builder.mvn.InternalKieBuilder;
import org.kie.memorycompiler.CompilationProblem;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieBuilderImpl
implements InternalKieBuilder {
    private static final Logger log = LoggerFactory.getLogger(KieBuilderImpl.class);
    static final String RESOURCES_ROOT = "src/main/resources/";
    static final String RESOURCES_TEST_ROOT = "src/test/resources";
    static final String JAVA_ROOT = "src/main/java/";
    static final String JAVA_TEST_ROOT = "src/test/java/";
    private static final String RESOURCES_ROOT_DOT_SEPARATOR = "src/main/resources/".replace('/', '.');
    private static final String SPRING_BOOT_ROOT = "BOOT-INF.classes.";
    private static final String[] SUPPORTED_RESOURCES_ROOTS = new String[]{RESOURCES_ROOT_DOT_SEPARATOR, "BOOT-INF.classes."};
    private ResultsImpl results;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private InternalKieModule kModule;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> kieDependencies;
    private KieBuilderSetImpl kieBuilderSet;
    private ClassLoader classLoader;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this(kieFileSystem, null);
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
    }

    @Override
    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.kieDependencies = Arrays.asList(dependencies);
        return this;
    }

    private void init2() {
        this.results = new ResultsImpl();
        this.buildKieModuleModel();
    }

    @Override
    public KieBuilder buildAll() {
        return this.buildAll(KieModuleKieProject::new, o -> true);
    }

    @Override
    public KieBuilder buildAll(Class<? extends KieBuilder.ProjectType> projectClass) {
        if (projectClass == null) {
            return this.buildAll();
        }
        try {
            BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> kprojectSupplier = this.getSupplier(projectClass);
            return this.buildAll(kprojectSupplier, o -> true);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> getSupplier(Class<?> canonicalModelKieProjectClass) throws IllegalAccessException, NoSuchFieldException {
        return (BiFunction)canonicalModelKieProjectClass.getField("SUPPLIER").get(null);
    }

    @Override
    public KieBuilder buildAll(Predicate<String> classFilter) {
        return this.buildAll(KieModuleKieProject::new, classFilter);
    }

    public KieBuilder buildAll(BiFunction<InternalKieModule, ClassLoader, KieModuleKieProject> kprojectSupplier, Predicate<String> classFilter) {
        this.init2();
        if (!this.isBuilt() && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.addKBasesFilesToTrg();
            this.markSource();
            MemoryKieModule memoryKieModule = new MemoryKieModule(this.kModuleModel, this.trgMfs);
            KieModuleKieProject kProject = kprojectSupplier.apply(memoryKieModule, this.classLoader);
            this.compileJavaClasses(kProject.getClassLoader(), classFilter);
            KieBuilderImpl.buildKieProject(this.results, kProject, this.trgMfs);
            this.kModule = kProject.getInternalKieModule();
        }
        return this;
    }

    void markSource() {
        this.srcMfs.mark();
    }

    Collection<String> getModifiedResourcesSinceLastMark() {
        return this.srcMfs.getModifiedResourcesSinceLastMark();
    }

    void updateKieModuleMetaInfo() {
        CompilationCacheProvider.get().writeKieModuleMetaInfo(this.kModule, (ResourceStore)this.trgMfs);
    }

    public static void buildKieModule(InternalKieModule kModule, ResultsImpl messages) {
        KieBuilderImpl.buildKieProject(messages, new KieModuleKieProject(kModule), null);
    }

    private static void buildKieProject(ResultsImpl messages, KieModuleKieProject kProject, MemoryFileSystem trgMfs) {
        kProject.init();
        kProject.verify(messages);
        if (messages.filterMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()) {
            InternalKieModule kModule = kProject.getInternalKieModule();
            if (trgMfs != null) {
                if (Drools.hasXSTream()) {
                    CompilationCacheProvider.get().writeKieModuleMetaInfo(kModule, (ResourceStore)trgMfs);
                }
                kProject.writeProjectOutput(trgMfs, messages);
            }
        }
    }

    private void addKBasesFilesToTrg() {
        for (String fileName : this.srcMfs.getFileNames()) {
            String normalizedName = fileName.replace(File.separatorChar, '/');
            if (!normalizedName.startsWith(RESOURCES_ROOT)) continue;
            this.copySourceToTarget(normalizedName);
        }
    }

    String copySourceToTarget(String fileName) {
        if (!fileName.startsWith(RESOURCES_ROOT)) {
            return null;
        }
        Resource resource = KieBuilderImpl.getResource(this.srcMfs, fileName);
        String trgFileName = fileName.substring(RESOURCES_ROOT.length());
        if (resource != null) {
            this.trgMfs.write(trgFileName, resource, true);
        } else {
            this.trgMfs.remove(trgFileName);
        }
        return trgFileName;
    }

    public void setkModule(MemoryKieModule kModule) {
        this.kModule = kModule;
    }

    public void setTrgMfs(MemoryFileSystem trgMfs) {
        this.trgMfs = trgMfs;
    }

    public MemoryFileSystem getTrgMfs() {
        return this.trgMfs;
    }

    void cloneKieModuleForIncrementalCompilation() {
        this.trgMfs = this.trgMfs.clone();
        this.init2();
        this.kModule = this.kModule.cloneForIncrementalCompilation(this.kModuleModel, this.trgMfs);
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || KieBuilderImpl.isKieExtension(fileName)) continue;
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), KieBuilderImpl.getResource(this.srcMfs, fileName), true);
        }
    }

    private static ResourceType getResourceType(InternalKieModule kieModule, String fileName) {
        return KieBuilderImpl.getResourceType(kieModule.getResourceConfiguration(fileName));
    }

    private static ResourceType getResourceType(ResourceConfiguration conf) {
        return conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
    }

    public static boolean filterFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName, Supplier<InternalResource> file, boolean useFolders) {
        return KieBuilderImpl.isFileInKieBase(kieBase, fileName, file, useFolders) && (KieBuilderImpl.isKieExtension(fileName) || KieBuilderImpl.getResourceType(kieModule, fileName) != null);
    }

    private static boolean isKieExtension(String fileName) {
        return !KieBuilderImpl.isJavaSourceFile(fileName) && ResourceType.determineResourceType((String)fileName) != null;
    }

    private static boolean isFileInKieBase(KieBaseModel kieBase, String fileName, Supplier<InternalResource> file, boolean useFolders) {
        int lastSep = fileName.lastIndexOf("/");
        if (lastSep + 1 < fileName.length() && fileName.charAt(lastSep + 1) == '.') {
            return false;
        }
        if (kieBase.getPackages().isEmpty()) {
            return true;
        }
        String folderNameForFile = lastSep > 0 ? fileName.substring(0, lastSep) : "";
        int resourcesPos = folderNameForFile.indexOf(RESOURCES_ROOT);
        if (resourcesPos >= 0) {
            folderNameForFile = folderNameForFile.substring(resourcesPos + RESOURCES_ROOT.length());
        }
        String pkgNameForFile = KieBuilderImpl.packageNameForFile(fileName, folderNameForFile, !useFolders, file);
        return KieBuilderImpl.isPackageInKieBase(kieBase, pkgNameForFile);
    }

    private static String packageNameForFile(String fileName, String folderNameForFile, boolean discoverPackage, Supplier<InternalResource> file) {
        String packageNameForFile;
        String packageNameFromFolder = folderNameForFile.replace('/', '.');
        if (discoverPackage && (packageNameForFile = KieBuilderImpl.packageNameFromAsset(fileName, file.get())) != null) {
            if (!(packageNameForFile = KieBuilderImpl.getRelativePackageName(packageNameForFile)).equals(packageNameFromFolder)) {
                log.warn("File '" + fileName + "' is in folder '" + folderNameForFile + "' but declares package '" + packageNameForFile + "'. It is advised to have a correspondance between package and folder names.");
            }
            return packageNameForFile;
        }
        return packageNameFromFolder;
    }

    private static String packageNameFromAsset(String fileName, InternalResource file) {
        if (file == null) {
            return null;
        }
        if (fileName.endsWith(".drl")) {
            return KieBuilderImpl.packageNameFromDrl(new String(file.getBytes()));
        }
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            return KieBuilderImpl.packageNameFromDtable(file);
        }
        if (fileName.endsWith(".csv")) {
            return KieBuilderImpl.packageNameFromCsv(file);
        }
        return null;
    }

    private static String packageNameFromDrl(String content) {
        int pkgPos = StringUtils.codeAwareIndexOf((String)content, (String)"package ");
        if (pkgPos >= 0) {
            int end;
            int semiPos = content.indexOf(59, pkgPos += "package ".length());
            int breakPos = content.indexOf(10, pkgPos);
            int n = semiPos > 0 ? (breakPos > 0 ? Math.min(semiPos, breakPos) : semiPos) : (end = breakPos);
            if (end > 0) {
                return content.substring(pkgPos, end).trim();
            }
        }
        return null;
    }

    private static String packageNameFromDtable(InternalResource resource) {
        try {
            String generatedDrl = DecisionTableFactory.loadFromResource((Resource)resource, (DecisionTableConfiguration)new DecisionTableConfigurationImpl());
            return KieBuilderImpl.packageNameFromDrl(generatedDrl);
        }
        catch (Exception e) {
            return KieBuilderImpl.packageNameFromCsv(resource);
        }
    }

    private static String packageNameFromCsv(InternalResource resource) {
        String content = new String(resource.getBytes());
        int pkgPos = content.indexOf("RuleSet");
        if (pkgPos >= 0) {
            pkgPos += "RuleSet ".length();
            while (!Character.isJavaIdentifierStart(content.charAt(pkgPos))) {
                ++pkgPos;
            }
            int end = pkgPos + 1;
            while (Character.isLetterOrDigit(content.charAt(end)) || content.charAt(end) == '.') {
                ++end;
            }
            return content.substring(pkgPos, end).trim();
        }
        return null;
    }

    public static boolean isPackageInKieBase(KieBaseModel kieBaseModel, String pkgName) {
        for (String candidatePkg : kieBaseModel.getPackages()) {
            String pkgNameNoWildcard;
            boolean isNegative = candidatePkg.startsWith("!");
            if (isNegative) {
                candidatePkg = candidatePkg.substring(1);
            }
            if (candidatePkg.equals("*") || pkgName.equals(candidatePkg) || pkgName.endsWith("." + candidatePkg)) {
                return !isNegative;
            }
            if (!candidatePkg.endsWith(".*")) continue;
            String relativePkgNameForFile = KieBuilderImpl.getRelativePackageName(pkgName);
            if (relativePkgNameForFile.equals(pkgNameNoWildcard = candidatePkg.substring(0, candidatePkg.length() - 2)) || relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) {
                return !isNegative;
            }
            if (!relativePkgNameForFile.startsWith(kieBaseModel.getName() + ".") || !(relativePkgNameForFile = relativePkgNameForFile.substring(kieBaseModel.getName().length() + 1)).equals(pkgNameNoWildcard) && !relativePkgNameForFile.startsWith(pkgNameNoWildcard + ".")) continue;
            return !isNegative;
        }
        return false;
    }

    private static String getRelativePackageName(String pkgNameForFile) {
        for (String root : SUPPORTED_RESOURCES_ROOTS) {
            if (!pkgNameForFile.startsWith(root)) continue;
            return pkgNameForFile.substring(root.length());
        }
        return pkgNameForFile;
    }

    @Override
    public Results getResults() {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        return this.results;
    }

    @Override
    public InternalKieModule getKieModule() {
        return this.getKieModule(false);
    }

    @Override
    public InternalKieModule getKieModule(Class<? extends KieBuilder.ProjectType> projectClass) {
        return this.getKieModule(false, projectClass);
    }

    @Override
    public InternalKieModule getKieModuleIgnoringErrors() {
        return this.getKieModule(true);
    }

    private InternalKieModule getKieModule(boolean ignoreErrors, Class<? extends KieBuilder.ProjectType> projectClass) {
        if (!this.isBuilt()) {
            this.buildAll(projectClass);
        }
        if (!ignoreErrors && (this.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}) || this.kModule == null)) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed: " + this.getResults());
        }
        return this.kModule;
    }

    private InternalKieModule getKieModule(boolean ignoreErrors) {
        return this.getKieModule(ignoreErrors, DrlProject.class);
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    @Override
    public InternalKieBuilder withKModuleModel(KieModuleModel kModuleModel) {
        this.kModuleModel = kModuleModel;
        return this;
    }

    private void buildKieModuleModel() {
        if (this.kModuleModel == null) {
            if (this.srcMfs.isAvailable("src/main/resources/META-INF/kmodule.xml")) {
                byte[] kModuleModelXml = this.srcMfs.getBytes("src/main/resources/META-INF/kmodule.xml");
                try {
                    this.kModuleModel = KieModuleModelImpl.fromXML((InputStream)new ByteArrayInputStream(kModuleModelXml));
                }
                catch (Exception e) {
                    this.results.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodule.xml found, but unable to read\n" + e.getMessage());
                    this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
                }
            } else {
                this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
            }
        }
        KieBuilderImpl.setDefaultsforEmptyKieModule(this.kModuleModel);
    }

    public static void setDefaultsforEmptyKieModule(KieModuleModel kModuleModel) {
        if (kModuleModel != null && kModuleModel.getKieBaseModels().isEmpty()) {
            KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultStatelessKieSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        }
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.kModuleModel != null && Drools.hasXSTream()) {
            this.trgMfs.write("META-INF/kmodule.xml", this.kModuleModel.toXML().getBytes(IoUtils.UTF8_CHARSET), true);
        }
    }

    private void compileJavaClasses(ClassLoader classLoader, Predicate<String> classFilter) {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, KieBuilderImpl.getResource(this.srcMfs, fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        ArrayList<String> javaTestFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!KieBuilderImpl.isJavaSourceFile(fileName) || !KieBuilderImpl.noClassFileForGivenSourceFile(classFiles, fileName) || !KieBuilderImpl.notVetoedByFilter(classFilter, fileName)) continue;
            if (!(fileName = fileName.replace(File.separatorChar, '/')).startsWith(JAVA_ROOT) && !fileName.startsWith(JAVA_TEST_ROOT)) {
                this.results.addMessage(Message.Level.WARNING, fileName, "Found Java file out of the Java source folder: \"" + fileName + "\"");
                continue;
            }
            if (fileName.substring(JAVA_ROOT.length()).indexOf(47) < 0) {
                this.results.addMessage(Message.Level.ERROR, fileName, "A Java class must have a package: " + fileName.substring(JAVA_ROOT.length()) + " is not allowed");
                continue;
            }
            if (fileName.startsWith(JAVA_ROOT)) {
                javaFiles.add(fileName);
                continue;
            }
            javaTestFiles.add(fileName);
        }
        if (!javaFiles.isEmpty() || !javaTestFiles.isEmpty()) {
            KnowledgeBuilderConfigurationImpl kconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{classLoader});
            JavaConfiguration javaConf = (JavaConfiguration)kconf.getDialectConfiguration("java");
            this.compileJavaClasses(javaConf, classLoader, javaFiles, JAVA_ROOT);
            this.compileJavaClasses(javaConf, classLoader, javaTestFiles, JAVA_TEST_ROOT);
        }
    }

    private static boolean notVetoedByFilter(Predicate<String> classFilter, String sourceFileName) {
        return classFilter.test(sourceFileName);
    }

    private static boolean noClassFileForGivenSourceFile(List<String> classFiles, String sourceFileName) {
        return !classFiles.contains(sourceFileName.substring(0, sourceFileName.length() - ".java".length()));
    }

    private static boolean isJavaSourceFile(String fileName) {
        return fileName.endsWith(".java");
    }

    private void compileJavaClasses(JavaConfiguration javaConf, ClassLoader classLoader, List<String> javaFiles, String rootFolder) {
        if (!javaFiles.isEmpty()) {
            String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
            JavaCompiler javaCompiler = this.createCompiler(javaConf, rootFolder);
            CompilationResult res = javaCompiler.compile(sourceFiles, this.srcMfs, (ResourceStore)this.trgMfs, classLoader);
            for (CompilationProblem problem : res.getErrors()) {
                this.results.addMessage((org.kie.internal.jci.CompilationProblem)new CompilationProblemAdapter(problem));
            }
            for (CompilationProblem problem : res.getWarnings()) {
                this.results.addMessage((org.kie.internal.jci.CompilationProblem)new CompilationProblemAdapter(problem));
            }
        }
    }

    private JavaCompiler createCompiler(JavaConfiguration javaConf, String sourceFolder) {
        JavaCompiler javaCompiler = JavaCompilerFactory.loadCompiler((JavaConfiguration)javaConf);
        javaCompiler.setSourceFolder(sourceFolder);
        return javaCompiler;
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (child.isDirectory()) {
                    File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                    if (returnedFile == null) continue;
                    return returnedFile;
                }
                if (!child.getName().endsWith("pom.properties")) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public KieBuilderSet createFileSet(String ... files) {
        return this.createFileSet(Message.Level.ERROR, files);
    }

    @Override
    public KieBuilderSet createFileSet(Message.Level minimalLevel, String ... files) {
        if (this.kieBuilderSet == null || this.kieBuilderSet.getMinimalLevel() != minimalLevel) {
            this.kieBuilderSet = new KieBuilderSetImpl(this, minimalLevel);
        }
        return this.kieBuilderSet.setFiles(files);
    }

    @Override
    public IncrementalResults incrementalBuild() {
        return new KieBuilderSetImpl(this).build();
    }

    private static Resource getResource(ResourceReader resourceReader, String pResourceName) {
        if (resourceReader instanceof MemoryFileSystem) {
            return ((MemoryFileSystem)resourceReader).getResource(pResourceName);
        }
        byte[] bytes = resourceReader.getBytes(pResourceName);
        return bytes != null ? KieServices.get().getResources().newByteArrayResource(bytes) : null;
    }
}

