/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl.mvn;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import kd.bos.exception.KDBizException;
import org.drools.compiler.kie.builder.MaterializedLambda;
import org.drools.compiler.kie.builder.impl.InternalKieServices;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.mvn.InternalKieModule;
import org.drools.compiler.kie.builder.impl.mvn.KInternalKieContainer;
import org.drools.compiler.kie.builder.impl.mvn.KieContainerSessionsPoolImpl;
import org.drools.compiler.kie.builder.impl.mvn.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.mvn.KieProject;
import org.drools.compiler.kie.util.InjectionHelper;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.management.KieContainerMonitor;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatefulSessionPool;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.Drools;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieContainerSessionsPool;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.time.Calendar;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements KInternalKieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private KieProject kProject;
    private final Map<String, KieBase> kBases = new ConcurrentHashMap<String, KieBase>();
    private final Map<String, KieSession> kSessions = new ConcurrentHashMap<String, KieSession>();
    private final Map<String, StatelessKieSession> statelessKSessions = new ConcurrentHashMap<String, StatelessKieSession>();
    private final String containerId;
    private final Map<String, KieSessionConfiguration> sessionConfsCache = new ConcurrentHashMap<String, KieSessionConfiguration>();
    private static final ResourceType[] TYPES_TO_BE_INCLUDED = new ResourceType[]{ResourceType.DSL, ResourceType.GDRL};

    public KieModule getMainKieModule() {
        throw new KDBizException("no support maven in this project!");
    }

    public InternalKieModule getKDKieModule() {
        return ((KieModuleKieProject)this.kProject).getInternalKieModule();
    }

    public KieContainerImpl(String containerId, KieProject kProject) {
        this.kProject = kProject;
        this.containerId = containerId;
        kProject.init();
        this.initMBeans(containerId);
    }

    private void initMBeans(String containerId) {
        if (this.isMBeanOptionEnabled()) {
            KieContainerMonitor monitor = new KieContainerMonitor((InternalKieContainer)this);
            ObjectName on = DroolsManagementAgent.createObjectNameBy((String)containerId);
            DroolsManagementAgent.getInstance().registerMBean((Object)this, (Object)monitor, on);
        }
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ReleaseId getConfiguredReleaseId() {
        throw new KDBizException("no support maven in this project!");
    }

    public ReleaseId getResolvedReleaseId() {
        throw new KDBizException("no support maven in this project!");
    }

    public ReleaseId getReleaseId() {
        throw new KDBizException("no support maven in this project!");
    }

    public InputStream getPomAsStream() {
        throw new KDBizException("no support maven in this project!");
    }

    public long getCreationTimestamp() {
        return this.kProject.getCreationTimestamp();
    }

    public ReleaseId getContainerReleaseId() {
        throw new KDBizException("no support maven in this project!");
    }

    public Results updateToVersion(ReleaseId newReleaseId) {
        throw new KDBizException("no support maven in this project!");
    }

    public Results updateDependencyToVersion(ReleaseId currentReleaseId, ReleaseId newReleaseId) {
        throw new KDBizException("no support maven in this project!");
    }

    private boolean isModifyingUsedFunction(KieJarChangeSet cs) {
        return cs.getChanges().values().stream().flatMap(resourceChangeSet -> resourceChangeSet.getChanges().stream()).anyMatch(change -> change.getType() == ResourceChange.Type.FUNCTION && change.getChangeType() == ChangeType.UPDATED);
    }

    private Collection<String> getUnchangedResources(org.drools.compiler.kie.builder.impl.InternalKieModule newKM, KieJarChangeSet cs) {
        ArrayList<String> dslFiles = new ArrayList<String>();
        for (String file : newKM.getFileNames()) {
            if (!this.includeIfUnchanged(file) || cs.contains(file)) continue;
            dslFiles.add(file);
        }
        return dslFiles;
    }

    private boolean includeIfUnchanged(String file) {
        for (ResourceType type : TYPES_TO_BE_INCLUDED) {
            if (!type.matchesExtension(file)) continue;
            return true;
        }
        return false;
    }

    private boolean isModifyingUsedClass(List<String> modifiedClasses, ClassLoader classLoader) {
        return modifiedClasses.stream().anyMatch(c -> this.isClassInUse(classLoader, ClassUtils.convertResourceToClassName((String)c)));
    }

    private boolean isClassInUse(ClassLoader rootClassLoader, String className) {
        return !(rootClassLoader instanceof ProjectClassLoader) || ((ProjectClassLoader)rootClassLoader).isClassInUse(className, MaterializedLambda.class);
    }

    private Collection<Class<?>> reinitModifiedClasses(org.drools.compiler.kie.builder.impl.InternalKieModule newKM, List<String> modifiedClasses, ClassLoader classLoader, boolean modifyingUsedClass) {
        if (modifiedClasses.isEmpty() || !(classLoader instanceof ProjectClassLoader)) {
            return Collections.emptyList();
        }
        HashSet<String> reloadedClasses = new HashSet<String>(modifiedClasses);
        ProjectClassLoader projectClassLoader = (ProjectClassLoader)classLoader;
        if (modifyingUsedClass) {
            reloadedClasses.addAll(projectClassLoader.reinitTypes().stream().map(ClassUtils::convertClassToResourcePath).collect(Collectors.toList()));
        }
        ArrayList classes = new ArrayList();
        for (String resourceName : reloadedClasses) {
            String className = ClassUtils.convertResourceToClassName((String)resourceName);
            byte[] bytes = newKM.getBytes(resourceName);
            if (bytes == null) continue;
            Class clazz = projectClassLoader.defineClass(className, resourceName, bytes);
            classes.add(clazz);
        }
        return classes;
    }

    private List<String> getModifiedClasses(KieJarChangeSet cs) {
        ArrayList<String> modifiedClasses = new ArrayList<String>();
        for (ResourceChangeSet rcs : cs.getChanges().values()) {
            String resourceName;
            if (rcs.getChangeType() == ChangeType.REMOVED || !(resourceName = rcs.getResourceName()).endsWith(".class")) continue;
            modifiedClasses.add(resourceName);
        }
        return modifiedClasses;
    }

    public Collection<String> getKieBaseNames() {
        return this.kProject.getKieBaseNames();
    }

    public Collection<String> getKieSessionNamesInKieBase(String kBaseName) {
        KieBaseModel kieBaseModel = this.kProject.getKieBaseModel(kBaseName);
        return kieBaseModel != null ? kieBaseModel.getKieSessionModels().keySet() : Collections.emptySet();
    }

    public KieBase getKieBase() {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a default KieBase");
        }
        return this.getKieBase(defaultKieBaseModel.getName());
    }

    public Results verify() {
        return this.kProject.verify();
    }

    public Results verify(String ... kModelNames) {
        return this.kProject.verify(kModelNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieBase getKieBase(String kBaseName, KieBaseConfiguration conf) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            KieBaseModelImpl kBaseModel;
            KieBaseModelImpl kieBaseModelImpl = kBaseModel = this.getKieBaseModelImpl(kBaseName);
            synchronized (kieBaseModelImpl) {
                kBase = this.kBases.get(kBaseName);
                if (kBase == null) {
                    ResultsImpl msgs = new ResultsImpl();
                    kBase = this.createKieBase(kBaseModel, this.kProject, msgs, conf);
                    if (kBase == null) {
                        throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(new Message.Level[]{Message.Level.ERROR}));
                    }
                    this.kBases.put(kBaseName, kBase);
                }
            }
        }
        return kBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            KieBaseModelImpl kBaseModel;
            KieBaseModelImpl kieBaseModelImpl = kBaseModel = this.getKieBaseModelImpl(kBaseName);
            synchronized (kieBaseModelImpl) {
                kBase = this.kBases.get(kBaseName);
                if (kBase == null) {
                    ResultsImpl msgs = new ResultsImpl();
                    kBase = this.createKieBase(kBaseModel, this.kProject, msgs, null);
                    if (kBase == null) {
                        throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(new Message.Level[]{Message.Level.ERROR}));
                    }
                    this.kBases.put(kBaseName, kBase);
                }
            }
        }
        return kBase;
    }

    public KieBase newKieBase(KieBaseConfiguration conf) {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a default KieBase");
        }
        return this.newKieBase(defaultKieBaseModel.getName(), conf);
    }

    public KieBase newKieBase(String kBaseName, KieBaseConfiguration conf) {
        ResultsImpl msgs = new ResultsImpl();
        KieBase kBase = this.createKieBase(this.getKieBaseModelImpl(kBaseName), this.kProject, msgs, conf);
        if (kBase == null) {
            throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        return kBase;
    }

    private KieBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        InternalKieModule kModule = kieProject.getKieModuleForKBase(kBaseModel.getName());
        InternalKnowledgeBase kBase = kModule.createKieBase(kBaseModel, kieProject, messages, conf);
        kModule.afterKieBaseCreationUpdate(kBaseModel.getName(), kBase);
        if (kBase == null) {
            return null;
        }
        kBase.setContainerId(this.containerId);
        kBase.setKieContainer((InternalKieContainer)this);
        kBase.initMBeans();
        return kBase;
    }

    private KieBaseModelImpl getKieBaseModelImpl(String kBaseName) {
        KieBaseModelImpl kBaseModel = (KieBaseModelImpl)this.kProject.getKieBaseModel(kBaseName);
        if (kBaseModel == null) {
            throw new RuntimeException("The requested KieBase \"" + kBaseName + "\" does not exist");
        }
        return kBaseModel;
    }

    public KieSession newKieSession() {
        return this.newKieSession((Environment)null, null);
    }

    public KieSession getKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.getKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.newKieSession((Environment)null, conf);
    }

    public KieSession newKieSession(Environment environment) {
        return this.newKieSession(environment, null);
    }

    public KieSession newKieSession(Environment environment, KieSessionConfiguration conf) {
        return this.newKieSession(null, environment, conf);
    }

    public KieContainerSessionsPool newKieSessionsPool(int initialSize) {
        return new KieContainerSessionsPoolImpl(this, initialSize);
    }

    StatefulSessionPool createKieSessionsPool(String kSessionName, KieSessionConfiguration conf, Environment env, int initialSize, boolean stateless) {
        KieSessionModel kSessionModel;
        KieSessionModel kieSessionModel = kSessionModel = kSessionName != null ? this.getKieSessionModel(kSessionName) : this.findKieSessionModel(false);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        KnowledgeBaseImpl kBase = (KnowledgeBaseImpl)this.getKieBaseFromKieSessionModel(kSessionModel);
        return kBase == null ? null : new StatefulSessionPool(kBase, initialSize, () -> {
            SessionConfiguration sessConf = conf != null ? (SessionConfiguration)conf : kBase.getSessionConfiguration();
            StatefulKnowledgeSessionImpl kSession = stateless ? kBase.internalCreateStatefulKnowledgeSession(env, sessConf, false).setStateless(true) : (StatefulKnowledgeSessionImpl)kBase.newKieSession((KieSessionConfiguration)sessConf, env);
            this.registerNewKieSession(kSessionModel, (InternalKnowledgeBase)kBase, (KieSession)kSession);
            return kSession;
        });
    }

    private KieSessionModel findKieSessionModel(boolean stateless) {
        KieSessionModel defaultKieSessionModel;
        KieSessionModel kieSessionModel = defaultKieSessionModel = stateless ? this.kProject.getDefaultStatelessKieSession() : this.kProject.getDefaultKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException(stateless ? "Cannot find a default StatelessKieSession" : "Cannot find a default KieSession");
        }
        return defaultKieSessionModel;
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession((KieSessionConfiguration)null);
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.newStatelessKieSession(defaultKieSessionModel.getName(), conf);
    }

    public StatelessKieSession getStatelessKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.getStatelessKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(String kSessionName) {
        return this.newKieSession(kSessionName, null, null);
    }

    public KieSession getKieSession(String kSessionName) {
        KieSession kieSession = this.kSessions.get(kSessionName);
        if (kieSession instanceof StatefulKnowledgeSessionImpl && !((StatefulKnowledgeSessionImpl)kieSession).isAlive()) {
            this.kSessions.remove(kSessionName);
            kieSession = null;
        }
        return kieSession != null ? kieSession : this.newKieSession(kSessionName);
    }

    public KieSession newKieSession(String kSessionName, Environment environment) {
        return this.newKieSession(kSessionName, environment, null);
    }

    public KieSession newKieSession(String kSessionName, KieSessionConfiguration conf) {
        return this.newKieSession(kSessionName, null, conf);
    }

    public KieSession newKieSession(String kSessionName, Environment environment, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel;
        KieSessionModelImpl kieSessionModelImpl = kSessionModel = kSessionName != null ? (KieSessionModelImpl)this.getKieSessionModel(kSessionName) : (KieSessionModelImpl)this.findKieSessionModel(false);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        KieBase kBase = this.getKieBaseFromKieSessionModel((KieSessionModel)kSessionModel);
        if (kBase == null) {
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf != null ? conf : this.getKieSessionConfiguration((KieSessionModel)kSessionModel), environment);
        this.registerNewKieSession((KieSessionModel)kSessionModel, (InternalKnowledgeBase)kBase, kSession);
        return kSession;
    }

    @Override
    public KieSession newKieSessionByCacheKBaseNoSessionModel(String kSessionName, InternalKnowledgeBase kBase, KieSessionConfiguration conf) {
        if (kBase == null || conf == null) {
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf, null);
        return kSession;
    }

    @Override
    public KieSession newKieSessionByCacheKBase(String kSessionName, InternalKnowledgeBase kBase) {
        return this.newKieSessionByCacheKBase(kSessionName, kBase, null, null);
    }

    @Override
    public KieSession newKieSessionByCacheKBase(String kSessionName, InternalKnowledgeBase kBase, Environment environment, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel;
        KieSessionModelImpl kieSessionModelImpl = kSessionModel = kSessionName != null ? (KieSessionModelImpl)this.getKieSessionModel(kSessionName) : (KieSessionModelImpl)this.findKieSessionModel(false);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kBase == null) {
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf != null ? conf : this.getKieSessionConfiguration((KieSessionModel)kSessionModel), environment);
        this.registerNewKieSession((KieSessionModel)kSessionModel, kBase, kSession);
        return kSession;
    }

    private void registerNewKieSession(KieSessionModel kSessionModel, InternalKnowledgeBase kBase, KieSession kSession) {
        if (Drools.isJndiAvailable()) {
            InjectionHelper.wireSessionComponents((KieSessionModel)kSessionModel, (KieSession)kSession);
        }
        this.registerLoggers(kSessionModel, (KieRuntimeEventManager)kSession);
        this.registerCalendars(kSessionModel, kSession);
        ((StatefulKnowledgeSessionImpl)kSession).initMBeans(this.containerId, kBase.getId(), kSessionModel.getName());
        this.kSessions.put(kSessionModel.getName(), kSession);
    }

    private KieBase getKieBaseFromKieSessionModel(KieSessionModel kSessionModel) {
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
            throw new RuntimeException("Trying to create a stateful KieSession from a stateless KieSessionModel: " + kSessionModel.getName());
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        return kBase;
    }

    private void registerLoggers(KieSessionModel kSessionModel, KieRuntimeEventManager kSession) {
        FileLoggerModel fileLogger;
        KnowledgeRuntimeLoggerProviderImpl kieLoggers = new KnowledgeRuntimeLoggerProviderImpl();
        if (kSessionModel.getConsoleLogger() != null) {
            kieLoggers.newConsoleLogger(kSession);
        }
        if ((fileLogger = kSessionModel.getFileLogger()) != null) {
            if (fileLogger.isThreaded()) {
                kieLoggers.newThreadedFileLogger(kSession, fileLogger.getFile(), fileLogger.getInterval());
            } else {
                kieLoggers.newFileLogger(kSession, fileLogger.getFile());
            }
        }
    }

    private void registerCalendars(KieSessionModel kSessionModel, KieSession kSession) {
        for (Map.Entry entry : kSessionModel.getCalendars().entrySet()) {
            try {
                Calendar calendar = (Calendar)this.getClassLoader().loadClass((String)entry.getValue()).newInstance();
                kSession.getCalendars().set((String)entry.getKey(), calendar);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Cannot instance calendar " + (String)entry.getKey(), (Throwable)e);
            }
        }
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName) {
        return this.newStatelessKieSession(kSessionName, null);
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel;
        KieSessionModelImpl kieSessionModelImpl = kSessionModel = kSessionName != null ? (KieSessionModelImpl)this.getKieSessionModel(kSessionName) : (KieSessionModelImpl)this.findKieSessionModel(true);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
            throw new RuntimeException("Trying to create a stateless KieSession from a stateful KieSessionModel: " + kSessionModel.getName());
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        StatelessKieSession statelessKieSession = kBase.newStatelessKieSession(conf != null ? conf : this.getKieSessionConfiguration((KieSessionModel)kSessionModel));
        if (Drools.isJndiAvailable()) {
            InjectionHelper.wireSessionComponents((KieSessionModel)kSessionModel, (StatelessKieSession)statelessKieSession);
        }
        this.registerLoggers((KieSessionModel)kSessionModel, (KieRuntimeEventManager)statelessKieSession);
        ((StatelessKnowledgeSessionImpl)statelessKieSession).initMBeans(this.containerId, ((InternalKnowledgeBase)kBase).getId(), kSessionModel.getName());
        this.statelessKSessions.put(kSessionModel.getName(), statelessKieSession);
        return statelessKieSession;
    }

    public StatelessKieSession getStatelessKieSession(String kSessionName) {
        StatelessKieSession kieSession = this.statelessKSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newStatelessKieSession(kSessionName);
    }

    public KieSessionConfiguration getKieSessionConfiguration() {
        return this.getKieSessionConfiguration(this.kProject.getDefaultKieSession());
    }

    public KieSessionConfiguration getKieSessionConfiguration(String kSessionName) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        return this.getKieSessionConfiguration((KieSessionModel)kSessionModel);
    }

    private KieSessionConfiguration getKieSessionConfiguration(KieSessionModel kSessionModel) {
        KieSessionConfiguration ksConf = this.sessionConfsCache.computeIfAbsent(kSessionModel.getName(), k -> new SessionConfigurationImpl(null, this.kProject.getClassLoader()));
        ksConf.setOption((KieSessionOption)kSessionModel.getClockType());
        ksConf.setOption((KieSessionOption)kSessionModel.getBeliefSystem());
        return ksConf;
    }

    public void dispose() {
        this.sessionConfsCache.clear();
        this.kBases.values().forEach(kb -> ((InternalKnowledgeBase)kb).setKieContainer(null));
        HashSet<DroolsManagementAgent.CBSKey> cbskeys = new HashSet<DroolsManagementAgent.CBSKey>();
        if (this.isMBeanOptionEnabled()) {
            for (Map.Entry<String, KieSession> entry : this.kSessions.entrySet()) {
                cbskeys.add(new DroolsManagementAgent.CBSKey(this.containerId, ((InternalKnowledgeBase)entry.getValue().getKieBase()).getId(), entry.getKey()));
            }
            for (Map.Entry<String, KieSession> entry : this.statelessKSessions.entrySet()) {
                cbskeys.add(new DroolsManagementAgent.CBSKey(this.containerId, ((InternalKnowledgeBase)((StatelessKieSession)entry.getValue()).getKieBase()).getId(), entry.getKey()));
            }
        }
        for (KieSession kieSession : this.kSessions.values()) {
            kieSession.dispose();
        }
        this.kSessions.clear();
        this.statelessKSessions.clear();
        if (this.isMBeanOptionEnabled()) {
            for (DroolsManagementAgent.CBSKey cBSKey : cbskeys) {
                DroolsManagementAgent.getInstance().unregisterKnowledgeSessionBean(cBSKey);
            }
            for (KieBase kieBase : this.kBases.values()) {
                DroolsManagementAgent.getInstance().unregisterKnowledgeBase((InternalKnowledgeBase)kieBase);
            }
            DroolsManagementAgent.getInstance().unregisterMBeansFromOwner((Object)this);
        }
        ((InternalKieServices)KieServices.Factory.get()).clearRefToContainerId(this.containerId, (KieContainer)this);
    }

    public void disposeSession(KieSession kieSession) {
        if (!this.isMBeanOptionEnabled()) {
            this.kSessions.values().remove(kieSession);
        }
    }

    private boolean isMBeanOptionEnabled() {
        return MBeansOption.isEnabled((String)System.getProperty("kie.mbeans", MBeansOption.DISABLED.toString()));
    }

    public KieProject getKieProject() {
        return this.kProject;
    }

    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }

    @Override
    public KieBase addKieBase(String kBaseName, KieBaseModel kieBaseModel, KieSessionModel kieSessionModel) {
        if (this.kBases.get(kBaseName) != null) {
            return this.kBases.get(kBaseName);
        }
        RuleBaseConfiguration kbaseConfig = new RuleBaseConfiguration();
        kbaseConfig.setDeclarativeAgendaEnabled(false);
        kbaseConfig.setEventProcessingMode(EventProcessingOption.CLOUD);
        kbaseConfig.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((String)kBaseName, (KieBaseConfiguration)kbaseConfig);
        this.kBases.put(kBaseName, (KieBase)knowledgeBase);
        this.kProject.addKieBase(kieBaseModel, kieSessionModel);
        return knowledgeBase;
    }

    @Override
    public KieBase addKieBaseNoSessionModel(String kBaseName, InternalKnowledgeBase knowledgeBase) {
        if (knowledgeBase != null) {
            this.kBases.put(kBaseName, (KieBase)knowledgeBase);
        }
        return knowledgeBase;
    }

    public static class CompositeRunnable
    implements Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        public void add(Runnable runnable) {
            this.runnables.add(runnable);
        }

        void addAll(List<Runnable> runnableList) {
            this.runnables.addAll(runnableList);
        }

        @Override
        public void run() {
            this.runnables.forEach(Runnable::run);
        }
    }
}

