/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl.mvn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.mvn.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.mvn.InternalKieModule;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(KieModuleKieProject.class);
    private List<InternalKieModule> kieModules;
    private Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private InternalKieModule kieModule;
    private ProjectClassLoader cl;

    public KieModuleKieProject(InternalKieModule kieModule) {
        this(kieModule, null);
    }

    public KieModuleKieProject(InternalKieModule kieModule, ClassLoader parent) {
        this.kieModule = kieModule;
        this.cl = kieModule.createModuleClassLoader(parent);
    }

    @Override
    public void init() {
        if (this.kieModules == null) {
            this.indexParts(this.kieModule, this.kJarFromKBaseName);
            this.kieModules = new ArrayList<InternalKieModule>();
            this.kieModules.add(this.kieModule);
            this.cl.storeClasses(this.getClassesMap());
        }
    }

    private Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (InternalKieModule kModule : this.kieModules) {
            classes.putAll(kModule.getClassesMap());
        }
        return classes;
    }

    @Override
    public long getCreationTimestamp() {
        return this.kieModule.getCreationTimestamp();
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    public InternalKieModule getInternalKieModule() {
        return this.kieModule;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public boolean hasDynamicClassLoader() {
        return this.cl.isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, KieBaseModel> updateToModule(InternalKieModule updatedKieModule) {
        HashMap<String, KieBaseModel> oldKieBaseModels = new HashMap<String, KieBaseModel>();
        oldKieBaseModels.putAll(this.kBaseModels);
        this.kieModules = null;
        this.kJarFromKBaseName.clear();
        KieModuleKieProject kieModuleKieProject = this;
        synchronized (kieModuleKieProject) {
            this.cleanIndex();
            this.init();
            this.cl.setResourceProvider(this.kieModule.createResourceProvider());
        }
        return oldKieBaseModels;
    }

    @Override
    public synchronized KieBaseModel getDefaultKieBaseModel() {
        return super.getDefaultKieBaseModel();
    }

    @Override
    public synchronized KieSessionModel getDefaultKieSession() {
        return super.getDefaultKieSession();
    }

    @Override
    public synchronized KieSessionModel getDefaultStatelessKieSession() {
        return super.getDefaultStatelessKieSession();
    }

    @Override
    public synchronized KieBaseModel getKieBaseModel(String kBaseName) {
        return super.getKieBaseModel(kBaseName);
    }

    @Override
    public synchronized KieSessionModel getKieSessionModel(String kSessionName) {
        return super.getKieSessionModel(kSessionName);
    }
}

