/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr.mvn;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.compiler.builder.impl.mvn.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr (" + packageDescr.getName() + ") in different namespaces (namespace=" + this.getNamespace() + " packageDescr=" + packageDescr.getNamespace() + ")");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        List currentImports = this.getImports();
        for (Object descr : packageDescr.getImports()) {
            if (currentImports.contains(descr)) continue;
            this.addImport((ImportDescr)descr);
            descr.setResource(resource);
        }
        List currentFunctionImports = this.getFunctionImports();
        for (Object descr : packageDescr.getFunctionImports()) {
            if (currentFunctionImports.contains(descr)) continue;
            this.addFunctionImport((FunctionImportDescr)descr);
            descr.setResource(resource);
        }
        List accumulateImports = this.getAccumulateImports();
        for (Object descr : packageDescr.getAccumulateImports()) {
            if (accumulateImports.contains(descr)) continue;
            this.addAccumulateImport((AccumulateImportDescr)descr);
            descr.setResource(resource);
        }
        List currentAttributeDescrs = this.getAttributes();
        for (Object descr : packageDescr.getAttributes()) {
            if (currentAttributeDescrs.contains(descr)) continue;
            this.addAttribute((AttributeDescr)descr);
            descr.setResource(resource);
        }
        List currentGlobalDescrs = this.getGlobals();
        for (Object descr : packageDescr.getGlobals()) {
            if (currentGlobalDescrs.contains(descr)) continue;
            this.addGlobal((GlobalDescr)descr);
            descr.setResource(resource);
        }
        List currentFunctionDescrs = this.getFunctions();
        for (Object descr : packageDescr.getFunctions()) {
            if (currentFunctionDescrs.contains(descr)) continue;
            this.addFunction((FunctionDescr)descr);
            descr.setResource(resource);
        }
        List ruleDescrs = this.getRules();
        for (Object descr : packageDescr.getRules()) {
            if (ruleDescrs.contains(descr)) continue;
            this.addRule((RuleDescr)descr);
            descr.setResource(resource);
        }
        List typeDeclarationDescrs = this.getTypeDeclarations();
        for (Object descr : packageDescr.getTypeDeclarations()) {
            if (typeDeclarationDescrs.contains(descr)) continue;
            this.addTypeDeclaration((TypeDeclarationDescr)descr);
            descr.setResource(resource);
        }
        List enumDeclarationDescrs = this.getEnumDeclarations();
        for (Object enumDescr : packageDescr.getEnumDeclarations()) {
            if (enumDeclarationDescrs.contains(enumDescr)) continue;
            this.addEnumDeclaration((EnumDeclarationDescr)enumDescr);
            enumDescr.setResource(resource);
        }
        Set entryPointDeclarationDescrs = this.getEntryPointDeclarations();
        for (EntryPointDeclarationDescr descr : packageDescr.getEntryPointDeclarations()) {
            if (entryPointDeclarationDescrs.contains(descr)) continue;
            this.addEntryPointDeclaration(descr);
            descr.setResource(resource);
        }
        Set windowDeclarationDescrs = this.getWindowDeclarations();
        for (WindowDeclarationDescr descr : packageDescr.getWindowDeclarations()) {
            if (windowDeclarationDescrs.contains(descr)) continue;
            this.addWindowDeclaration(descr);
            descr.setResource(resource);
        }
        packageDescr.getPreferredPkgUUID().ifPresent(pkgUUID -> {
            if (this.getPreferredPkgUUID().isPresent() && !pkgUUID.equals(this.getPreferredPkgUUID().get())) {
                throw new RuntimeException(String.format("Trying to overwrite preferredPkgUUID %s with a different value %s", this.getPreferredPkgUUID().get(), pkgUUID));
            }
            this.setPreferredPkgUUID((String)pkgUUID);
        });
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(KnowledgeBuilderImpl.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements KnowledgeBuilderImpl.AssetFilter {
        public List<KnowledgeBuilderImpl.AssetFilter> filters = new ArrayList<KnowledgeBuilderImpl.AssetFilter>();

        @Override
        public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
            for (KnowledgeBuilderImpl.AssetFilter filter : this.filters) {
                KnowledgeBuilderImpl.AssetFilter.Action result = filter.accept(type, pkgName, assetName);
                if (KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
        }
    }
}

