/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser;

import com.szhtxx.etcloud.smser.dto.BillDealResultDto;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.dto.SmsRequestDto;
import com.szhtxx.etcloud.smser.dto.SmsResultDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.exception.SmserException;
import com.szhtxx.etcloud.smser.methods.smser.invoice.InvoiceMethods;
import com.szhtxx.etcloud.smser.service.BillsCheckService;
import com.szhtxx.etcloud.smser.service.GoodsDiscountService;
import com.szhtxx.etcloud.smser.service.GoodsMergeService;
import com.szhtxx.etcloud.smser.service.MultiMergeCoreService;
import com.szhtxx.etcloud.smser.service.NegativeRowService;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSERN {
    private static Logger logger = LoggerFactory.getLogger(SMSERN.class);
    static InvoiceMethods invoiceMethods = new InvoiceMethods();

    public SmsResultDto doSMSER(SmsRequestDto requestDto) {
        if (requestDto.getSmr().getSplitGoodsWithNumber() == 1) {
            requestDto.getSmr().setSplitGoodsWithNumber(2);
        }
        requestDto.getSmr().setSplitListType(1);
        SmsResultDto resultDto = new SmsResultDto();
        int totals = 0;
        int failNums = 0;
        try {
            this.checkSms(requestDto);
            if (requestDto.getSmr() == null) {
                requestDto.setSmr(new SmruleConfigDto());
            }
            totals = requestDto.getBillSList().size();
            MultiMergeCoreService.checkMerge(requestDto, resultDto);
            SmruleConfigDto smruleConfigDto = requestDto.getSmr();
            List<BillSubjectDto> billSList = requestDto.getBillSList();
            if (smruleConfigDto.isMcc()) {
                MultiMergeCoreService.sortBillSubjects(billSList);
            }
            failNums = this.ruleBillSubjects(requestDto, resultDto);
        }
        catch (SmserException e) {
            logger.error("\u5165\u53c2\u6821\u9a8c\u68c0\u67e5\u5f02\u5e38 e={}", (Throwable)e);
            resultDto.setSuccess(false);
            resultDto.setErrorMsg(e.getMessage());
            return resultDto;
        }
        catch (Exception e) {
            logger.error("\u5355\u636e\u5904\u7406\u5f02\u5e38", (Throwable)e);
            resultDto.setSuccess(false);
            resultDto.setErrorMsg("\u5f02\u5e38" + e.getMessage());
            long l = System.currentTimeMillis();
        }
        resultDto.setTotals(totals);
        resultDto.setDoSucc(totals - failNums);
        resultDto.setDoFail(failNums);
        return resultDto;
    }

    private int ruleBillSubjects(SmsRequestDto requestDto, SmsResultDto resultDto) throws IllegalAccessException, InvocationTargetException {
        SmruleConfigDto smruleConfigDto = requestDto.getSmr();
        List<BillSubjectDto> billSList = requestDto.getBillSList();
        ArrayList<BillDetailDto> billDList = new ArrayList<BillDetailDto>();
        String isOil = requestDto.getIsOil();
        int failNums = 0;
        String mccNote = "";
        int size = billSList.size();
        int i = 0;
        while (i < size) {
            int billNums = 0;
            BillSubjectDto curBillSubject = billSList.get(i);
            curBillSubject.setIsOil(isOil);
            String curBillNo = curBillSubject.getBillNO();
            if (!curBillSubject.getCheckPassed().booleanValue()) {
                ++failNums;
                ++i;
                continue;
            }
            int curInvKind = curBillSubject.getInvKind();
            if (smruleConfigDto.isMcc()) {
                int lastLineIndex = this.findLastSameClassIndex(billSList, i);
                int j = i;
                while (j <= lastLineIndex) {
                    BillSubjectDto jdto = billSList.get(j);
                    billDList.addAll(jdto.getBillDList());
                    ++j;
                    if (!smruleConfigDto.isMccNote()) continue;
                    String curNotes = jdto.getNotes();
                    mccNote = String.valueOf(mccNote) + (StringUtils.isEmpty((CharSequence)curNotes) ? "" : String.valueOf(curNotes) + smruleConfigDto.getMccNoteStr());
                }
                billNums = lastLineIndex - i + 1;
                i = lastLineIndex + 1;
            } else {
                billNums = 1;
                ++i;
            }
            BigDecimal invLimitAmt = this.getInvLimitAmt(curInvKind, requestDto);
            smruleConfigDto.setInvLimitAmt(invLimitAmt);
            if (StringUtils.isNotEmpty((CharSequence)mccNote)) {
                curBillSubject.setNotes(mccNote.substring(0, mccNote.length() - 1));
            }
            BillSubjectDto newBillSubjectDto = this.buildBillSubject(curBillSubject, billDList);
            ArrayList<BillSubjectDto> billSubjectDtos = new ArrayList<BillSubjectDto>(10);
            billSubjectDtos.add(newBillSubjectDto);
            try {
                try {
                    for (BillSubjectDto subjectDto : billSubjectDtos) {
                        this.tranferRule(subjectDto, smruleConfigDto, resultDto);
                    }
                }
                catch (Exception e) {
                    logger.error("\u62c6\u5408\u5f02\u5e38", (Throwable)e);
                    failNums += billNums;
                    BillDealResultDto dealResultDto = MultiMergeCoreService.getBDR(curBillNo, false, e.getMessage());
                    resultDto.getBdrList().add(dealResultDto);
                    billDList.clear();
                    continue;
                }
            }
            catch (Throwable throwable) {
                billDList.clear();
                throw throwable;
            }
            billDList.clear();
        }
        return failNums;
    }

    public List<BillSubjectDto> splitBillSubject(BillSubjectDto billSubjectDto) throws IllegalAccessException, InvocationTargetException {
        ArrayList<BillSubjectDto> retList = new ArrayList<BillSubjectDto>(10);
        HashMap map = new HashMap(10);
        List<BillDetailDto> billDetailDtos = billSubjectDto.getBillDList();
        for (BillDetailDto billDetailDto : billDetailDtos) {
            BigDecimal taxRate = billDetailDto.getTaxRate();
            String taxRateStr = taxRate.toPlainString();
            if (map.containsKey(taxRateStr)) {
                List detailDtos = (List)map.get(taxRateStr);
                detailDtos.add(billDetailDto);
                continue;
            }
            ArrayList<BillDetailDto> dtos = new ArrayList<BillDetailDto>(10);
            dtos.add(billDetailDto);
            map.put(taxRateStr, dtos);
        }
        for (Map.Entry entry : map.entrySet()) {
            List mapValue = (List)entry.getValue();
            BillSubjectDto newBillSubjectDto = new BillSubjectDto();
            BeanUtils.copyProperties((Object)newBillSubjectDto, (Object)billSubjectDto);
            newBillSubjectDto.setBillDList(mapValue);
            retList.add(newBillSubjectDto);
        }
        return retList;
    }

    private int findLastSameClassIndex(List<BillSubjectDto> billSList, int curIndex) {
        int size = billSList.size();
        BillSubjectDto curDto = billSList.get(curIndex);
        String custName = curDto.getCustName();
        Integer includeTax = curDto.getIncludeTax();
        int invKind = curDto.getInvKind();
        if (StringUtils.isEmpty((CharSequence)custName)) {
            return curIndex;
        }
        for (int i = curIndex; i < size; ++i) {
            int j = i + 1;
            if (j < size) {
                BillSubjectDto item = billSList.get(j);
                String itemCustName = item.getCustName();
                Integer itemInvKind = item.getInvKind();
                Integer itemIncludeTax = item.getIncludeTax();
                if (StringUtils.isNotEmpty((CharSequence)itemCustName) && itemCustName.equals(custName) && itemInvKind == invKind && itemIncludeTax.intValue() == includeTax.intValue()) {
                    continue;
                }
                return i;
            }
            return i;
        }
        return -1;
    }

    private BillSubjectDto buildBillSubject(BillSubjectDto preBillSubjectDto, List<BillDetailDto> billDList) throws IllegalAccessException, InvocationTargetException {
        BillSubjectDto subjectDto = new BillSubjectDto();
        BeanUtils.copyProperties((Object)subjectDto, (Object)preBillSubjectDto);
        ArrayList<BillDetailDto> newBillDList = new ArrayList<BillDetailDto>();
        for (BillDetailDto billDetail : billDList) {
            BillDetailDto newBillDetail = new BillDetailDto();
            BeanUtils.copyProperties((Object)newBillDetail, (Object)billDetail);
            newBillDList.add(newBillDetail);
        }
        if (CollectionUtils.isNotEmpty(newBillDList)) {
            subjectDto.setBillDList(newBillDList);
        }
        return subjectDto;
    }

    private void tranferRule(BillSubjectDto subjectDto, SmruleConfigDto smruleConfigDto, SmsResultDto resultDto) throws EtcRuleException {
        BillsCheckService.billsCheck(subjectDto, smruleConfigDto);
        invoiceMethods.getMaxLine(subjectDto, smruleConfigDto);
        List<BillDetailDto> billDetailDtos = GoodsDiscountService.doDisLine(subjectDto.getBillDList());
        subjectDto.setBillDList(billDetailDtos);
        GoodsMergeService.mergeGoods(subjectDto, smruleConfigDto);
        NegativeRowService.deal(subjectDto, smruleConfigDto);
        invoiceMethods.invoiceLimit(subjectDto, smruleConfigDto, resultDto);
        invoiceMethods.genInvoice(subjectDto, smruleConfigDto, resultDto);
        invoiceMethods.taxAmtCheck(subjectDto, smruleConfigDto, resultDto);
    }

    private void checkSms(SmsRequestDto requestDto) throws SmserException {
        if (requestDto == null) {
            throw new SmserException("\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (requestDto.getBillSList() == null || requestDto.getBillSList().size() == 0) {
            throw new SmserException("\u672a\u4f20\u5165\u9700\u5904\u7406\u5355\u636e");
        }
    }

    private BigDecimal getInvLimitAmt(int preInvKind, SmsRequestDto requestDto) {
        BigDecimal invLimitAmt = null;
        invLimitAmt = EnumType.InvKindEnum.SPECIAL.getValue() == preInvKind ? requestDto.getSiAmt() : (EnumType.InvKindEnum.NORMAL.getValue() == preInvKind ? requestDto.getCiAmt() : (EnumType.InvKindEnum.ROLL.getValue() == preInvKind ? requestDto.getVlAmt() : (EnumType.InvKindEnum.ESINV.getValue() == preInvKind ? requestDto.getEsiAmt() : requestDto.getEiAmt())));
        return invLimitAmt;
    }

    private BigDecimal getInvDiskLimitAmt(int curInvKind, SmsRequestDto requestDto) {
        BigDecimal invDiskLimitAmt = null;
        invDiskLimitAmt = EnumType.InvKindEnum.SPECIAL.getValue() == curInvKind ? requestDto.getDiskSiAmt() : (EnumType.InvKindEnum.NORMAL.getValue() == curInvKind ? requestDto.getDiskCiAmt() : (EnumType.InvKindEnum.ROLL.getValue() == curInvKind ? requestDto.getDiskVlAmt() : (EnumType.InvKindEnum.ESINV.getValue() == curInvKind ? requestDto.getDiskEsiAmt() : requestDto.getDiskEiAmt())));
        return invDiskLimitAmt;
    }
}

