/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.dto;

import com.szhtxx.etcloud.smser.constant.SmserConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailIdDto;
import com.szhtxx.etcloud.smser.utils.CalTaxUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;

public class BillDetailDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String billNO;
    private String billDetailNO;
    private String goodsName;
    private BigDecimal taxRate;
    private String goodsTaxNo;
    private Integer lineProperty = 0;
    private Integer disRows;
    private Integer includeTax;
    private String goodsNoVer;
    private BigDecimal amts;
    private BigDecimal originalAmts;
    private BigDecimal price;
    private BigDecimal amounts;
    private BigDecimal taxDeduction;
    private BigDecimal disAmt;
    private BigDecimal taxAmt;
    private BigDecimal disRate;
    private BigDecimal amountsIncTax;
    private BigDecimal priceIncTax;
    private String goodsModel;
    private String goodsCode;
    private String goodsClass;
    private String goodsUnit;
    private BigDecimal disAmtIncTax;
    private Integer taxPre = 0;
    private String taxPreCon;
    private BigDecimal disTaxAmt;
    private String zeroTax;
    private String cropGoodsNo;
    private String lineNote;
    private int splitSign;
    private String by1;
    private Set<BillDetailIdDto> detailIdSet;

    public BigDecimal getAmountsByTax() {
        if (SmserConstant.ONE.equals(this.includeTax)) {
            return this.getAmountsIncTax();
        }
        return this.getAmounts();
    }

    public String getBillNO() {
        return this.billNO;
    }

    public void setBillNO(String billNO) {
        this.billNO = billNO;
    }

    public String getBillDetailNO() {
        return this.billDetailNO;
    }

    public void setBillDetailNO(String billDetailNO) {
        this.billDetailNO = billDetailNO;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getGoodsTaxNo() {
        return this.goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public Integer getLineProperty() {
        return this.lineProperty;
    }

    public void setLineProperty(Integer lineProperty) {
        this.lineProperty = lineProperty;
    }

    public Integer getDisRows() {
        return this.disRows;
    }

    public void setDisRows(Integer disRows) {
        this.disRows = disRows;
    }

    public Integer getIncludeTax() {
        return this.includeTax;
    }

    public void setIncludeTax(Integer includeTax) {
        this.includeTax = includeTax;
    }

    public String getGoodsNoVer() {
        return this.goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    public BigDecimal getAmts() {
        return this.amts;
    }

    public void setAmts(BigDecimal amts) {
        this.amts = amts;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmounts() {
        return this.amounts;
    }

    public void setAmounts(BigDecimal amounts) {
        this.amounts = amounts;
    }

    public BigDecimal getTaxDeduction() {
        return this.taxDeduction;
    }

    public void setTaxDeduction(BigDecimal taxDeduction) {
        this.taxDeduction = taxDeduction;
    }

    public BigDecimal getDisAmt() {
        return this.disAmt == null ? BigDecimal.ZERO : this.disAmt;
    }

    public void setDisAmt(BigDecimal disAmt) {
        this.disAmt = disAmt;
    }

    public BigDecimal getTaxAmt() {
        return this.taxAmt;
    }

    public void setTaxAmt(BigDecimal taxAmt) {
        this.taxAmt = taxAmt;
    }

    public BigDecimal getDisRate() {
        return this.disRate;
    }

    public void setDisRate(BigDecimal disRate) {
        this.disRate = disRate;
    }

    public BigDecimal getAmountsIncTax() {
        return this.amountsIncTax;
    }

    public void setAmountsIncTax(BigDecimal amountsIncTax) {
        this.amountsIncTax = amountsIncTax;
    }

    public BigDecimal getPriceIncTax() {
        return this.priceIncTax;
    }

    public void setPriceIncTax(BigDecimal priceIncTax) {
        this.priceIncTax = priceIncTax;
    }

    public String getGoodsModel() {
        return this.goodsModel;
    }

    public void setGoodsModel(String goodsModel) {
        this.goodsModel = goodsModel;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getGoodsClass() {
        return this.goodsClass;
    }

    public void setGoodsClass(String goodsClass) {
        this.goodsClass = goodsClass;
    }

    public String getGoodsUnit() {
        return this.goodsUnit;
    }

    public void setGoodsUnit(String goodsUnit) {
        this.goodsUnit = goodsUnit;
    }

    public BigDecimal getDisAmtIncTax() {
        return this.disAmtIncTax;
    }

    public void setDisAmtIncTax(BigDecimal disAmtIncTax) {
        this.disAmtIncTax = disAmtIncTax;
    }

    public Integer getTaxPre() {
        return this.taxPre;
    }

    public void setTaxPre(Integer taxPre) {
        this.taxPre = taxPre;
    }

    public String getTaxPreCon() {
        return this.taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public BigDecimal getDisTaxAmt() {
        return this.disTaxAmt;
    }

    public void setDisTaxAmt(BigDecimal disTaxAmt) {
        this.disTaxAmt = disTaxAmt;
    }

    public String getZeroTax() {
        return this.zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    public String getCropGoodsNo() {
        return this.cropGoodsNo;
    }

    public void setCropGoodsNo(String cropGoodsNo) {
        this.cropGoodsNo = cropGoodsNo;
    }

    public String getLineNote() {
        return this.lineNote;
    }

    public void setLineNote(String lineNote) {
        this.lineNote = lineNote;
    }

    public String getBy1() {
        return this.by1;
    }

    public void setBy1(String by1) {
        this.by1 = by1;
    }

    public int getSplitSign() {
        return this.splitSign;
    }

    public BigDecimal getOriginalAmts() {
        return this.originalAmts;
    }

    public void setOriginalAmts(BigDecimal originalAmts) {
        this.originalAmts = originalAmts;
    }

    public void setSplitSign(int splitSign) {
        this.splitSign = splitSign;
    }

    public Set<BillDetailIdDto> getDetailIdSet() {
        if (this.detailIdSet == null) {
            this.detailIdSet = new LinkedHashSet<BillDetailIdDto>();
            if (this.billNO != null) {
                BillDetailIdDto detail = new BillDetailIdDto(this.billNO, this.getBillDetailNO(), this.amounts, this.price, this.amts);
                this.detailIdSet.add(detail);
            }
        }
        return this.detailIdSet;
    }

    public void setDetailIdSet(Set<BillDetailIdDto> detailIdSet) {
        this.detailIdSet = detailIdSet;
    }

    public void addDetailId(Set<BillDetailIdDto> addDetailId) {
        this.detailIdSet = this.getDetailIdSet();
        if (addDetailId != null) {
            this.detailIdSet.addAll(addDetailId);
        }
    }

    public BigDecimal queryLineTaxError() {
        return this.taxAmt.subtract(CalTaxUtils.calTax(this.includeTax, this.getAmountsByTax(), this.taxRate, 4));
    }

    public void setOtherMoney() {
        if (1 == this.includeTax) {
            this.amounts = this.amountsIncTax.subtract(this.taxAmt);
        } else {
            this.amountsIncTax = this.amounts.add(this.taxAmt);
        }
    }

    public BigDecimal getPriceByTaxFlag() {
        if (SmserConstant.ONE.equals(this.includeTax)) {
            return this.getPriceIncTax();
        }
        return this.getPrice();
    }

    public String toString() {
        return "BillDetailDto{billNO='" + this.billNO + '\'' + ", billDetailNO='" + this.billDetailNO + '\'' + ", goodsName='" + this.goodsName + '\'' + ", taxRate=" + this.taxRate + ", goodsTaxNo='" + this.goodsTaxNo + '\'' + ", lineProperty=" + this.lineProperty + ", disRows=" + this.disRows + ", includeTax=" + this.includeTax + ", goodsNoVer='" + this.goodsNoVer + '\'' + ", amts=" + this.amts + ", price=" + this.price + ", amounts=" + this.amounts + ", taxDeduction=" + this.taxDeduction + ", disAmt=" + this.disAmt + ", taxAmt=" + this.taxAmt + ", disRate=" + this.disRate + ", amountsIncTax=" + this.amountsIncTax + ", priceIncTax=" + this.priceIncTax + ", goodsModel='" + this.goodsModel + '\'' + ", goodsCode='" + this.goodsCode + '\'' + ", goodsClass=" + this.goodsClass + ", goodsUnit='" + this.goodsUnit + '\'' + ", disAmtIncTax=" + this.disAmtIncTax + ", taxPre=" + this.taxPre + ", taxPreCon=" + this.taxPreCon + ", disTaxAmt=" + this.disTaxAmt + ", zeroTax=" + this.zeroTax + ", cropGoodsNo='" + this.cropGoodsNo + '\'' + ", lineNote='" + this.lineNote + '\'' + ", by1='" + this.by1 + '\'' + ", splitSign='" + this.splitSign + '\'' + ", detailIdSet=" + this.detailIdSet + '}';
    }
}

