/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.methods.smser;

import com.szhtxx.etcloud.smser.constant.SmruleConfConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.utils.ComUtil;
import java.math.BigDecimal;
import java.util.List;

public class BackCalcUtilMethods {
    public void preLineErrExceedException(List<BillDetailDto> billDList, BigDecimal err, BigDecimal limit, BillDetailDto detailDto, String errorMsg) {
        int j = ComUtil.findObjIndexInList(billDList, detailDto);
        if (err.abs().compareTo(limit) == 1) {
            String billNo = detailDto.getBillNO();
            String billDetailNO = detailDto.getBillDetailNO();
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u8bef\u5dee[%s] \u9650\u989d[%s] %s", billNo, j, billDetailNO, err, limit, errorMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void preLineDisExceedException(List<BillDetailDto> billDList, BigDecimal disTaxAmt, BigDecimal taxAmt, BillDetailDto detailDto) {
        int j = ComUtil.findObjIndexInList(billDList, detailDto);
        if (disTaxAmt == null) {
            disTaxAmt = BigDecimal.ZERO;
        }
        if (taxAmt == null) {
            taxAmt = BigDecimal.ZERO;
        }
        if (disTaxAmt.abs().compareTo(taxAmt) == 1) {
            String billNo = detailDto.getBillNO();
            String billDetailNO = detailDto.getBillDetailNO();
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u7a0e\u989d[%s]\u5927\u4e8e\u7a0e\u989d[%s]", billNo, j, billDetailNO, disTaxAmt, taxAmt);
            throw new EtcRuleException(msg);
        }
    }

    public BigDecimal recursionAmts(BigDecimal amounts, BigDecimal price, int digit, SmruleConfigDto smruleConfigDto) {
        BigDecimal lineAmountErr = smruleConfigDto.getLineAmountErr();
        int maxDigitLimit = smruleConfigDto.getAmtNumber();
        if (digit < maxDigitLimit) {
            digit = maxDigitLimit;
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal amts = amounts.divide(price, digit, 4);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        if (calcProLineErr.compareTo(lineAmountErr) > 0) {
            return this.recursionAmts(amounts, price, digit + 1, smruleConfigDto);
        }
        return amts;
    }

    public BigDecimal recursionAmtsCut(BigDecimal amounts, BigDecimal price, int digit, SmruleConfigDto smruleConfigDto) {
        BigDecimal lineAmountErr = smruleConfigDto.getLineAmountErr();
        int maxDigitLimit = smruleConfigDto.getAmtNumber();
        if (digit < maxDigitLimit) {
            digit = maxDigitLimit;
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal amts = amounts.divide(price, digit, 3);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        if (calcProLineErr.compareTo(lineAmountErr) > 0) {
            return this.recursionAmtsCut(amounts, price, digit + 1, smruleConfigDto);
        }
        return amts;
    }

    public BigDecimal recursionAmounts(BigDecimal amts, BigDecimal price, int digit, SmruleConfigDto smruleConfigDto) {
        BigDecimal lineAmountErr = smruleConfigDto.getLineAmountErr();
        BigDecimal amounts = amts.multiply(price).setScale(digit, 4);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        if (calcProLineErr.compareTo(lineAmountErr) > 0) {
            return this.recursionAmounts(amts, price, digit + 1, smruleConfigDto);
        }
        return amounts;
    }

    public BigDecimal recursionPrice(BigDecimal amounts, BigDecimal amts, int digit, SmruleConfigDto smruleConfigDto) {
        BigDecimal lineAmountErr = smruleConfigDto.getLineAmountErr();
        int maxLimit = smruleConfigDto.getPriceNumber();
        if (digit < maxLimit) {
            digit = maxLimit;
        }
        if (amts.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = amounts.divide(amts, digit, 4);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        if (calcProLineErr.compareTo(lineAmountErr) > 0) {
            return this.recursionPrice(amounts, amts, digit + 1, smruleConfigDto);
        }
        return price;
    }

    public BigDecimal calcTaxAmt(BigDecimal amounts, BigDecimal taxRate, int digit) {
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd105 = new BigDecimal("1.05");
            return amounts.multiply(SmruleConfConstant.TAXRATE_15).divide(bd105, 2, 4);
        }
        BigDecimal one = new BigDecimal("1");
        BigDecimal taxAmt = amounts.multiply(taxRate).divide(one.add(taxRate), digit, 4);
        return taxAmt;
    }

    public BigDecimal calcNoTaxMoney(BigDecimal amounts, BigDecimal taxRate, int digit) {
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd105 = new BigDecimal("1.05");
            BigDecimal taxAmt = amounts.multiply(SmruleConfConstant.TAXRATE_15).divide(bd105, 2, 4);
            return amounts.subtract(taxAmt);
        }
        BigDecimal one = new BigDecimal("1");
        BigDecimal taxAmt = amounts.multiply(taxRate).divide(one.add(taxRate), digit, 4);
        return amounts.subtract(taxAmt);
    }

    public BigDecimal calcTaxAmtByNoTaxMoney(BigDecimal amounts, BigDecimal taxRate, int digit) {
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd1035 = new BigDecimal("1.035");
            return amounts.multiply(SmruleConfConstant.TAXRATE_15).divide(bd1035, 2, 4);
        }
        BigDecimal taxAmt = amounts.multiply(taxRate).setScale(digit, 4);
        return taxAmt;
    }

    public BigDecimal calcTaxAmtByTaxMoneyDec(BigDecimal amounts, BigDecimal dec, BigDecimal taxRate, int digit) {
        if (dec == null) {
            dec = BigDecimal.ZERO;
        }
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd105 = new BigDecimal("1.05");
            return amounts.subtract(dec).multiply(SmruleConfConstant.TAXRATE_15).divide(bd105, digit, 4);
        }
        BigDecimal tmpRate = BigDecimal.ONE.add(taxRate);
        BigDecimal taxAmt = amounts.subtract(dec).multiply(taxRate).divide(tmpRate, digit, 4);
        return taxAmt;
    }

    public BigDecimal calcAmtByTaxMoneyDec(BigDecimal amounts, BigDecimal dec, BigDecimal taxRate, int digit) {
        if (dec == null) {
            dec = BigDecimal.ZERO;
        }
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd105 = new BigDecimal("1.05");
            BigDecimal taxAmt = amounts.subtract(dec).multiply(SmruleConfConstant.TAXRATE_15).divide(bd105, 2, 4);
            return amounts.subtract(taxAmt);
        }
        BigDecimal tmpRate = BigDecimal.ONE.add(taxRate);
        BigDecimal taxAmt = amounts.subtract(dec).multiply(taxRate).divide(tmpRate, 2, 4);
        return amounts.subtract(taxAmt);
    }

    public BigDecimal calcTaxAmtByNoTaxMoneyDec(BigDecimal amounts, BigDecimal dec, BigDecimal taxRate, int digit) {
        if (dec == null) {
            dec = BigDecimal.ZERO;
        }
        if (SmruleConfConstant.TAXRATE_15.compareTo(taxRate) == 0) {
            BigDecimal bd1035 = new BigDecimal("1.035");
            return amounts.multiply(SmruleConfConstant.TAXRATE_15).divide(bd1035, 2, 4);
        }
        BigDecimal taxAmt = amounts.subtract(dec).multiply(taxRate).setScale(digit, 4);
        return taxAmt;
    }

    public BigDecimal calcDisTaxAmtByTaxMoney(BigDecimal disAmt, BigDecimal taxRate, int digit) {
        return disAmt.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), digit, 4);
    }

    public BigDecimal calcDisTaxAmtByNoTaxMoney(BigDecimal disAmt, BigDecimal taxRate, int digit) {
        return disAmt.multiply(taxRate).setScale(digit, 4);
    }

    public Integer exSingleAmtErr(BigDecimal price, BigDecimal amts, BigDecimal amounts, SmruleConfigDto configDto) {
        BigDecimal tmpAmounts = price.multiply(amts);
        BigDecimal lineAmtErr = configDto.getLineAmountErr();
        if (amounts.subtract(tmpAmounts).abs().compareTo(lineAmtErr) > 0) {
            return 1;
        }
        return 0;
    }

    public void keepDecimalPlace(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        List<BillDetailDto> billDetailDtos = billSubjectDto.getBillDList();
        for (BillDetailDto detailDto : billDetailDtos) {
            int priceNumberType = configDto.getPriceNumberType();
            int defaultValue = SmruleConfConstant.ONE;
            if (EnumType.NumberTypeEnum.ONE.getValue() == priceNumberType) {
                defaultValue = 0;
            } else if (EnumType.NumberTypeEnum.TWO.getValue() == priceNumberType) {
                defaultValue = configDto.getPriceNumber();
            }
            BigDecimal price = detailDto.getPrice().setScale(defaultValue, 4);
            BigDecimal priceInc = detailDto.getPriceIncTax().setScale(defaultValue, 4);
            detailDto.setPrice(price);
            detailDto.setPriceIncTax(priceInc);
            int amtNumberType = configDto.getAmtNumberType();
            if (EnumType.NumberTypeEnum.ONE.getValue() == amtNumberType) {
                defaultValue = 0;
            } else if (EnumType.NumberTypeEnum.TWO.getValue() == amtNumberType) {
                defaultValue = configDto.getPriceNumber();
            }
            BigDecimal amts = detailDto.getAmts().setScale(defaultValue, 4);
            detailDto.setAmts(amts);
        }
    }
}

