/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.methods.smser.billcheck;

import com.szhtxx.etcloud.smser.constant.SmruleConfConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.methods.smser.BackCalcUtilMethods;
import com.szhtxx.etcloud.smser.utils.ComUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillCheckMethods {
    private static BackCalcUtilMethods calcUtilMethods = new BackCalcUtilMethods();

    public void checkNull(String fieldValue, BillDetailDto detailDto, int index, String errorMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (fieldValue != null && fieldValue.trim().length() == 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, errorMsg);
            throw new EtcRuleException(msg);
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, errorMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void checkMoneyFiled(BigDecimal money, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (money == null) {
            throw new EtcRuleException("\u91d1\u989d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (money.compareTo(zeroBg) < 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u5355\u4ef7[%s] %s", billNo, index, billDetailNO, detailDto.getPrice(), errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void specilNo0TaxRate(BigDecimal taxRate, Integer invKind, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (taxRate == null) {
            throw new EtcRuleException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invKind == null) {
            throw new EtcRuleException("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (taxRate.compareTo(zeroBg) == 0 && invKind.compareTo(EnumType.InvKindEnum.SPECIAL.getValue()) == 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u7a0e\u7387[%s] %s", billNo, index, billDetailNO, taxRate, errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void verfTaxRateNew(BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (taxRate.compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) > 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u7a0e\u7387[%s] %s", billNo, index, billDetailNO, taxRate, errMsg);
            throw new EtcRuleException(msg);
        }
        int place = taxRate.scale();
        if (place > 3) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u7a0e\u7387[%s] %s", billNo, index, billDetailNO, taxRate, errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void taxRate15NotMultiTax(List<BillDetailDto> billDList, BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (CollectionUtils.isEmpty(billDList)) {
            throw new EtcRuleException("\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<BigDecimal> set = new HashSet<BigDecimal>(10);
        for (BillDetailDto dto : billDList) {
            set.add(dto.getTaxRate());
        }
        if (set.size() > 1 && taxRate.compareTo(new BigDecimal("0.015")) == 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void decNottaxRate15(BigDecimal dec, BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (dec != null && dec.compareTo(zeroBg) != 0 && taxRate.compareTo(new BigDecimal("0.015")) == 0) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void disLineMoneyNotGt0(BigDecimal amounts, Integer lineProperty, BillDetailDto detailDto, int index, String errMsg) {
        if (ComUtil.isDisLine(detailDto).booleanValue()) {
            String billNo = detailDto.getBillNO();
            String billDetailNO = detailDto.getBillDetailNO();
            BigDecimal zeroBg = BigDecimal.ZERO;
            if (lineProperty.compareTo(detailDto.getLineProperty()) == 0 && amounts.compareTo(zeroBg) == 1) {
                String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, errMsg);
                throw new EtcRuleException(msg);
            }
        }
    }

    public void checkDisRows(BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && disRows < -1) {
            String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u884c\u6570[%s] %s", billNo, index, billDetailNO, disRows, errMsg);
            throw new EtcRuleException(msg);
        }
    }

    public void discount1LineNotExist(List<BillDetailDto> billDList, BillDetailDto detailDto, int index) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && (disRows == 0 || disRows == 1)) {
            int j = ComUtil.findObjIndexInList(billDList, detailDto);
            if (j - 1 >= 0) {
                BigDecimal disMoney;
                BillDetailDto lastBillDeailDto = billDList.get(j - 1);
                if (lastBillDeailDto.getAmounts().compareTo(zeroBg) == -1) {
                    String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u88ab\u6298\u6263\u884c\u91d1\u989d\u975e\u6b63\u6570\u884c");
                    throw new EtcRuleException(msg);
                }
                BigDecimal amounts = SmruleConfConstant.ONE.equals(lastBillDeailDto.getIncludeTax()) ? lastBillDeailDto.getAmountsIncTax() : lastBillDeailDto.getAmounts();
                if (amounts.compareTo((disMoney = detailDto.getAmounts()).abs()) == -1) {
                    String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u884c\u91d1\u989d[%s]\u5927\u4e8e\u88ab\u6298\u91d1\u989d[%s]", billNo, index, billDetailNO, disMoney, amounts);
                    throw new EtcRuleException(msg);
                }
            } else {
                String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u88ab\u6298\u6263\u884c\u4e0d\u5b58\u5728");
                throw new EtcRuleException(msg);
            }
        }
    }

    public void discountNLineNotExist(List<BillDetailDto> billDList, BillDetailDto detailDto, int index) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && disRows > 1) {
            int j = ComUtil.findObjIndexInList(billDList, detailDto);
            int positiveLine = 0;
            BigDecimal disMoney = detailDto.getAmounts();
            BigDecimal sumMoney = BigDecimal.ZERO;
            int i = j - 1;
            while (i >= 0) {
                BigDecimal amounts;
                BillDetailDto billDetailDto = billDList.get(i);
                BigDecimal bigDecimal = amounts = SmruleConfConstant.ONE.equals(billDetailDto.getIncludeTax()) ? billDetailDto.getAmountsIncTax() : billDetailDto.getAmounts();
                if (billDetailDto.getAmounts().compareTo(zeroBg) == 1) {
                    ++positiveLine;
                    sumMoney = sumMoney.add(amounts);
                }
                if (positiveLine == disRows) break;
                --i;
            }
            if (positiveLine < disRows) {
                String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u6298\u6263\u884c\u627e\u4e0d\u5230\u8db3\u591f\u7684\u6298\u6263\u884c\u6570");
                throw new EtcRuleException(msg);
            }
            if (sumMoney.compareTo(disMoney.abs()) == -1) {
                String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u884c\u91d1\u989d[%s]\u5927\u4e8e\u88ab\u6298\u91d1\u989d[%s]", billNo, index, billDetailNO, disMoney, sumMoney);
                throw new EtcRuleException(msg);
            }
        }
    }

    public void checkNDline(BillDetailDto detailDto, SmruleConfigDto configDto, int index) {
        BigDecimal zeroBd = BigDecimal.ZERO;
        BigDecimal amounts = detailDto.getAmounts();
        BigDecimal amts = detailDto.getAmts();
        BigDecimal price = detailDto.getPrice();
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) != 0) {
            String msg;
            BigDecimal temAmouts;
            BigDecimal err;
            if (amounts.compareTo(zeroBd) == 0 && amts.compareTo(zeroBd) == 0 && price.compareTo(zeroBd) == 0) {
                String msg2 = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u666e\u901a\u5546\u54c1\u884c\u6216\u88ab\u6298\u6263\u884c\uff0c\u6570\u91cf\u3001\u5355\u4ef7\u3001\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a0");
                throw new EtcRuleException(msg2);
            }
            if (amounts != null && amounts.compareTo(zeroBd) == 0 && amts != null && amts.compareTo(zeroBd) == 0 && price != null && price.compareTo(zeroBd) > 0) {
                String msg3 = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u91d1\u989d\uff0c\u6570\u91cf\u672a\u4f20\u5165");
                throw new EtcRuleException(msg3);
            }
            if (amounts != null && amounts.compareTo(zeroBd) == 0 && amts != null && amts.compareTo(zeroBd) > 0 && price != null && price.compareTo(zeroBd) == 0) {
                String msg4 = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s %s", billNo, index, billDetailNO, "\u91d1\u989d\uff0c\u5355\u4ef7\u672a\u4f20\u5165");
                throw new EtcRuleException(msg4);
            }
            if (amounts != null && amounts.compareTo(zeroBd) > 0 && amts != null && amts.compareTo(zeroBd) > 0 && price != null && price.compareTo(zeroBd) > 0 && (err = (temAmouts = amts.multiply(price)).subtract(amounts).abs()).compareTo(configDto.getLineAmountErr()) == 1) {
                String msg5 = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6570\u91cf(%s)*\u5355\u4ef7(%s)\u4e0d\u7b49\u4e8e\u91d1\u989d(%s)", billNo, index, billDetailNO, amts, price, amounts);
                throw new EtcRuleException(msg5);
            }
            BigDecimal disMoney = detailDto.getDisAmt();
            if (disMoney != null && amounts.compareTo(zeroBd) == -1 && disMoney.compareTo(zeroBd) == -1) {
                msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u8d1f\u6570\u884c\u4e0d\u5141\u8bb8\u6709\u6298\u6263", billNo, index, billDetailNO);
                throw new EtcRuleException(msg);
            }
            if (disMoney != null && disMoney.abs().compareTo(amounts) == 1 && disMoney.compareTo(zeroBd) == -1) {
                msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u91d1\u989d\u5927\u4e8e\u91d1\u989d", billNo, index, billDetailNO);
                throw new EtcRuleException(msg);
            }
        }
    }

    public void checkTaxDecline(List<BillDetailDto> billDList, BillDetailDto detailDto, int index) {
        BigDecimal zeroBd = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        BigDecimal amounts = detailDto.getAmounts();
        String billDetailNO = detailDto.getBillDetailNO();
        BigDecimal taxDc = detailDto.getTaxDeduction();
        if (taxDc != null && taxDc.compareTo(zeroBd) != 0) {
            if (billDList.size() >= 2 && billDList.get(1).getTaxDeduction().compareTo(zeroBd) != 0) {
                String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u5dee\u989d\u53d1\u7968\u6e05\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7\u4e24\u884c,\u4e24\u884c\u65f6\u5fc5\u987b\u6709\u4e00\u884c\u4e3a\u6298\u6263\u884c", billNo, index, billDetailNO);
                throw new EtcRuleException(msg);
            }
            if (billDList.size() == 2) {
                BillDetailDto billDetailDis = billDList.get(index);
                if (billDetailDis.getLineProperty() == 4 && (billDetailDis.getDisRows() == 0 || billDetailDis.getDisRows() == 1)) {
                    if (billDetailDis.getAmounts().abs().compareTo(amounts) == 1) {
                        String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u6298\u6263\u91d1\u989d\u5927\u4e8e\u5546\u54c1\u91d1\u989d", billNo, index, billDetailNO);
                        throw new EtcRuleException(msg);
                    }
                } else {
                    String msg = String.format("\u5355\u636e\u53f7\uff1a%s \u7b2c%s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%s \u5dee\u989d\u53d1\u7968\u6e05\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7\u4e24\u884c,\u4e24\u884c\u65f6\u5fc5\u987b\u6709\u4e00\u884c\u4e3a\u6298\u6263\u884c", billNo, index, billDetailNO);
                    throw new EtcRuleException(msg);
                }
            }
        }
    }

    public void checkProLineDetail(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        BigDecimal lineAmtErr = configDto.getLineAmountErr();
        BigDecimal lineTaxAmtErr = configDto.getLineTaxAmtErr();
        for (BillDetailDto detailDto : detailDtos) {
            BigDecimal taxErr;
            BigDecimal amounts = detailDto.getAmounts();
            BigDecimal dec = detailDto.getTaxDeduction();
            BigDecimal amountsInc = detailDto.getAmountsIncTax();
            BigDecimal taxAmt = detailDto.getTaxAmt();
            BigDecimal amts = detailDto.getAmts();
            BigDecimal price = detailDto.getPrice();
            BigDecimal taxRate = detailDto.getTaxRate();
            BigDecimal priceInc = detailDto.getPriceIncTax();
            String billNo = detailDto.getBillNO();
            String detailNo = detailDto.getBillDetailNO();
            if (dec == null) {
                dec = BigDecimal.ZERO;
            }
            if ((taxErr = amounts.subtract(dec).multiply(taxRate).subtract(taxAmt).abs().setScale(2, 4)).compareTo(lineTaxAmtErr) > 0) {
                String msg = String.format("\u5355\u636e\u7f16\u53f7[%s] \u660e\u7ec6\u7f16\u53f7[%s] \u4e0d\u542b\u7a0e\u91d1\u989d[%s]*\u7a0e\u7387[%s]\u7a0e\u989d[%s]\u8d85\u9650[%s]", billNo, detailNo, amounts, taxRate, taxAmt, lineTaxAmtErr);
                throw new EtcRuleException(msg);
            }
            if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal incAmtErr = amts.multiply(priceInc).subtract(amountsInc).abs().setScale(2, 4);
            if (incAmtErr.compareTo(lineAmtErr) > 0) {
                String msg = String.format("\u5355\u636e\u7f16\u53f7[%s] \u660e\u7ec6\u7f16\u53f7[%s] \u542b\u7a0e\u5355\u4ef7[%s]*\u6570\u91cf[%s]\u91d1\u989d[%s]\u8d85\u9650[%s]", billNo, detailNo, priceInc, amts, amountsInc, lineAmtErr);
                throw new EtcRuleException(msg);
            }
            BigDecimal amtErr = amts.multiply(price).subtract(amounts).abs().setScale(2, 4);
            if (amtErr.compareTo(lineAmtErr) > 0) {
                String msg = String.format("\u5355\u636e\u7f16\u53f7[%s] \u660e\u7ec6\u7f16\u53f7[%s] \u4e0d\u542b\u7a0e\u5355\u4ef7[%s]*\u6570\u91cf[%s]\u91d1\u989d[%s]\u8d85\u9650[%s]", billNo, detailNo, price, amts, amounts, lineAmtErr);
                throw new EtcRuleException(msg);
            }
            Map<String, Integer> decimalMap = ComUtil.getDigitByRuleConfig(configDto);
            int amtNumber = decimalMap.get("amtNumber");
            BigDecimal invLimitAmt = configDto.getInvLimitAmt();
            BigDecimal calAmts = calcUtilMethods.recursionAmts(invLimitAmt, price, amtNumber, configDto);
            calAmts = calAmts.setScale(amtNumber, 4);
            if (invLimitAmt.compareTo(amounts) >= 0 || amtNumber != 0 || calAmts.compareTo(BigDecimal.ZERO) != 0) continue;
            throw new EtcRuleException("\u4e0d\u80fd\u6ee1\u8db3\u6570\u91cf\u4fdd\u7559\u6574\u6570\u89c4\u5219\u62c6\u5206\u5355\u5546\u54c1\u884c\uff0c\u8bf7\u8c03\u6574\u89c4\u5219");
        }
    }

    public void checkBillTotal(BillSubjectDto billSubjectDto) {
        List<BillDetailDto> billDList = billSubjectDto.getBillDList();
        BigDecimal billAmountsSum = BigDecimal.ZERO;
        BigDecimal billTaxAmtsSum = BigDecimal.ZERO;
        for (BillDetailDto billDetailDto : billDList) {
            billAmountsSum = billAmountsSum.add(billDetailDto.getAmounts() != null ? billDetailDto.getAmounts() : BigDecimal.ZERO);
            billTaxAmtsSum = billTaxAmtsSum.add(billDetailDto.getTaxAmt() != null ? billDetailDto.getTaxAmt() : BigDecimal.ZERO);
        }
        BigDecimal billAmountsIncTaxSum = billAmountsSum.add(billTaxAmtsSum);
        if (billAmountsSum.compareTo(BigDecimal.ZERO) == 0 || billAmountsIncTaxSum.compareTo(BigDecimal.ZERO) == 0) {
            throw new EtcRuleException("\u9500\u552e\u5355\u603b\u91d1\u989d\u6216\u62c6\u5408\u5904\u7406\u540e\u6709\u53d1\u7968\u7684\u91d1\u989d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6216\u8c03\u6574\u62c6\u5408\u89c4\u5219");
        }
    }
}

