/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.szhtxx.etcloud.smser.constant.SmruleConfConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.methods.smser.BackCalcUtilMethods;
import com.szhtxx.etcloud.smser.methods.smser.billcheck.BillCheckMethods;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillsCheckService {
    static BackCalcUtilMethods backCalcUtilMethods = new BackCalcUtilMethods();
    static BillCheckMethods billCheckMethods = new BillCheckMethods();

    public static void billsCheck(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        List<BillDetailDto> billDetailDtoList = billSubjectDto.getBillDList();
        Integer invKind = billSubjectDto.getInvKind();
        int i = 0;
        while (i < billDetailDtoList.size()) {
            BillDetailDto detailDto = billDetailDtoList.get(i);
            String billNo = detailDto.getBillNO();
            Integer lineProperty = detailDto.getLineProperty();
            String billDetailNO = detailDto.getBillDetailNO();
            BigDecimal taxRate = detailDto.getTaxRate();
            BigDecimal amount = detailDto.getAmounts();
            BigDecimal price = detailDto.getPrice();
            BigDecimal dec = detailDto.getTaxDeduction();
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                throw new EtcRuleException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (price == null || price.compareTo(BigDecimal.ZERO) < 0) {
                throw new EtcRuleException("\u5355\u4ef7\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
            }
            if (taxRate == null) {
                throw new EtcRuleException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (invKind == null) {
                throw new EtcRuleException("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            billCheckMethods.checkNull(billDetailNO, detailDto, i + 1, "\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u672a\u4f20\u5165");
            billCheckMethods.specilNo0TaxRate(taxRate, invKind, detailDto, i + 1, "\u7a0e\u7387\u4e3a0\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968");
            billCheckMethods.verfTaxRateNew(taxRate, detailDto, i + 1, "\u7a0e\u7387\u4e0d\u5408\u6cd5");
            billCheckMethods.taxRate15NotMultiTax(billDetailDtoList, taxRate, detailDto, i + 1, "\u51cf\u514d1.5\u8ba1\u7a0e\u65f6\u4e0d\u5141\u8bb8\u5f00\u5177\u591a\u7a0e\u7387");
            billCheckMethods.decNottaxRate15(dec, taxRate, detailDto, i + 1, "\u5dee\u989d\u53d1\u7968\u4e0d\u80fd\u5f00\u51771.5\u7a0e\u7387");
            billCheckMethods.disLineMoneyNotGt0(amount, lineProperty, detailDto, i + 1, "\u6298\u6263\u884c\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0");
            billCheckMethods.discount1LineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.discountNLineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.checkDisRows(detailDto, i + 1, "\u6298\u6263\u884c\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e-1");
            billCheckMethods.checkNDline(detailDto, configDto, i + 1);
            BillsCheckService.checkPriceNumsAmt(detailDto, configDto);
            ++i;
        }
        billCheckMethods.checkBillTotal(billSubjectDto);
    }

    public static void checkPriceNumsAmt(BillDetailDto detailDto, SmruleConfigDto configDto) {
        BigDecimal amount = detailDto.getAmounts();
        amount = amount == null ? BigDecimal.ZERO : amount;
        BigDecimal price = detailDto.getPrice();
        price = price == null ? BigDecimal.ZERO : price;
        BigDecimal amountInc = detailDto.getAmountsIncTax();
        BigDecimal priceInc = detailDto.getPriceIncTax();
        BigDecimal amts = detailDto.getAmts();
        amts = amts == null ? BigDecimal.ZERO : amts;
        BigDecimal taxAmt = detailDto.getTaxAmt();
        taxAmt = taxAmt == null ? BigDecimal.ZERO : taxAmt;
        BigDecimal dec = detailDto.getTaxDeduction();
        BigDecimal taxRate = detailDto.getTaxRate();
        if (amount.compareTo(BigDecimal.ZERO) == 0 && price.compareTo(BigDecimal.ZERO) > 0 && amts.compareTo(BigDecimal.ZERO) > 0) {
            amount = backCalcUtilMethods.recursionAmounts(amts, price, 2, configDto);
        } else if (price.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) > 0 && amts.compareTo(BigDecimal.ZERO) > 0) {
            price = backCalcUtilMethods.recursionPrice(amount, amts, 2, configDto);
        } else if (amts.compareTo(BigDecimal.ZERO) == 0 && amount.compareTo(BigDecimal.ZERO) > 0 && price.compareTo(BigDecimal.ZERO) > 0) {
            amts = backCalcUtilMethods.recursionAmtsCut(amount, price, 2, configDto);
        }
        Integer isIncludeTax = detailDto.getIncludeTax();
        if (SmruleConfConstant.ONE.equals(isIncludeTax)) {
            amountInc = amount;
            priceInc = price;
            BigDecimal taxAmt15 = taxAmt;
            if (1 == configDto.getTotalTaxamtCount() || taxAmt.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = backCalcUtilMethods.calcTaxAmtByTaxMoneyDec(amountInc, dec, taxRate, 2);
                taxAmt15 = backCalcUtilMethods.calcTaxAmtByTaxMoneyDec(amountInc, dec, taxRate, 15);
            }
            amount = amountInc.subtract(taxAmt15);
            price = backCalcUtilMethods.recursionPrice(amount, amts, 2, configDto);
            amount = amountInc.subtract(taxAmt);
        } else {
            BigDecimal taxAmt15 = taxAmt;
            if (1 == configDto.getTotalTaxamtCount() || taxAmt.compareTo(BigDecimal.ZERO) == 0) {
                taxAmt = backCalcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amount, dec, taxRate, 2);
                taxAmt15 = backCalcUtilMethods.calcTaxAmtByNoTaxMoneyDec(amount, dec, taxRate, 15);
            }
            amountInc = taxAmt15.add(amount);
            priceInc = backCalcUtilMethods.recursionPrice(amountInc, amts, 2, configDto);
            amountInc = taxAmt.add(amount);
        }
        detailDto.setAmounts(amount);
        detailDto.setAmountsIncTax(amountInc);
        detailDto.setPrice(price);
        detailDto.setTaxAmt(taxAmt);
        detailDto.setPriceIncTax(priceInc);
        detailDto.setAmts(amts);
    }

    public static int findObjIndexInList(List<BillDetailDto> billDList, BillDetailDto detailDto) {
        String msg = "";
        String billNoP = detailDto.getBillNO();
        String billDetailNoP = detailDto.getBillDetailNO();
        if (StringUtils.isEmpty((CharSequence)billDetailNoP)) {
            msg = String.format("\u5355\u636e\u7f16\u53f7[%s] \u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", billNoP);
            throw new EtcRuleException(msg);
        }
        if (CollectionUtils.isNotEmpty(billDList)) {
            int i = 0;
            for (BillDetailDto dto : billDList) {
                String billNo = dto.getBillNO();
                String billDetailNo = dto.getBillDetailNO();
                if (billNo.equals(billNoP) && billDetailNo.equals(billDetailNoP)) break;
                ++i;
            }
            return i;
        }
        return -1;
    }
}

