/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.google.common.collect.ArrayListMultimap;
import com.szhtxx.etcloud.smser.constant.SmruleConfConstant;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.methods.smser.BackCalcUtilMethods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsDiscountService
implements SmruleConfConstant {
    private static Logger LOG = LoggerFactory.getLogger(GoodsDiscountService.class);

    private static boolean isDisCountRow(BillDetailDto billDetailDto) {
        return billDetailDto.getLineProperty() != null && billDetailDto.getLineProperty() == 4;
    }

    private static String buildDetailMsg(BillDetailDto billDetailDto, String msg, String ... params) {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("\u5355\u636e\u7f16\u53f7:").append(billDetailDto.getBillNO()).append("\u660e\u7ec6\u884c\u53f7:").append(billDetailDto.getBillDetailNO()).append(msg);
        return String.format(msgBuilder.toString(), params);
    }

    public static List<BillDetailDto> doDisLine(List<BillDetailDto> detailList) throws EtcRuleException {
        ArrayListMultimap disCountMap = ArrayListMultimap.create();
        BigDecimal plusSumAmt = BigDecimal.ZERO;
        BigDecimal billDisSum = BigDecimal.ZERO;
        BigDecimal disAmtSum = BigDecimal.ZERO;
        BillDetailDto allDisDetail = null;
        int i = 0;
        while (i < detailList.size()) {
            BillDetailDto billDetail = detailList.get(i);
            if (GoodsDiscountService.isDisCountRow(billDetail) || billDetail.getAmountsByTax() != null && billDetail.getAmountsByTax().compareTo(BigDecimal.ZERO) >= 0) {
                if (GoodsDiscountService.isDisCountRow(billDetail) && billDetail.getDisRows() == -1) {
                    allDisDetail = billDetail;
                    billDisSum = billDisSum.add(billDetail.getAmountsByTax().abs());
                    disAmtSum = disAmtSum.add(billDetail.getAmountsByTax().abs());
                } else if (GoodsDiscountService.isDisCountRow(billDetail) && billDetail.getDisRows() > -1) {
                    plusSumAmt = plusSumAmt.subtract(billDetail.getAmountsByTax().abs());
                    disAmtSum = disAmtSum.add(billDetail.getAmountsByTax().abs());
                    BigDecimal tmpAmounts = BigDecimal.ZERO;
                    int beforeIndex = i - 1;
                    while (beforeIndex >= 0) {
                        if (beforeIndex >= 0) {
                            BillDetailDto beforeDetail = detailList.get(beforeIndex);
                            if (GoodsDiscountService.isDisCountRow(beforeDetail)) {
                                if (beforeDetail.getDisRows() <= -1) {
                                    // empty if block
                                }
                            } else if (beforeDetail.getAmountsByTax().compareTo(BigDecimal.ZERO) >= 0) {
                                if (billDetail.getDisRows() > 1) {
                                    if (disCountMap.get((Object)billDetail) != null && disCountMap.get((Object)billDetail).size() >= billDetail.getDisRows()) break;
                                    disCountMap.put((Object)billDetail, (Object)beforeDetail);
                                    tmpAmounts = tmpAmounts.add(beforeDetail.getAmountsByTax());
                                } else {
                                    if (beforeDetail.getAmountsByTax().abs().compareTo(billDetail.getAmountsByTax().abs()) >= 0) {
                                        beforeDetail.setDisAmt(beforeDetail.getDisAmt().abs().add(billDetail.getAmountsByTax().abs()));
                                        break;
                                    }
                                    String errmsg = GoodsDiscountService.buildDetailMsg(billDetail, "\u7684\u6298\u6263\u884c\u627e\u4e0d\u5230\u8db3\u591f\u7684\u6298\u6263\u91d1\u989d(%s)", String.valueOf(billDetail.getAmountsByTax()));
                                    throw new EtcRuleException(errmsg);
                                }
                            }
                        }
                        --beforeIndex;
                    }
                } else {
                    if (billDetail.getDisAmt().compareTo(BigDecimal.ZERO) != 0) {
                        disAmtSum = disAmtSum.add(billDetail.getDisAmt().abs());
                    }
                    plusSumAmt = billDetail.getDisAmt().compareTo(BigDecimal.ZERO) > 0 ? plusSumAmt.add(billDetail.getAmountsByTax().subtract(billDetail.getDisAmt())) : plusSumAmt.add(billDetail.getAmountsByTax().add(billDetail.getDisAmt()));
                }
            }
            ++i;
        }
        LOG.debug(String.format("\u6b63\u6570\u91d1\u989d%s\t\u9700\u6298\u6263\u91d1\u989d%s\t\u6574\u5355\u6298\u6263\u91d1\u989d%s", plusSumAmt, disAmtSum, billDisSum));
        if (disAmtSum.compareTo(BigDecimal.ZERO) == 0) {
            LOG.debug("\u6ca1\u6709\u6298\u6263\u5904\u7406");
            return detailList;
        }
        block2: for (BillDetailDto disCountRow : disCountMap.keySet()) {
            List toDisGoodsDetailList = disCountMap.get((Object)disCountRow);
            if (toDisGoodsDetailList.size() == 1) continue;
            if (toDisGoodsDetailList.size() < disCountRow.getDisRows()) {
                String errmsg = GoodsDiscountService.buildDetailMsg(disCountRow, "\u7684\u6298\u6263\u884c\u627e\u4e0d\u5230\u8db3\u591f\u7684\u6298\u6263\u884c\u6570(%s)", String.valueOf(disCountRow.getDisRows()));
                throw new EtcRuleException(errmsg);
            }
            BigDecimal canDisCountAmountSum = BigDecimal.ZERO;
            for (BillDetailDto goodDetail : toDisGoodsDetailList) {
                canDisCountAmountSum = canDisCountAmountSum.add(goodDetail.getAmountsByTax().subtract(goodDetail.getDisAmt().abs()));
            }
            if (canDisCountAmountSum.compareTo(disCountRow.getAmountsByTax().abs()) < 0) {
                String errmsg = GoodsDiscountService.buildDetailMsg(disCountRow, "\u7684\u6298\u6263\u884c\u627e\u4e0d\u5230\u8db3\u591f\u7684\u6298\u6263\u91d1\u989d(%s)", String.valueOf(disCountRow.getAmountsByTax()));
                throw new EtcRuleException(errmsg);
            }
            BigDecimal disCountRate = disCountRow.getAmountsByTax().abs().divide(canDisCountAmountSum.abs(), 5, 4).multiply(new BigDecimal("100")).setScale(3, 4);
            LOG.debug("disRate : " + disCountRate);
            int disRows = 0;
            BigDecimal disAmted = BigDecimal.ZERO;
            for (BillDetailDto goodDetail : toDisGoodsDetailList) {
                BigDecimal canDisCountAmount = goodDetail.getAmountsByTax().subtract(goodDetail.getDisAmt().abs());
                BigDecimal currentRowDisCountAmount = BigDecimal.ZERO;
                currentRowDisCountAmount = canDisCountAmount.multiply(disCountRate).divide(new BigDecimal(100)).setScale(2, 4);
                if (currentRowDisCountAmount.compareTo(goodDetail.getAmountsByTax()) >= 0) {
                    LOG.debug("\u4e0d\u6298\u8fd9\u884c");
                    continue;
                }
                disAmted = disAmted.add(currentRowDisCountAmount);
                ++disRows;
                goodDetail.setDisAmt(goodDetail.getDisAmt().abs().add(currentRowDisCountAmount.abs()));
            }
            BigDecimal adustAmt = disAmted.subtract(disCountRow.getAmountsByTax().abs());
            for (BillDetailDto goodDetail : toDisGoodsDetailList) {
                if (adustAmt.compareTo(BigDecimal.ZERO) > 0) {
                    if (goodDetail.getDisAmt().abs().compareTo(adustAmt) <= 0) continue;
                    goodDetail.setDisAmt(goodDetail.getDisAmt().abs().subtract(adustAmt));
                    continue block2;
                }
                if (goodDetail.getDisAmt().abs().add(adustAmt.abs()).compareTo(goodDetail.getAmountsByTax()) >= 0) continue block2;
                goodDetail.setDisAmt(goodDetail.getDisAmt().abs().add(adustAmt.abs()));
                continue block2;
            }
        }
        GoodsDiscountService.billDiscount(detailList, billDisSum, plusSumAmt);
        return GoodsDiscountService.generateDiscountRow(detailList, 0, allDisDetail);
    }

    private static List<BillDetailDto> billDiscount(List<BillDetailDto> detailList, BigDecimal billDisSum, BigDecimal plusSumAmt) {
        BigDecimal billDisRate = BigDecimal.ZERO;
        if (billDisSum.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal disAmted = new BigDecimal("0");
            billDisRate = billDisSum.divide(plusSumAmt, 5, 4).multiply(new BigDecimal("100")).setScale(3, 4);
            for (BillDetailDto billDetailDto : detailList) {
                if (GoodsDiscountService.isDisCountRow(billDetailDto) || billDetailDto.getAmountsByTax().compareTo(BigDecimal.ZERO) < 0) continue;
                BigDecimal canDisCountAmount = billDetailDto.getAmountsByTax().subtract(billDetailDto.getDisAmt().abs());
                BigDecimal currentRowDisCountAmount = canDisCountAmount.multiply(billDisRate).divide(new BigDecimal(100)).setScale(2, 4);
                if (currentRowDisCountAmount.compareTo(billDetailDto.getAmountsByTax()) >= 0) {
                    LOG.debug("\u4e0d\u6298\u8fd9\u884c");
                    continue;
                }
                disAmted = disAmted.add(currentRowDisCountAmount);
                billDetailDto.setDisAmt(billDetailDto.getDisAmt().abs().add(currentRowDisCountAmount));
            }
            BigDecimal adustAmt = disAmted.abs().subtract(billDisSum.abs());
            for (BillDetailDto goodDetail : detailList) {
                if (GoodsDiscountService.isDisCountRow(goodDetail) || goodDetail.getAmountsByTax().compareTo(BigDecimal.ZERO) < 0) continue;
                if (adustAmt.compareTo(BigDecimal.ZERO) > 0) {
                    if (goodDetail.getDisAmt().abs().compareTo(adustAmt) <= 0) continue;
                    goodDetail.setDisAmt(goodDetail.getDisAmt().abs().subtract(adustAmt));
                    break;
                }
                if (goodDetail.getDisAmt().abs().add(adustAmt.abs()).compareTo(goodDetail.getAmountsByTax()) >= 0) break;
                goodDetail.setDisAmt(goodDetail.getDisAmt().abs().add(adustAmt.abs()));
                break;
            }
        }
        return detailList;
    }

    private static List<BillDetailDto> generateDiscountRow(List<BillDetailDto> detailList, Integer type, BillDetailDto allDisDetail) {
        ArrayList<BillDetailDto> resultList = new ArrayList<BillDetailDto>();
        BigDecimal disAmt = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtInc = BigDecimal.ZERO;
        int i = 0;
        while (i < detailList.size()) {
            BillDetailDto billDetailDto = detailList.get(i);
            if (!(GoodsDiscountService.isDisCountRow(billDetailDto) || type != 0 && billDetailDto.getAmountsByTax().compareTo(BigDecimal.ZERO) < 0)) {
                resultList.add(billDetailDto);
                amt = amt.add(billDetailDto.getAmounts().abs());
                amtInc = amtInc.add(billDetailDto.getAmountsIncTax());
                if (billDetailDto.getDisAmt().compareTo(BigDecimal.ZERO) != 0) {
                    billDetailDto.setLineProperty(3);
                    BigDecimal lineDisRate = billDetailDto.getDisAmt().abs().divide(billDetailDto.getAmountsByTax(), 5, 4).multiply(new BigDecimal("100"));
                    billDetailDto.setDisRate(lineDisRate);
                    BillDetailDto discountRow = new BillDetailDto();
                    discountRow.setBillNO(billDetailDto.getBillNO());
                    discountRow.setBillDetailNO(billDetailDto.getBillDetailNO());
                    if (i < detailList.size() - 1 && GoodsDiscountService.isDisCountRow(detailList.get(i + 1))) {
                        discountRow.setBillNO(detailList.get(i + 1).getBillNO());
                        discountRow.setBillDetailNO(detailList.get(i + 1).getBillDetailNO());
                    }
                    if (allDisDetail != null) {
                        discountRow.setBillNO(allDisDetail.getBillNO());
                        discountRow.setBillDetailNO(allDisDetail.getBillDetailNO());
                    }
                    discountRow.setGoodsName(billDetailDto.getGoodsName());
                    discountRow.setTaxRate(billDetailDto.getTaxRate());
                    discountRow.setIncludeTax(billDetailDto.getIncludeTax());
                    discountRow.setLineProperty(4);
                    discountRow.setDisRows(1);
                    if (SmruleConfConstant.ONE.equals(billDetailDto.getIncludeTax())) {
                        discountRow.setAmountsIncTax(billDetailDto.getDisAmt().abs().negate());
                        BigDecimal taxAmt = new BackCalcUtilMethods().calcTaxAmt(billDetailDto.getDisAmt().abs(), billDetailDto.getTaxRate(), 2);
                        discountRow.setTaxAmt(taxAmt.abs().negate());
                        discountRow.setAmounts(billDetailDto.getDisAmt().abs().subtract(taxAmt.abs()).negate());
                        disAmt = disAmt.add(discountRow.getAmountsIncTax().abs());
                    } else {
                        discountRow.setTaxAmt(billDetailDto.getDisAmt().abs().multiply(billDetailDto.getTaxRate()).negate());
                        discountRow.setAmountsIncTax(billDetailDto.getDisAmt().abs().add(discountRow.getTaxAmt().abs()).negate());
                        discountRow.setAmounts(billDetailDto.getDisAmt().abs().negate());
                        disAmt = disAmt.add(discountRow.getAmounts().abs());
                    }
                    discountRow.setGoodsTaxNo(billDetailDto.getGoodsTaxNo());
                    discountRow.setGoodsNoVer(billDetailDto.getGoodsNoVer());
                    resultList.add(discountRow);
                }
            }
            ++i;
        }
        LOG.debug("[\u6298\u6263\u540e] \u6298\u6263\u91d1\u989d{} \u6b63\u6570\u91d1\u989d{} \u4ef7\u7a0e\u5408\u8ba1{}", new Object[]{disAmt, amt, amtInc});
        return resultList;
    }

    public static List<BillDetailDto> doBillDiscount(List<BillDetailDto> detailList) {
        BigDecimal plusAmt = new BigDecimal("0");
        BigDecimal billDisAmt = new BigDecimal("0");
        int i = 0;
        while (i < detailList.size()) {
            BillDetailDto nextRow;
            BillDetailDto billDetailDto = detailList.get(i);
            if (i + 1 < detailList.size() && GoodsDiscountService.isDisCountRow(nextRow = detailList.get(i + 1))) {
                billDetailDto.setDisAmt(nextRow.getAmountsByTax());
            }
            if (billDetailDto.getAmountsByTax().compareTo(BigDecimal.ZERO) < 0 && !GoodsDiscountService.isDisCountRow(billDetailDto)) {
                billDisAmt = billDisAmt.add(billDetailDto.getAmountsByTax().abs());
            } else if (billDetailDto.getAmountsByTax().compareTo(BigDecimal.ZERO) > 0) {
                plusAmt = plusAmt.add(billDetailDto.getAmountsByTax().subtract(billDetailDto.getDisAmt().abs()));
            }
            ++i;
        }
        LOG.debug("\u62b5\u6263\u4e0d\u5b8c\u6574\u5355\u6298 billDisAmt: " + billDisAmt + "  plusAmt: " + plusAmt);
        GoodsDiscountService.billDiscount(detailList, billDisAmt, plusAmt);
        return GoodsDiscountService.generateDiscountRow(detailList, 1, null);
    }
}

