/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.alibaba.fastjson.JSON;
import com.szhtxx.etcloud.smser.dto.BillDealResultDto;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillDetailIdDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.GoodsMergeResultDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.utils.BigDecimalUtils;
import com.szhtxx.etcloud.smser.utils.CalTaxUtils;
import com.szhtxx.etcloud.smser.utils.ComUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsMergeService {
    private static final Logger LOG = LoggerFactory.getLogger(GoodsMergeService.class);

    public static BillDealResultDto mergeGoods(BillSubjectDto billSubjectDto, SmruleConfigDto smruleConfig) {
        List<BillDetailDto> detailList = billSubjectDto.getBillDList();
        LOG.debug("\u5408\u5e76\u5546\u54c1\u884c\uff0c\u660e\u7ec6\u884c:{},\u62c6\u5408\u89c4\u5219:{} ", (Object)JSON.toJSONString(detailList), (Object)JSON.toJSONString((Object)smruleConfig));
        BillDealResultDto resultDto = new BillDealResultDto();
        resultDto.setBillNO(detailList.get(0).getBillNO());
        resultDto.setSuccess(true);
        int mergeGoodsLine = smruleConfig.getMergeGoodsLine();
        if (mergeGoodsLine == 0) {
            return resultDto;
        }
        ArrayList<BillDetailDto> originalDetailList = new ArrayList<BillDetailDto>(detailList.size() * 2);
        int index = 0;
        while (index < detailList.size()) {
            BillDetailDto billDetailDto = new BillDetailDto();
            try {
                BeanUtils.copyProperties((Object)billDetailDto, (Object)detailList.get(index));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            originalDetailList.add(billDetailDto);
            ++index;
        }
        GoodsMergeService.dealMergeIgnoreError(detailList, mergeGoodsLine);
        LOG.debug("\u9884\u5408\u5e76(\u5ffd\u7565\u8bef\u5dee)\uff0c\u660e\u7ec6\u884c\u7ed3\u679c:{}", (Object)JSON.toJSONString(detailList));
        int nowIndex = 0;
        while (nowIndex < detailList.size()) {
            BillDetailDto nowDetail = detailList.get(nowIndex);
            if (nowDetail.getLineProperty() != 4 && nowDetail.getDetailIdSet().size() > 1) {
                ArrayList<BillDetailDto> preRemoveList = new ArrayList<BillDetailDto>(4);
                GoodsMergeService.dealGoodsTax(smruleConfig, originalDetailList, detailList, nowDetail, preRemoveList);
                if (nowDetail.getDetailIdSet().size() > 1) {
                    int calType;
                    if (nowIndex + 1 < detailList.size()) {
                        BillDetailDto nowDiscountDetail = detailList.get(nowIndex + 1);
                        GoodsMergeService.dealDiscountTax(nowDiscountDetail, smruleConfig.getLineTaxAmtErr());
                    }
                    int n = calType = mergeGoodsLine == 2 ? 1 : 0;
                    if (nowDetail.getDetailIdSet().size() > 1) {
                        GoodsMergeService.dealAmtsAndPrice(nowDetail, smruleConfig, calType);
                    }
                    GoodsMergeService.dealRemark(smruleConfig, originalDetailList, nowDetail);
                }
            }
            ++nowIndex;
        }
        LOG.debug("\u5408\u5e76\u5546\u54c1\u884c\uff0c\u6700\u7ec8\u7ed3\u679c:{}", (Object)JSON.toJSONString(detailList));
        return resultDto;
    }

    public static void dealGoodsTax(SmruleConfigDto smruleConfig, List<BillDetailDto> originalBillDetailList, List<BillDetailDto> billDetailList, BillDetailDto nowDetail, List<BillDetailDto> preRemoveList) {
        BigDecimal calTax = CalTaxUtils.calTax(0, nowDetail.getAmounts(), nowDetail.getTaxRate());
        BigDecimal taxError = calTax.subtract(nowDetail.getTaxAmt()).setScale(2, 4);
        if (taxError.abs().compareTo(smruleConfig.getLineTaxAmtErr()) <= 0) {
            if (CollectionUtils.isNotEmpty(preRemoveList)) {
                billDetailList.addAll(preRemoveList);
            }
            return;
        }
        if (smruleConfig.getTotalTaxamtCount() == 1) {
            calTax = CalTaxUtils.calTax(nowDetail.getIncludeTax(), nowDetail.getAmountsByTax(), nowDetail.getTaxRate());
            LOG.debug("\u5546\u54c1\u884c\u5408\u5e76\u8d85\u8bef\u5dee\uff0c\u7a0e\u989d\u91cd\u65b0\u8ba1\u7b97={}", (Object)calTax);
            nowDetail.setTaxAmt(calTax);
            nowDetail.setOtherMoney();
        } else {
            BillDetailDto removeDetail = GoodsMergeService.findAbsMaxTaxError(nowDetail, originalBillDetailList);
            LOG.debug("\u9884\u5408\u5e76\u8d85\u8bef\u5dee\uff0c\u79fb\u9664\u7684\u6700\u5927\u8bef\u5dee\u5546\u54c1\u884c:\u3010{}\u3011", (Object)removeDetail.getBillDetailNO());
            List<BillDetailDto> removeList = GoodsMergeService.removeBillDetail(nowDetail, removeDetail, billDetailList, originalBillDetailList);
            GoodsMergeService.dealRemoveList(preRemoveList, removeList, billDetailList, smruleConfig);
            GoodsMergeService.dealGoodsTax(smruleConfig, originalBillDetailList, billDetailList, nowDetail, preRemoveList);
        }
    }

    public static void dealDiscountTax(BillDetailDto nowDiscountDetail, BigDecimal lineTaxAmtErr) {
        if (nowDiscountDetail.getLineProperty() == 4) {
            BigDecimal money = nowDiscountDetail.getIncludeTax() == 0 ? nowDiscountDetail.getAmounts() : nowDiscountDetail.getAmountsIncTax();
            BigDecimal calDiscountTax = CalTaxUtils.calTax(nowDiscountDetail.getIncludeTax(), money, nowDiscountDetail.getTaxRate());
            BigDecimal dicountTaxError = calDiscountTax.subtract(nowDiscountDetail.getTaxAmt()).abs().setScale(2, 4);
            if (dicountTaxError.compareTo(lineTaxAmtErr) > 0) {
                nowDiscountDetail.setTaxAmt(calDiscountTax);
                if (nowDiscountDetail.getIncludeTax() == 0) {
                    nowDiscountDetail.setAmountsIncTax(money.add(calDiscountTax));
                } else {
                    nowDiscountDetail.setAmounts(money.subtract(calDiscountTax));
                }
            }
        }
    }

    public static void dealMergeIgnoreError(List<BillDetailDto> detailList, int mergeGoodsLine) {
        int nowIndex = 0;
        while (nowIndex < detailList.size()) {
            BillDetailDto nowDetail = detailList.get(nowIndex);
            if (nowDetail.getLineProperty() != 4 && nowDetail.getAmounts().compareTo(BigDecimal.ZERO) > 0) {
                int nextIndex = nowIndex + 1;
                while (nextIndex < detailList.size()) {
                    BillDetailDto nextDetail = detailList.get(nextIndex);
                    if (GoodsMergeService.isMergeCondition(nowDetail, nextDetail, mergeGoodsLine)) {
                        BigDecimal mergeAmounts = nowDetail.getAmounts().add(nextDetail.getAmounts()).setScale(2, 4);
                        BigDecimal mergeAmountsIncTax = nowDetail.getAmountsIncTax().add(nextDetail.getAmountsIncTax()).setScale(2, 4);
                        BigDecimal mergeTaxAmt = nowDetail.getTaxAmt().add(nextDetail.getTaxAmt()).setScale(2, 4);
                        BigDecimal mergeAmts = BigDecimalUtils.add(nowDetail.getAmts(), nextDetail.getAmts(), BigDecimal.ZERO);
                        nowDetail.setAmounts(mergeAmounts);
                        nowDetail.setAmountsIncTax(mergeAmountsIncTax);
                        nowDetail.setTaxAmt(mergeTaxAmt);
                        if (mergeAmts != null && mergeAmts.compareTo(BigDecimal.ZERO) != 0) {
                            nowDetail.setAmts(mergeAmts);
                        }
                        GoodsMergeResultDto discountDealResult = GoodsMergeService.dealDiscountMerge(detailList, nowIndex, nextIndex);
                        nowIndex = discountDealResult.getNowIndex();
                        nextIndex = discountDealResult.getNextIndex();
                        nowDetail.addDetailId(nextDetail.getDetailIdSet());
                        detailList.remove(nextIndex);
                        --nextIndex;
                    }
                    ++nextIndex;
                }
            }
            ++nowIndex;
        }
    }

    public static GoodsMergeResultDto dealDiscountMerge(List<BillDetailDto> detailList, int nowIndex, int nextIndex) {
        BillDetailDto nextDiscountDetail = null;
        BillDetailDto nowDiscountDetail = null;
        BillDetailDto nowDetail = detailList.get(nowIndex);
        boolean hasNextDiscount = false;
        int discountIndex = nextIndex + 1;
        if (discountIndex < detailList.size() && detailList.get(discountIndex).getLineProperty() == 4) {
            hasNextDiscount = true;
            nextDiscountDetail = detailList.get(discountIndex);
        }
        if (!hasNextDiscount) {
            return new GoodsMergeResultDto(nowIndex, nextIndex);
        }
        boolean hasNowDiscount = false;
        discountIndex = nowIndex + 1;
        if (discountIndex < detailList.size() && detailList.get(discountIndex).getLineProperty() == 4) {
            hasNowDiscount = true;
            nowDiscountDetail = detailList.get(discountIndex);
        }
        if (hasNowDiscount) {
            BigDecimal disAmounts = nextDiscountDetail.getAmounts().add(nowDiscountDetail.getAmounts()).setScale(2, 4);
            BigDecimal disAmountsIncTax = nextDiscountDetail.getAmountsIncTax().add(nowDiscountDetail.getAmountsIncTax()).setScale(2, 4);
            BigDecimal disTaxAmt = nextDiscountDetail.getTaxAmt().add(nowDiscountDetail.getTaxAmt()).setScale(2, 4);
            nowDiscountDetail.setAmounts(disAmounts);
            nowDiscountDetail.setAmountsIncTax(disAmountsIncTax);
            nowDiscountDetail.setTaxAmt(disTaxAmt);
            nowDiscountDetail.addDetailId(nextDiscountDetail.getDetailIdSet());
        } else {
            nowDiscountDetail = new BillDetailDto();
            try {
                BeanUtils.copyProperties((Object)nowDiscountDetail, (Object)nextDiscountDetail);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            detailList.add(nowIndex + 1, nowDiscountDetail);
            ++nextIndex;
        }
        detailList.remove(nextDiscountDetail);
        nowDetail.setLineProperty(3);
        BigDecimal disRate = detailList.get(nowIndex + 1).getAmounts().multiply(new BigDecimal("100")).divide(detailList.get(nowIndex).getAmounts(), 3, 4).abs();
        nowDetail.setDisRate(disRate);
        return new GoodsMergeResultDto(nowIndex, nextIndex);
    }

    public static void dealAmtsAndPrice(BillDetailDto nowDetail, SmruleConfigDto smruleConfigDto, int calType) {
        BigDecimal lineAmountErr = smruleConfigDto.getLineAmountErr();
        BigDecimal amts = nowDetail.getAmts();
        BigDecimal price = nowDetail.getPrice();
        BigDecimal priceIncTax = nowDetail.getPriceIncTax();
        BigDecimal amounts = nowDetail.getAmounts();
        BigDecimal amountsIncTax = nowDetail.getAmountsIncTax();
        if (amts == null || amts.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Map<String, Integer> digitByRuleConfig = ComUtil.getDigitByRuleConfig(smruleConfigDto);
        int amtNumber = digitByRuleConfig.get("amtNumber");
        int priceNumber = digitByRuleConfig.get("priceNumber");
        if (amts.setScale(amtNumber, 4).compareTo(BigDecimal.ZERO) != 0) {
            amts = amts.setScale(amtNumber, 4);
            LOG.debug("\u6570\u91cf\uff1a\u4fdd\u7559\u3010{}\u3011\u4f4d\u5c0f\u6570\u540e\u4e3a\u3010{}\u3011", (Object)amtNumber, (Object)amts);
        }
        BigDecimal amountsError = amts.multiply(price).setScale(2, 4).subtract(amounts).abs();
        BigDecimal amountsIncludeTaxError = amts.multiply(priceIncTax).setScale(2, 4).subtract(amountsIncTax).abs();
        if (nowDetail.getIncludeTax() == 0) {
            if (amountsError.compareTo(lineAmountErr) > 0) {
                amts = BigDecimalUtils.recursionDivision(amounts, price, amtNumber, lineAmountErr);
                amountsIncludeTaxError = amts.multiply(priceIncTax).setScale(2, 4).subtract(amountsIncTax).abs();
            }
            if (amountsIncludeTaxError.compareTo(lineAmountErr) > 0) {
                LOG.debug("\u53cd\u7b97\u53e6\u4e00\u4e2a\u5355\u4ef7\uff08\u542b\u7a0e\u5355\u4ef7\uff09=\u4ef7\u7a0e\u5408\u8ba1 / \u6570\u91cf");
                priceIncTax = BigDecimalUtils.recursionDivision(amountsIncTax, amts, priceNumber, lineAmountErr);
            }
        }
        if (1 == nowDetail.getIncludeTax()) {
            if (amountsIncludeTaxError.compareTo(lineAmountErr) > 0) {
                amts = BigDecimalUtils.recursionDivision(amountsIncTax, priceIncTax, amtNumber, lineAmountErr);
                amountsError = amts.multiply(price).setScale(2, 4).subtract(amountsIncTax).abs();
            }
            if (amountsError.compareTo(lineAmountErr) > 0) {
                LOG.debug("\u53cd\u7b97\u53e6\u4e00\u4e2a\u5355\u4ef7\uff08\u4e0d\u542b\u7a0e\u5355\u4ef7\uff09=\u4e0d\u542b\u7a0e\u91d1\u989d / \u6570\u91cf");
                price = BigDecimalUtils.recursionDivision(amounts, amts, priceNumber, lineAmountErr);
            }
        }
        LOG.debug("\u8bbe\u7f6e\u5546\u54c1\u884c\u3010{}\u3011\uff1a\u5355\u4ef7=\u3010{}\u3011\uff0c\u542b\u7a0e\u5355\u4ef7=\u3010{}\u3011\uff0c\u6570\u91cf=\u3010{}\u3011", new Object[]{nowDetail.getBillDetailNO(), price, priceIncTax, amts});
        nowDetail.setPrice(price);
        nowDetail.setPriceIncTax(priceIncTax);
        nowDetail.setAmts(amts);
    }

    public static void dealRemark(SmruleConfigDto smruleConfig, List<BillDetailDto> detailList, BillDetailDto nowDetail) {
        String mergeRemark = nowDetail.getLineNote();
        Set<BillDetailIdDto> detailIdSet = nowDetail.getDetailIdSet();
        ArrayList<BillDetailIdDto> sort = new ArrayList<BillDetailIdDto>(detailIdSet);
        Collections.sort(sort, Comparator.comparing(BillDetailIdDto::getBillDetailNO));
        for (BillDetailIdDto next : sort) {
            if (next.getBillDetailNO().equals(nowDetail.getBillDetailNO())) continue;
            BillDetailDto nextDetail = null;
            for (BillDetailDto billDetailDto : detailList) {
                if (!billDetailDto.getBillDetailNO().equals(next.getBillDetailNO())) continue;
                nextDetail = billDetailDto;
                break;
            }
            if (!StringUtils.isNotEmpty((CharSequence)nextDetail.getLineNote())) continue;
            mergeRemark = StringUtils.isNotEmpty((CharSequence)mergeRemark) && (smruleConfig.isMccRepeat() || !mergeRemark.equals(nextDetail.getLineNote())) ? String.valueOf(mergeRemark) + smruleConfig.getMccNoteStr() + nextDetail.getLineNote() : nextDetail.getLineNote();
        }
        LOG.debug("\u8bbe\u7f6e\u5546\u54c1\u884c\u3010{}\u3011\uff1a\u5907\u6ce8=\u3010{}\u3011", (Object)nowDetail.getBillDetailNO(), (Object)mergeRemark);
        nowDetail.setLineNote(mergeRemark);
    }

    public static BillDetailDto findAbsMaxTaxError(BillDetailDto nowDetail, List<BillDetailDto> originalBillDetailList) {
        Set<BillDetailIdDto> detailIdSet = nowDetail.getDetailIdSet();
        Map<String, BillDetailDto> billDetailMap = originalBillDetailList.stream().collect(Collectors.toMap(BillDetailDto::getBillDetailNO, billDetailDto -> billDetailDto));
        ArrayList<BillDetailDto> mergeDetailList = new ArrayList<BillDetailDto>(detailIdSet.size() * 2);
        for (BillDetailIdDto billDetailIdDto : detailIdSet) {
            if (billDetailIdDto.getBillDetailNO().equals(nowDetail.getBillDetailNO())) continue;
            mergeDetailList.add(billDetailMap.get(billDetailIdDto.getBillDetailNO()));
        }
        BillDetailDto removeDetail = nowDetail.queryLineTaxError().compareTo(BigDecimal.ZERO) > 0 ? mergeDetailList.stream().max(Comparator.comparing(BillDetailDto::queryLineTaxError)).get() : mergeDetailList.stream().min(Comparator.comparing(BillDetailDto::queryLineTaxError)).get();
        return removeDetail;
    }

    public static List<BillDetailDto> removeBillDetail(BillDetailDto mergeDetail, BillDetailDto removeDetail, List<BillDetailDto> mergeBillDetailList, List<BillDetailDto> originalBillDetailList) {
        int removeIndex;
        ArrayList<BillDetailDto> removeDetailList = new ArrayList<BillDetailDto>();
        removeDetailList.add(removeDetail);
        Set<BillDetailIdDto> detailIdSet = mergeDetail.getDetailIdSet();
        Iterator<BillDetailIdDto> iterator = detailIdSet.iterator();
        while (iterator.hasNext()) {
            BillDetailIdDto next = iterator.next();
            if (!removeDetail.getBillDetailNO().equals(next.getBillDetailNO())) continue;
            iterator.remove();
            break;
        }
        mergeDetail.setAmounts(mergeDetail.getAmounts().subtract(removeDetail.getAmounts()));
        mergeDetail.setTaxAmt(mergeDetail.getTaxAmt().subtract(removeDetail.getTaxAmt()));
        mergeDetail.setAmountsIncTax(mergeDetail.getAmountsIncTax().subtract(removeDetail.getAmountsIncTax()));
        if (mergeDetail.getAmts() != null && removeDetail.getAmts() != null) {
            mergeDetail.setAmts(mergeDetail.getAmts().subtract(removeDetail.getAmts()));
        }
        if ((removeIndex = originalBillDetailList.indexOf(removeDetail)) + 1 < originalBillDetailList.size() && originalBillDetailList.get(removeIndex + 1).getLineProperty() == 4) {
            BillDetailDto removeDisconutDetail = originalBillDetailList.get(removeIndex + 1);
            int nowIndex = mergeBillDetailList.indexOf(mergeDetail);
            BillDetailDto nowDiscountDetail = mergeBillDetailList.get(nowIndex + 1);
            nowDiscountDetail.setAmounts(nowDiscountDetail.getAmounts().subtract(removeDisconutDetail.getAmounts()));
            nowDiscountDetail.setTaxAmt(nowDiscountDetail.getTaxAmt().subtract(removeDisconutDetail.getTaxAmt()));
            nowDiscountDetail.setAmountsIncTax(nowDiscountDetail.getAmountsIncTax().subtract(removeDisconutDetail.getAmountsIncTax()));
            BigDecimal amountsByTax = nowDiscountDetail.getAmountsByTax();
            if (amountsByTax.compareTo(BigDecimal.ZERO) == 0) {
                mergeBillDetailList.remove(nowDiscountDetail);
            }
            Set<BillDetailIdDto> discountDetailIdSet = nowDiscountDetail.getDetailIdSet();
            Iterator<BillDetailIdDto> discountIterator = discountDetailIdSet.iterator();
            while (discountIterator.hasNext()) {
                BillDetailIdDto next = discountIterator.next();
                if (!removeDisconutDetail.getBillDetailNO().equals(next.getBillDetailNO())) continue;
                discountIterator.remove();
                break;
            }
            removeDetailList.add(removeDisconutDetail);
        }
        return removeDetailList;
    }

    public static void dealRemoveList(List<BillDetailDto> preRemoveList, List<BillDetailDto> removeList, List<BillDetailDto> mergeList, SmruleConfigDto smruleConfig) {
        BillDetailDto removeDetail = removeList.get(0);
        if (CollectionUtils.isEmpty(preRemoveList)) {
            preRemoveList.addAll(removeList);
        } else {
            ArrayList<BillDetailDto> removeMergeList = new ArrayList<BillDetailDto>(8);
            BillDetailDto preRemoveDetail = preRemoveList.get(0);
            if (preRemoveDetail.getBillDetailNO().compareTo(removeDetail.getBillDetailNO()) > 0) {
                BillDetailDto newDetail;
                for (BillDetailDto billDetailDto : removeList) {
                    newDetail = new BillDetailDto();
                    try {
                        BeanUtils.copyProperties((Object)newDetail, (Object)billDetailDto);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    removeMergeList.add(newDetail);
                }
                for (BillDetailDto billDetailDto : preRemoveList) {
                    newDetail = new BillDetailDto();
                    try {
                        BeanUtils.copyProperties((Object)newDetail, (Object)billDetailDto);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    removeMergeList.add(newDetail);
                }
            } else {
                BillDetailDto newDetail;
                for (BillDetailDto billDetailDto : preRemoveList) {
                    newDetail = new BillDetailDto();
                    try {
                        BeanUtils.copyProperties((Object)newDetail, (Object)billDetailDto);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    removeMergeList.add(newDetail);
                }
                for (BillDetailDto billDetailDto : removeList) {
                    newDetail = new BillDetailDto();
                    try {
                        BeanUtils.copyProperties((Object)newDetail, (Object)billDetailDto);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    removeMergeList.add(newDetail);
                }
            }
            GoodsMergeService.dealMergeIgnoreError(removeMergeList, smruleConfig.getMergeGoodsLine());
            BillDetailDto removeMergeDetail = (BillDetailDto)removeMergeList.get(0);
            BigDecimal removeMergeTaxError = removeMergeDetail.queryLineTaxError().setScale(2, 4);
            if (removeMergeTaxError.abs().compareTo(smruleConfig.getLineTaxAmtErr()) > 0) {
                mergeList.addAll(preRemoveList);
                preRemoveList.clear();
                preRemoveList.addAll(removeList);
            } else {
                preRemoveList.clear();
                preRemoveList.addAll(removeMergeList);
            }
        }
    }

    public static boolean isMergeCondition(BillDetailDto nowDetail, BillDetailDto nextDetail, int mergeGoodsLine) {
        if (nextDetail.getLineProperty() == 4 || nextDetail.getAmounts().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        if (BigDecimalUtils.equals(nowDetail.getTaxRate(), nextDetail.getTaxRate()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(nowDetail.getGoodsName(), nextDetail.getGoodsName()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(nowDetail.getGoodsModel(), nextDetail.getGoodsModel()) && com.szhtxx.etcloud.smser.utils.StringUtils.equalIgnoreNull(nowDetail.getGoodsUnit(), nextDetail.getGoodsUnit())) {
            BigDecimal nextDetailPrice;
            boolean incTaxFlag = nowDetail.getIncludeTax() != 0;
            BigDecimal nowDetailPrice = incTaxFlag ? nowDetail.getPriceIncTax() : nowDetail.getPrice();
            BigDecimal bigDecimal = nextDetailPrice = incTaxFlag ? nextDetail.getPriceIncTax() : nextDetail.getPrice();
            if (BigDecimalUtils.equals(nowDetailPrice, nextDetailPrice) && mergeGoodsLine == 2) {
                return true;
            }
        }
        return false;
    }
}

