/*
 * Decompiled with CFR 0.152.
 */
package com.szhtxx.etcloud.smser.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.AtomicDouble;
import com.szhtxx.etcloud.smser.dto.BillDetailDto;
import com.szhtxx.etcloud.smser.dto.BillDetailIdDto;
import com.szhtxx.etcloud.smser.dto.BillSubjectDto;
import com.szhtxx.etcloud.smser.dto.InvoiceDetailDto;
import com.szhtxx.etcloud.smser.dto.InvoiceSubjectDto;
import com.szhtxx.etcloud.smser.dto.SmruleConfigDto;
import com.szhtxx.etcloud.smser.dto.SmsResultDto;
import com.szhtxx.etcloud.smser.enums.EnumType;
import com.szhtxx.etcloud.smser.exception.EtcRuleException;
import com.szhtxx.etcloud.smser.methods.smser.BackCalcUtilMethods;
import com.szhtxx.etcloud.smser.service.InvoiceSplitCoreService;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceCoreService {
    private static Logger LOG = LoggerFactory.getLogger(InvoiceCoreService.class);
    private static BackCalcUtilMethods calcUtilMethods = new BackCalcUtilMethods();

    public static void openInvoice(BillSubjectDto billSubjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto) {
        String billSubjectNo = billSubjectDto.getBillNO();
        LOG.debug("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectNo, JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
        BigDecimal invLimitAmt = configDto.getFinalLimitAmt();
        BigDecimal amountIncTax = billSubjectDto.getSumAmtJE().add(billSubjectDto.getSumAmtSE());
        AtomicDouble remarkAmountSum = new AtomicDouble(0.0);
        if (amountIncTax.divide(invLimitAmt, 0, 2).compareTo(new BigDecimal("1000")) > 0) {
            LOG.info("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectNo, JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
            throw new EtcRuleException("\u5355\u636e\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u9650\u989d\u76841000\u500d\uff0c\u8bf7\u8c03\u6574\u5355\u636e\u91d1\u989d");
        }
        try {
            InvoiceCoreService.openInvoiceDetail(billSubjectDto, configDto, smsResultDto, remarkAmountSum);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            LOG.info(e.getMessage());
            throw new EtcRuleException("\u5bf9\u8c61\u5907\u4efd\u5931\u8d25");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void openInvoiceDetail(BillSubjectDto billSubjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto, AtomicDouble remarkAmountSum) throws IllegalAccessException, InvocationTargetException {
        block22: {
            billSubjectNo = billSubjectDto.getBillNO();
            InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}]\u751f\u6210\u53d1\u7968\u8bf7\u6c42\u62a5\u6587 \u5355\u636e:{}\uff0c\u89c4\u5219\u914d\u7f6e:{}", new Object[]{billSubjectNo, JSONObject.toJSONString((Object)billSubjectDto), JSONObject.toJSONString((Object)configDto)});
            detailDtos = billSubjectDto.getBillDList();
            allAmount = billSubjectDto.getSumAmtJE();
            splitAmounts = configDto.getSplitAmounts();
            amountSum = BigDecimal.ZERO;
            taxAmtErrSum = BigDecimal.ZERO;
            remark = "";
            lastIndex = -1;
            if (!CollectionUtils.isNotEmpty(detailDtos)) break block22;
            size = detailDtos.size();
            newLineNum = 0;
            i = 0;
            while (i < size + newLineNum) {
                block24: {
                    block25: {
                        block23: {
                            invLimitAmt = configDto.getFinalLimitAmt();
                            if (splitAmounts != null && !splitAmounts.isEmpty()) {
                                invLimitAmt = splitAmounts.get(0);
                            }
                            if ("1123885409810882572".equals((detailDto = detailDtos.get(i)).getBillDetailNO())) {
                                System.out.print(111);
                            }
                            j = i + 1;
                            disDto = null;
                            if (j < size && InvoiceCoreService.isDisLine(detailDtos.get(j)).booleanValue()) {
                                disDto = detailDtos.get(j);
                            }
                            billNo = detailDto.getBillNO();
                            lineAmount = detailDto.getAmounts();
                            disLineAmount = lineAmount.add(BigDecimal.ZERO);
                            if (disDto != null) {
                                disLineAmount = disLineAmount.add(disDto.getAmounts());
                            }
                            if (disLineAmount.compareTo(invLimitAmt) <= 0) break block23;
                            k = i++;
                            toSplitDetails = new ArrayList<BillDetailDto>();
                            toSplitDetails.add(detailDtos.get(k));
                            if (j < size && InvoiceCoreService.isDisLine(detailDtos.get(j)).booleanValue()) {
                                disDto = detailDtos.get(j);
                                toSplitDetails.add(disDto);
                                detailDtos.remove(j);
                            }
                            detailDtos.remove(k);
                            splitGoods = InvoiceSplitCoreService.goodsLineSplit(toSplitDetails, configDto, amountSum, toSplitDetails.size() > 1, allAmount, splitAmounts);
                            detailDtos.addAll(k, splitGoods);
                            size = detailDtos.size();
                            InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u8d85\u8fc7\u6700\u5927\u884c\u6570 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, i + 1, amountSum, taxAmtErrSum});
                            remark = "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968";
                            lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, i, remark, detailDtos.get(0).getLineNote(), remarkAmountSum);
                            if (splitAmounts != null && !splitAmounts.isEmpty()) {
                                splitAmounts.remove(0);
                            }
                            invoinceAmount = smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts();
                            allAmount = allAmount.subtract(invoinceAmount);
                            amountSum = BigDecimal.ZERO;
                            taxAmtErrSum = BigDecimal.ZERO;
                            break block24;
                        }
                        lsLastLine = InvoiceCoreService.isLastLine(billSubjectDto, i);
                        if (lsLastLine.booleanValue()) {
                            InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u6700\u540e\u4e00\u884c[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, i + 1, amountSum, taxAmtErrSum});
                            remark = "\u6700\u540e\u4e00\u884c\u5f00\u7968";
                            InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, i, remark, detailDtos.get(0).getLineNote(), remarkAmountSum);
                            if (splitAmounts == null || splitAmounts.isEmpty()) break;
                            splitAmounts.remove(0);
                            break;
                        }
                        if (!InvoiceCoreService.isOpenInvIndex(billSubjectDto, i, lastIndex)) break block25;
                        InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u8d85\u8fc7\u6700\u5927\u884c\u6570 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, i + 1, amountSum, taxAmtErrSum});
                        remark = "\u8d85\u8fc7\u6700\u5927\u884c\u6570\u5f00\u7968";
                        lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, i, remark, detailDtos.get(0).getLineNote(), remarkAmountSum);
                        if (splitAmounts != null && !splitAmounts.isEmpty()) {
                            splitAmounts.remove(0);
                        }
                        invoinceAmount = smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts();
                        allAmount = allAmount.subtract(invoinceAmount);
                        amountSum = BigDecimal.ZERO;
                        taxAmtErrSum = BigDecimal.ZERO;
                        break block24;
                    }
                    if (InvoiceCoreService.isDisLine(detailDto).booleanValue()) break block24;
                    amountSum = amountSum.add(lineAmount);
                    if (disDto != null && InvoiceCoreService.isDisLine(disDto).booleanValue()) {
                        amountSum = amountSum.add(disDto.getAmounts());
                        disAmt = disDto.getAmounts();
                        disTaxRate = disDto.getTaxRate();
                        disTaxAmt = disDto.getTaxAmt();
                        taxAmtErr = disAmt.multiply(disTaxRate).subtract(disTaxAmt).setScale(2, 4);
                        taxAmtErrSum = taxAmtErrSum.add(taxAmtErr);
                    }
                    if (amountSum.compareTo(invLimitAmt) >= 0 || !InvoiceCoreService.addNextProLineIsExpeed(detailDtos, i, amountSum, invLimitAmt).booleanValue()) ** GOTO lbl135
                    nextIndex = disDto != null ? i + 2 : i + 1;
                    nextDetails = detailDtos.get(nextIndex);
                    nextLineAmount = nextDetails.getAmounts();
                    nextDisDto = null;
                    if (nextIndex + 1 < size && detailDtos.get(nextIndex + 1) != null && InvoiceCoreService.isDisLine(detailDtos.get(nextIndex + 1)).booleanValue()) {
                        nextDisDto = detailDtos.get(nextIndex + 1);
                        nextLineAmount = nextDisDto.getAmounts();
                    }
                    if (configDto.getSplitGoodsLine() == 0 && nextLineAmount.compareTo(invLimitAmt) < 0 || 1 == nextDetails.getSplitSign()) ** GOTO lbl135
                    if (disDto != null) {
                        ++i;
                    }
                    toSplitDetails = new ArrayList<BillDetailDto>();
                    toSplitDetails.add(nextDetails);
                    if (nextDisDto != null) {
                        toSplitDetails.add(nextDisDto);
                        detailDtos.remove(nextIndex + 1);
                        ++i;
                    }
                    detailDtos.remove(nextIndex);
                    ++i;
                    toSplitNum = toSplitDetails.size();
                    splitGoods = InvoiceSplitCoreService.goodsLineSplit(toSplitDetails, configDto, amountSum, toSplitDetails.size() > 1, allAmount, splitAmounts);
                    detailDtos.addAll(nextIndex, splitGoods);
                    size = detailDtos.size();
                    if (splitGoods.size() > toSplitNum) {
                        if (nextDisDto != null && !InvoiceCoreService.isDisLine(splitGoods.get(1)).booleanValue()) {
                            --i;
                        }
                        InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u8d85\u8fc7\u6700\u5927\u884c\u6570 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, i + 1, amountSum, taxAmtErrSum});
                        remark = "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968";
                        lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, i, remark, detailDtos.get(0).getLineNote(), remarkAmountSum);
                        if (splitAmounts != null && !splitAmounts.isEmpty()) {
                            splitAmounts.remove(0);
                        }
                        invoinceAmount = smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts();
                        allAmount = allAmount.subtract(invoinceAmount);
                        amountSum = BigDecimal.ZERO;
                        taxAmtErrSum = BigDecimal.ZERO;
                    } else {
                        if (disDto != null) {
                            --i;
                        }
                        --i;
lbl135:
                        // 3 sources

                        if (amountSum.compareTo(invLimitAmt) == 0 || InvoiceCoreService.addNextProLineIsExpeed(detailDtos, i, amountSum, invLimitAmt).booleanValue()) {
                            InvoiceCoreService.LOG.debug("\u5355\u636e\u7f16\u53f7[{}] \u91d1\u989d\u7d2f\u8ba1\u8d85\u9650 \u884c\u53f7[{}]\u5f00\u7968,\u91d1\u989d\u7d2f\u8ba1\uff1a{},\u7a0e\u989d\u8bef\u5dee\u7d2f\u8ba1:{}", new Object[]{billNo, i + 1, amountSum, taxAmtErrSum});
                            remark = "\u91d1\u989d\u7d2f\u8ba1\u8d85\u9650\u5f00\u7968";
                            lastIndex = InvoiceCoreService.saveInvoince(smsResultDto, configDto, billSubjectDto, lastIndex, i, remark, detailDtos.get(0).getLineNote(), remarkAmountSum);
                            if (splitAmounts != null && !splitAmounts.isEmpty()) {
                                splitAmounts.remove(0);
                            }
                            invoinceAmount = smsResultDto.getInvoiceSList().get(smsResultDto.getInvoiceSList().size() - 1).getAmounts();
                            allAmount = allAmount.subtract(invoinceAmount);
                            amountSum = BigDecimal.ZERO;
                            taxAmtErrSum = BigDecimal.ZERO;
                        } else {
                            taxRate = detailDto.getTaxRate();
                            dec = detailDto.getTaxDeduction();
                            if (dec == null) {
                                dec = BigDecimal.ZERO;
                            }
                            calTaxAmt = lineAmount.subtract(dec).multiply(taxRate);
                            taxAmtErr = calTaxAmt.subtract(detailDto.getTaxAmt()).setScale(2, 4);
                            taxAmtErrSum = taxAmtErrSum.add(taxAmtErr);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static Boolean addNextProLineIsExpeed(List<BillDetailDto> detailDtos, int curIndex, BigDecimal amountSum, BigDecimal invLimitAmt) {
        BigDecimal countNextAmount = BigDecimal.ZERO.add(amountSum);
        int j = curIndex + 1;
        if (j < detailDtos.size()) {
            BillDetailDto disLineDto = detailDtos.get(j);
            if (InvoiceCoreService.isDisLine(disLineDto).booleanValue()) {
                BillDetailDto nextDisDto;
                int m;
                int k = j + 1;
                if (k < detailDtos.size()) {
                    BillDetailDto nextProDto = detailDtos.get(k);
                    countNextAmount = countNextAmount.add(nextProDto.getAmounts());
                }
                if ((m = k + 1) < detailDtos.size() && InvoiceCoreService.isDisLine(nextDisDto = detailDtos.get(m)).booleanValue()) {
                    countNextAmount = countNextAmount.add(nextDisDto.getAmounts());
                }
            } else {
                BillDetailDto nextDisDto;
                BillDetailDto nextProDto = detailDtos.get(j);
                BigDecimal nextProAmt = nextProDto.getAmounts();
                countNextAmount = countNextAmount.add(nextProAmt);
                int k = j + 1;
                if (k < detailDtos.size() && InvoiceCoreService.isDisLine(nextDisDto = detailDtos.get(k)).booleanValue()) {
                    countNextAmount = countNextAmount.add(nextDisDto.getAmounts());
                }
            }
        }
        if (countNextAmount.compareTo(invLimitAmt) > 0) {
            return true;
        }
        return false;
    }

    private static BigDecimal calLineAmtTax(BillDetailDto billDetailDto) {
        BigDecimal taxRate = billDetailDto.getTaxRate();
        BigDecimal amounts = billDetailDto.getAmounts();
        BigDecimal dec = billDetailDto.getTaxDeduction();
        if (dec == null) {
            dec = BigDecimal.ZERO;
        }
        BigDecimal taxAmt = billDetailDto.getTaxAmt();
        BigDecimal calTaxAmt = amounts.subtract(dec).multiply(taxRate);
        return calTaxAmt.subtract(taxAmt).setScale(2, 4);
    }

    public static Boolean isDisLine(BillDetailDto detailDto) {
        Integer lineProperty = detailDto.getLineProperty();
        BigDecimal amounts = detailDto.getAmounts();
        Boolean isDisline = false;
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && amounts.compareTo(BigDecimal.ZERO) < 0) {
            isDisline = true;
        }
        return isDisline;
    }

    private static boolean isOpenInvIndex(BillSubjectDto billSubjectDto, int i, int lastIndx) {
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        int size = detailDtos.size();
        int limitLine = billSubjectDto.getLimitLine();
        int nextInvMaxIndex = lastIndx + limitLine;
        if (nextInvMaxIndex < size) {
            BillDetailDto isDisDto;
            BillDetailDto lastInvDto = detailDtos.get(nextInvMaxIndex);
            if (InvoiceCoreService.isDisLine(lastInvDto).booleanValue()) {
                return nextInvMaxIndex == i;
            }
            int j = nextInvMaxIndex + 1;
            if (j < size && InvoiceCoreService.isDisLine(isDisDto = detailDtos.get(j)).booleanValue()) {
                return nextInvMaxIndex - 1 == i;
            }
            return nextInvMaxIndex == i;
        }
        return i == size - 1;
    }

    public static Boolean isLastLine(BillSubjectDto billSubjectDto, int index) {
        int lastIndex;
        List<BillDetailDto> billDetailDtos = billSubjectDto.getBillDList();
        BillDetailDto lastDto = billDetailDtos.get(lastIndex = billDetailDtos.size() - 1);
        if (InvoiceCoreService.isDisLine(lastDto).booleanValue()) {
            if (lastIndex - 1 == index) {
                return true;
            }
            return false;
        }
        if (lastIndex == index) {
            return true;
        }
        return false;
    }

    private static int saveInvoince(SmsResultDto smsResultDto, SmruleConfigDto configDto, BillSubjectDto billSubjectDto, Integer lastIndex, Integer index, String remark, String fristLineNote, AtomicDouble remarkAmountSum) {
        List<InvoiceSubjectDto> invoiceSList = smsResultDto.getInvoiceSList();
        if (CollectionUtils.isEmpty(invoiceSList)) {
            invoiceSList = new ArrayList<InvoiceSubjectDto>();
        }
        Boolean isLast = false;
        if (remark.equals("\u6700\u540e\u4e00\u884c\u5f00\u7968")) {
            isLast = true;
        }
        InvoiceSubjectDto invoiceSubjectDto = InvoiceCoreService.saveOneInvoice(smsResultDto, configDto, billSubjectDto, lastIndex, index, fristLineNote, remarkAmountSum, isLast);
        invoiceSubjectDto.setRemark(remark);
        invoiceSList.add(invoiceSubjectDto);
        smsResultDto.setInvoiceSList(invoiceSList);
        return invoiceSubjectDto.getPageIndex();
    }

    private static InvoiceSubjectDto saveOneInvoice(SmsResultDto smsResultDto, SmruleConfigDto configDto, BillSubjectDto billSubjectDto, Integer lastIndex, Integer index, String fristLineNote, AtomicDouble remarkAmountSum, Boolean isLast) {
        String remark;
        Object[] remarkLines;
        BillDetailDto tmpDto;
        InvoiceSubjectDto invoiceSubjectDto = new InvoiceSubjectDto();
        List<BillDetailDto> detailDtos = billSubjectDto.getBillDList();
        String invSN = com.szhtxx.etcloud.smser.utils.StringUtils.getInvSN();
        int useLineNote = configDto.getInvNoteUseLineNote();
        Boolean mccDistinct = configDto.isMccRepeat();
        int remarkSplitNum = configDto.getRemarkSplitNum();
        invoiceSubjectDto.setInvoiceNO(invSN);
        invoiceSubjectDto.setBillNO(billSubjectDto.getBillNO());
        invoiceSubjectDto.setInvoiceKind(billSubjectDto.getInvKind());
        invoiceSubjectDto.setInvoiceNote(billSubjectDto.getNotes());
        int curInvIndex = index;
        int j = index + 1;
        if (j < detailDtos.size() && InvoiceCoreService.isDisLine(tmpDto = detailDtos.get(j)).booleanValue()) {
            ++curInvIndex;
        }
        ArrayList<InvoiceDetailDto> invoiceDetailList = new ArrayList<InvoiceDetailDto>(10);
        int i = 0;
        i = lastIndex == -1 ? 0 : lastIndex + 1;
        int lineNum = 0;
        ArrayList<String> billNOList = new ArrayList<String>();
        while (i <= curInvIndex) {
            BillDetailDto billDetailDto = detailDtos.get(i);
            if (configDto.getEffectiveRange() == 1 && 1 != billDetailDto.getSplitSign() && billDetailDto.getDetailIdSet().size() <= 1 && !InvoiceCoreService.isDisLine(billDetailDto).booleanValue()) {
                InvoiceSplitCoreService.dealDetailByRule(billDetailDto, configDto, detailDtos, i);
            }
            InvoiceDetailDto invoiceDetailDto = InvoiceCoreService.setInvDetailDto(invoiceSubjectDto, billDetailDto, invSN, useLineNote, fristLineNote, mccDistinct, lineNum);
            invoiceDetailList.add(invoiceDetailDto);
            Set<BillDetailIdDto> detailIdSet = billDetailDto.getDetailIdSet();
            for (BillDetailIdDto detailIdDto : detailIdSet) {
                if (billNOList.contains(detailIdDto.getBillNO())) continue;
                billNOList.add(detailIdDto.getBillNO());
            }
            ++lineNum;
            ++i;
        }
        Set<String> netBillNoSet = billSubjectDto.getNegBillNoSet();
        if (CollectionUtils.isNotEmpty(netBillNoSet)) {
            netBillNoSet.forEach(billNo -> {
                if (!billNOList.contains(billNo)) {
                    billNOList.add((String)billNo);
                }
            });
            billSubjectDto.setNegBillNoSet(null);
        }
        List<String> lineNotes = invoiceSubjectDto.getLineNotes();
        ArrayList splitLineNotes = new ArrayList();
        if (configDto.isMccRepeat()) {
            invoiceSubjectDto.setInvoiceNote(StringUtils.join((Object[])lineNotes.toArray(), (String)configDto.getMccNoteStr()));
        } else {
            lineNotes.forEach(t -> {
                List<String> mergeList = Arrays.asList(t.split("\\".equals(configDto.getMccNoteStr()) ? "\\\\" : configDto.getMccNoteStr()));
                if (mergeList.size() > 0) {
                    for (String note : mergeList) {
                        if (splitLineNotes.contains(note)) continue;
                        splitLineNotes.add(note);
                    }
                }
            });
            invoiceSubjectDto.setInvoiceNote(StringUtils.join((Object[])splitLineNotes.toArray(), (String)configDto.getMccNoteStr()));
        }
        invoiceSubjectDto.setInvoiceDetailList(invoiceDetailList);
        invoiceSubjectDto.setBillNOList(billNOList);
        Integer listType = configDto.getListType();
        if (listType == 1) {
            invoiceSubjectDto.setListFlag(1);
        } else if (listType == 2) {
            invoiceSubjectDto.setListFlag(0);
        } else {
            if (invoiceDetailList.size() > 8) {
                invoiceSubjectDto.setListFlag(1);
            } else {
                invoiceSubjectDto.setListFlag(0);
            }
            if (EnumType.InvKindEnum.ROLL.getValue().equals(billSubjectDto.getInvKind())) {
                invoiceSubjectDto.setListFlag(0);
            }
        }
        invoiceSubjectDto.setPageIndex(curInvIndex);
        if (remarkSplitNum > 0 && (remarkLines = (remark = invoiceSubjectDto.getInvoiceNote()).split("\n")).length > remarkSplitNum - 1) {
            String remarkAmountLine = remarkLines[remarkSplitNum - 1];
            String regex = "(\\-|\\+)?[0-9]+(\\.[0-9]{2})?";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(remarkAmountLine);
            if (matcher.find()) {
                BigDecimal remarkAmount = new BigDecimal(matcher.group());
                BigDecimal newAmount = remarkAmount.multiply(invoiceSubjectDto.getAmounts()).divide(billSubjectDto.getSumAmtJE(), 2, 4);
                BigDecimal sum = new BigDecimal(String.valueOf(remarkAmountSum.get()));
                if (isLast.booleanValue()) {
                    newAmount = remarkAmount.subtract(sum);
                }
                sum = sum.add(newAmount);
                remarkAmountSum.set(sum.doubleValue());
                remarkAmountLine = remarkAmountLine.replace(matcher.group(), newAmount.toString());
            }
            remarkLines[remarkSplitNum - 1] = remarkAmountLine;
            invoiceSubjectDto.setInvoiceNote(StringUtils.join((Object[])remarkLines, (String)"\n"));
        }
        return invoiceSubjectDto;
    }

    public static void main(String[] args) {
        AtomicInteger i = new AtomicInteger(0);
        InvoiceCoreService.add(i);
        System.out.print(i);
    }

    private static void add(AtomicInteger i) {
        i.getAndAdd(100);
        if (i.get() == 100) {
            System.out.println(true);
        }
        System.out.println(i);
    }

    private static InvoiceDetailDto setInvDetailDto(InvoiceSubjectDto invoiceSubjectDto, BillDetailDto billDetailDto, String invSN, int useLineNote, String fristLineNote, boolean mccDistinct, int lineNum) {
        BigDecimal invDetailErr;
        BigDecimal origTaxAmt = billDetailDto.getTaxAmt();
        billDetailDto.setTaxAmt(origTaxAmt.setScale(2, 4));
        int includeTax = billDetailDto.getIncludeTax();
        InvoiceDetailDto invoiceDETAIL = new InvoiceDetailDto();
        invoiceDETAIL.setInvoiceNO(invSN);
        invoiceDETAIL.setInvoiceDetailNO(com.szhtxx.etcloud.smser.utils.StringUtils.getInvSN());
        invoiceDETAIL.setGoodsClass(billDetailDto.getGoodsClass());
        invoiceDETAIL.setGoodsCode(billDetailDto.getGoodsCode());
        invoiceDETAIL.setGoodsName(billDetailDto.getGoodsName());
        invoiceDETAIL.setGoodsModel(billDetailDto.getGoodsModel());
        invoiceDETAIL.setGoodsUnit(billDetailDto.getGoodsUnit());
        invoiceDETAIL.setAmts(billDetailDto.getAmts());
        invoiceDETAIL.setPrice(billDetailDto.getPrice());
        invoiceDETAIL.setAmounts(billDetailDto.getAmounts());
        invoiceDETAIL.setTaxRate(billDetailDto.getTaxRate());
        invoiceDETAIL.setTaxAmt(billDetailDto.getTaxAmt());
        invoiceDETAIL.setGoodsNoVer(billDetailDto.getGoodsNoVer());
        invoiceDETAIL.setGoodsTaxNo(billDetailDto.getGoodsTaxNo());
        invoiceDETAIL.setTaxPre(billDetailDto.getTaxPre());
        invoiceDETAIL.setTaxPreCon(billDetailDto.getTaxPreCon());
        invoiceDETAIL.setZeroTax(billDetailDto.getZeroTax());
        invoiceDETAIL.setCropGoodsNo(billDetailDto.getCropGoodsNo());
        invoiceDETAIL.setLineProperty(billDetailDto.getLineProperty());
        invoiceDETAIL.setLineNum(lineNum);
        invoiceDETAIL.setIncludeTax(0);
        invoiceDETAIL.setTaxAmounts(billDetailDto.getAmountsIncTax());
        invoiceDETAIL.setAmountsIncTax(billDetailDto.getAmountsIncTax());
        invoiceDETAIL.setBillDetailNO(billDetailDto.getBillDetailNO());
        invoiceDETAIL.setBillNO(billDetailDto.getBillNO());
        invoiceDETAIL.setPriceIncTax(billDetailDto.getPriceIncTax());
        invoiceDETAIL.setBy1(billDetailDto.getBy1());
        invoiceDETAIL.setSplitSign(billDetailDto.getSplitSign());
        BigDecimal taxDeduction = billDetailDto.getTaxDeduction();
        BigDecimal taxRate = invoiceDETAIL.getTaxRate();
        BigDecimal invTaxAmt = invoiceDETAIL.getTaxAmt();
        BigDecimal tmpTaxAmt = BigDecimal.ZERO;
        if (taxDeduction == null || taxDeduction.compareTo(BigDecimal.ZERO) == 0) {
            invoiceDETAIL.setTaxDeduction("");
            tmpTaxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(billDetailDto.getAmounts(), null, taxRate, 4);
            invDetailErr = tmpTaxAmt.subtract(invTaxAmt);
            invoiceDETAIL.setInvDetailErr(invDetailErr);
        } else {
            invoiceDETAIL.setTaxDeduction(taxDeduction.toPlainString());
            tmpTaxAmt = calcUtilMethods.calcTaxAmtByNoTaxMoneyDec(billDetailDto.getAmounts(), taxDeduction, taxRate, 4);
            invDetailErr = tmpTaxAmt.subtract(invTaxAmt);
            invoiceDETAIL.setInvDetailErr(invDetailErr);
            invoiceSubjectDto.setIsTaxDe(1);
            invoiceSubjectDto.setTaxDeduction(String.valueOf(billDetailDto.getTaxDeduction()));
        }
        BigDecimal invErr = invoiceSubjectDto.getInvErr();
        invErr = invErr.add(invoiceDETAIL.getInvDetailErr());
        invoiceSubjectDto.setInvErr(invErr);
        BigDecimal amtSum = invoiceSubjectDto.getAmounts();
        amtSum = amtSum.add(invoiceDETAIL.getAmounts());
        invoiceSubjectDto.setAmounts(amtSum);
        BigDecimal taxAmtSum = invoiceSubjectDto.getTaxAmt();
        taxAmtSum = taxAmtSum.add(invoiceDETAIL.getTaxAmt());
        invoiceSubjectDto.setTaxAmt(taxAmtSum);
        boolean existsInvTaxRate = false;
        List<BigDecimal> invTaxRate = invoiceSubjectDto.getInvTaxRate();
        int i = 0;
        while (i < invTaxRate.size()) {
            if (billDetailDto.getTaxRate().compareTo(invTaxRate.get(i)) == 0) {
                existsInvTaxRate = true;
                break;
            }
            ++i;
        }
        if (!existsInvTaxRate) {
            invTaxRate.add(billDetailDto.getTaxRate());
        }
        if (useLineNote == 1) {
            if (StringUtils.isNotEmpty((CharSequence)billDetailDto.getLineNote())) {
                List<String> lineNotes = invoiceSubjectDto.getLineNotes();
                if (mccDistinct || !lineNotes.contains(billDetailDto.getLineNote())) {
                    lineNotes.add(billDetailDto.getLineNote());
                }
                invoiceSubjectDto.setLineNotes(lineNotes);
            }
        } else if (fristLineNote != null) {
            ArrayList<String> lineNotes = new ArrayList<String>();
            lineNotes.add(fristLineNote);
            invoiceSubjectDto.setLineNotes(lineNotes);
        }
        invoiceDETAIL.setDetailIdSet(billDetailDto.getDetailIdSet());
        if (invoiceDETAIL.getTaxAmt().compareTo(BigDecimal.ZERO) < 0 && invoiceDETAIL.getLineProperty() != 4) {
            throw new EtcRuleException("\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        return invoiceDETAIL;
    }

    public static void taxAmtCheck(BillSubjectDto billSubjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto) {
        List<InvoiceSubjectDto> list = smsResultDto.getInvoiceSList();
        if (configDto.getTotalTaxamtCount() == 1) {
            int k = 0;
            while (k < list.size()) {
                InvoiceDetailDto disDto;
                int j;
                InvoiceDetailDto invoiceDetailDto;
                InvoiceSubjectDto invoiceSubjectDto = list.get(k);
                BigDecimal invDetailErr = BigDecimal.ZERO;
                for (InvoiceDetailDto invoiceDetailDto2 : invoiceSubjectDto.getInvoiceDetailList()) {
                    invDetailErr = invDetailErr.add(invoiceDetailDto2.getInvDetailErr());
                }
                if (invDetailErr.abs().compareTo(new BigDecimal("1.27")) > 0) {
                    int i = 0;
                    while (i < invoiceSubjectDto.getInvoiceDetailList().size()) {
                        invoiceDetailDto = invoiceSubjectDto.getInvoiceDetailList().get(i);
                        if ((EnumType.LinePropertyEnum.FOUR.getValue().compareTo(invoiceDetailDto.getLineProperty()) != 0 || invoiceDetailDto.getAmounts().compareTo(BigDecimal.ZERO) >= 0) && invoiceDetailDto.getSplitSign() == 1) {
                            invoiceDetailDto.setTaxAmt(invoiceDetailDto.getTaxAmt().add(invoiceDetailDto.getInvDetailErr()));
                            invoiceSubjectDto.setTaxAmt(invoiceSubjectDto.getTaxAmt().add(invoiceDetailDto.getInvDetailErr()));
                            invDetailErr.subtract(invoiceDetailDto.getInvDetailErr());
                            if (billSubjectDto.getIncludeTax() == 1) {
                                invoiceDetailDto.setAmounts(invoiceDetailDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                                invoiceSubjectDto.setAmounts(invoiceSubjectDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                            } else {
                                invoiceDetailDto.setAmountsIncTax(invoiceDetailDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                            }
                            j = i + 1;
                            if (j < invoiceSubjectDto.getInvoiceDetailList().size()) {
                                disDto = invoiceSubjectDto.getInvoiceDetailList().get(j);
                                if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(disDto.getLineProperty()) == 0 && disDto.getAmounts().compareTo(BigDecimal.ZERO) < 0) {
                                    disDto.setTaxAmt(disDto.getTaxAmt().add(disDto.getInvDetailErr()));
                                    invoiceSubjectDto.setTaxAmt(invoiceSubjectDto.getTaxAmt().add(disDto.getInvDetailErr()));
                                    invDetailErr.subtract(disDto.getInvDetailErr());
                                    if (billSubjectDto.getIncludeTax() == 1) {
                                        disDto.setAmounts(disDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                        invoiceSubjectDto.setAmounts(invoiceSubjectDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                    } else {
                                        disDto.setAmountsIncTax(disDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                    }
                                }
                            }
                            if (invDetailErr.abs().compareTo(new BigDecimal("1.27")) <= 0) break;
                        }
                        ++i;
                    }
                }
                if (invDetailErr.abs().compareTo(new BigDecimal("1.27")) > 0) {
                    int i = 0;
                    while (i < invoiceSubjectDto.getInvoiceDetailList().size()) {
                        invoiceDetailDto = invoiceSubjectDto.getInvoiceDetailList().get(i);
                        if ((EnumType.LinePropertyEnum.FOUR.getValue().compareTo(invoiceDetailDto.getLineProperty()) != 0 || invoiceDetailDto.getAmounts().compareTo(BigDecimal.ZERO) >= 0) && invoiceDetailDto.getSplitSign() != 1) {
                            invoiceDetailDto.setTaxAmt(invoiceDetailDto.getTaxAmt().add(invoiceDetailDto.getInvDetailErr()));
                            invoiceSubjectDto.setTaxAmt(invoiceSubjectDto.getTaxAmt().add(invoiceDetailDto.getInvDetailErr()));
                            invDetailErr.subtract(invoiceDetailDto.getInvDetailErr());
                            if (billSubjectDto.getIncludeTax() == 1) {
                                invoiceDetailDto.setAmounts(invoiceDetailDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                                invoiceSubjectDto.setAmounts(invoiceSubjectDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                            } else {
                                invoiceDetailDto.setAmountsIncTax(invoiceDetailDto.getAmounts().subtract(invoiceDetailDto.getInvDetailErr()));
                            }
                            j = i + 1;
                            if (j < invoiceSubjectDto.getInvoiceDetailList().size()) {
                                disDto = invoiceSubjectDto.getInvoiceDetailList().get(j);
                                if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(disDto.getLineProperty()) == 0 && disDto.getAmounts().compareTo(BigDecimal.ZERO) < 0) {
                                    disDto.setTaxAmt(disDto.getTaxAmt().add(disDto.getInvDetailErr()));
                                    invoiceSubjectDto.setTaxAmt(invoiceSubjectDto.getTaxAmt().add(disDto.getInvDetailErr()));
                                    invDetailErr.subtract(disDto.getInvDetailErr());
                                    if (billSubjectDto.getIncludeTax() == 1) {
                                        disDto.setAmounts(disDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                        invoiceSubjectDto.setAmounts(invoiceSubjectDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                    } else {
                                        disDto.setAmountsIncTax(disDto.getAmounts().subtract(disDto.getInvDetailErr()));
                                    }
                                }
                            }
                            if (invDetailErr.abs().compareTo(new BigDecimal("1.27")) <= 0) break;
                        }
                        ++i;
                    }
                }
                ++k;
            }
        } else {
            int k = 0;
            while (k < list.size()) {
                InvoiceSubjectDto invoiceSubjectDto = list.get(k);
                BigDecimal invDetailErrs = BigDecimal.ZERO;
                for (InvoiceDetailDto invoiceDetailDto : invoiceSubjectDto.getInvoiceDetailList()) {
                    invDetailErrs = invDetailErrs.add(invoiceDetailDto.getInvDetailErr());
                }
                if (invDetailErrs.abs().compareTo(new BigDecimal("1.27")) > 0) {
                    BigDecimal invDetailErr = BigDecimal.ZERO;
                    int i = 0;
                    while (i < invoiceSubjectDto.getInvoiceDetailList().size()) {
                        InvoiceDetailDto invoiceDetailDto = invoiceSubjectDto.getInvoiceDetailList().get(i);
                        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(invoiceDetailDto.getLineProperty()) != 0 || invoiceDetailDto.getAmounts().compareTo(BigDecimal.ZERO) >= 0) {
                            invDetailErr = invDetailErr.add(invoiceDetailDto.getInvDetailErr());
                            int j = i + 1;
                            if (j < invoiceSubjectDto.getInvoiceDetailList().size()) {
                                InvoiceDetailDto disDto = invoiceSubjectDto.getInvoiceDetailList().get(j);
                                if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(disDto.getLineProperty()) == 0 && disDto.getAmounts().compareTo(BigDecimal.ZERO) < 0) {
                                    invDetailErr = invDetailErr.add(disDto.getInvDetailErr());
                                }
                            }
                            if (invDetailErr.abs().compareTo(new BigDecimal("1.27")) > 0) {
                                throw new EtcRuleException("\u6574\u5f20\u53d1\u7968\u660e\u7ec6\u884c\u7a0e\u989d\u8bef\u5dee\u4e4b\u548c\u8d85\u8fc71.27\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5f00\u7968\uff0c\u8bf7\u8c03\u6574\u7a0e\u989d\u6570\u503c\u6216\u8c03\u6574\u62c6\u5408\u89c4\u5219\uff01");
                            }
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
    }

    public static void invoiceAverageLimit(BillSubjectDto subjectDto, SmruleConfigDto configDto, SmsResultDto smsResultDto) {
        subjectDto.getBillDList().stream().map(BillDetailDto::getAmounts).reduce(BigDecimal::add).ifPresent(subjectDto::setSumAmtJE);
        subjectDto.getBillDList().stream().map(BillDetailDto::getTaxAmt).reduce(BigDecimal::add).ifPresent(subjectDto::setSumAmtSE);
        BigDecimal invLimitAmt = configDto.getInvLimitAmt();
        configDto.setFinalLimitAmt(invLimitAmt);
    }
}

